# Alignierung

nostad_orig<-subset(nostad, select=c("subkorpus",
                                     "text",
                                     "seg",
                                     "tokID",
                                     "tok",
                                     "lemma",
                                     "pos",
                                     "govID",
                                     "dep"),
                            subset=(edition=="orig"))


colnames(nostad_orig)<-c("subkorpus",
                         "text",
                         "seg",
                         "tokID",
                         "orig_tok",
                         "orig_lemma",
                         "orig_pos",
                         "orig_govID",
                         "orig_dep")

nostad_norm<-subset(nostad, select=c("text",
                                     "tokID",
                                     "tok",
                                     "lemma",
                                     "pos",
                                     "govID",
                                     "dep"),
                            subset=(edition=="norm"))


colnames(nostad_norm)<-c("text",
                         "tokID",
                         "norm_tok",
                         "norm_lemma",
                         "norm_pos",
                         "norm_govID",
                         "norm_dep")

nostad_align<-merge.data.frame(nostad_orig, nostad_norm,
                               by.x=c("text", "tokID"),
                               by.y=c("text", "tokID"))

rm(nostad_orig, nostad_norm)

# Originaltext-Regent-Information hinzufügen

tmp<-subset(nostad, select=c("text",
                             "tokID",
                             "tok",
                             "lemma",
                             "pos"),
                    subset=(edition=="orig"))

colnames(tmp)<-c("text",
                 "orig_govID",
                 "orig_gov_tok",
                 "orig_gov_lemma",
                 "orig_gov_pos")

nostad_align<-merge.data.frame(nostad_align, tmp,
                               by.x=c("text", "orig_govID"),
                               by.y=c("text", "orig_govID"),
                               all.x=TRUE)

rm(tmp)

# Normalisierung-Regent-Information hinzufügen

tmp<-subset(nostad, select=c("text",
                             "tokID",
                             "tok",
                             "lemma",
                             "pos"),
                    subset=(edition=="norm"))

colnames(tmp)<-c("text",
                 "norm_govID",
                 "norm_gov_tok",
                 "norm_gov_lemma",
                 "norm_gov_pos")

nostad_align<-merge.data.frame(nostad_align, tmp,
                               by.x=c("text", "norm_govID"),
                               by.y=c("text", "norm_govID"),
                               all.x=TRUE)

rm(tmp)

# Spalten sortieren

nostad_align<-subset(nostad_align, select=c("subkorpus",
                                            "text",
                                            "seg",
                                            "tokID",
                                            "orig_tok",
                                            "orig_lemma",
                                            "orig_pos",
                                            "orig_govID",
                                            "orig_dep",
                                            "orig_gov_tok",
                                            "orig_gov_lemma",
                                            "orig_gov_pos",
                                            "norm_tok",
                                            "norm_lemma",
                                            "norm_pos",
                                            "norm_govID",
                                            "norm_dep",
                                            "norm_gov_tok",
                                            "norm_gov_lemma",
                                            "norm_gov_pos"))

# NoSta-D-unicum aligniert

unicum_align<-subset(nostad_align, subset=(subkorpus=="unicum"))

unicum_align$sort<-as.integer(substr(unicum_align$tokID,
                                     3,
                                     nchar(unicum_align$tokID)))

unicum_align<-unicum_align[order(unicum_align[,"sort"]),]

unicum_align$sort<-NULL

# NoSta-D-bematac aligniert

bematac_align<-subset(nostad_align, subset=(subkorpus=="bematac"))

bematac_align$sort<-as.integer(as.factor(bematac_align$text))*10000+
                    as.integer(substr(bematac_align$tokID,
                                     3,
                                     nchar(bematac_align$tokID)))

bematac_align<-bematac_align[order(bematac_align[,"sort"]),]

bematac_align$sort<-NULL

# NoSta-D-tuebadz aligniert

tuebadz_align<-subset(nostad_align, subset=(subkorpus=="tuebadz"))

tuebadz_align$sort<-as.integer(substr(tuebadz_align$tokID,
                                     3,
                                     nchar(tuebadz_align$tokID)))

tuebadz_align<-tuebadz_align[order(tuebadz_align[,"sort"]),]

tuebadz_align$sort<-NULL

# NoSta-D-kafka aligniert

kafka_align<-subset(nostad_align, subset=(subkorpus=="kafka"))

kafka_align$sort<-as.integer(substr(kafka_align$tokID,
                                     3,
                                     nchar(kafka_align$tokID)))

kafka_align<-kafka_align[order(kafka_align[,"sort"]),]

kafka_align$sort<-NULL

# NoSta-D-anselm aligniert

anselm_align<-subset(nostad_align, subset=(subkorpus=="anselm"))

anselm_align$sort<-as.integer(substr(anselm_align$tokID,
                                     3,
                                     nchar(anselm_align$tokID)))

anselm_align<-anselm_align[order(anselm_align[,"sort"]),]

anselm_align$sort<-NULL

# NoSta-D-falko aligniert

falko_align<-subset(nostad_align, subset=(subkorpus=="falko"))

falko_align$sort<-as.integer(substr(falko_align$tokID,
                                     3,
                                     nchar(falko_align$tokID)))

falko_align<-falko_align[order(falko_align[,"sort"]),]

falko_align$sort<-NULL