segmente<-data.frame("Subkorpus"=c("unicum",
                                   "bematac",
                                   "tuebadz",
                                   "kafka",
                                   "anselm",
                                   "falko"),
                     "Anzahl"=rep(NA, 6),
                     "Mittel"=rep(NA, 6),
                     "SD"=rep(NA, 6),
                     "Median"=rep(NA, 6))

nostad$tmp<-paste(nostad$text,nostad$edition,nostad$seg)

unicum.segmente<-with(subset(nostad, subset=(!is.na(dep) &
                             subkorpus=="unicum" &
                             edition=="orig")),
                      table(tmp))

segmente$Anzahl[segmente$Subkorpus=="unicum"]<-length(unicum.segmente)
segmente$Mittel[segmente$Subkorpus=="unicum"]<-mean(unicum.segmente)
segmente$SD[segmente$Subkorpus=="unicum"]<-sd(unicum.segmente)
segmente$Median[segmente$Subkorpus=="unicum"]<-median(unicum.segmente)

bematac.segmente<-with(subset(nostad, subset=(!is.na(dep) &
                              subkorpus=="bematac" &
                              edition=="orig")),
                       table(tmp))

segmente$Anzahl[segmente$Subkorpus=="bematac"]<-length(bematac.segmente)
segmente$Mittel[segmente$Subkorpus=="bematac"]<-mean(bematac.segmente)
segmente$SD[segmente$Subkorpus=="bematac"]<-sd(bematac.segmente)
segmente$Median[segmente$Subkorpus=="bematac"]<-median(bematac.segmente)

tuebadz.segmente<-with(subset(nostad, subset=(!is.na(dep) &
                              subkorpus=="tuebadz" &
                              edition=="orig")),
                       table(tmp))

segmente$Anzahl[segmente$Subkorpus=="tuebadz"]<-length(tuebadz.segmente)
segmente$Mittel[segmente$Subkorpus=="tuebadz"]<-mean(tuebadz.segmente)
segmente$SD[segmente$Subkorpus=="tuebadz"]<-sd(tuebadz.segmente)
segmente$Median[segmente$Subkorpus=="tuebadz"]<-median(tuebadz.segmente)

kafka.segmente<-with(subset(nostad, subset=(!is.na(dep) &
                            subkorpus=="kafka" &
                            edition=="orig")),
                     table(tmp))

segmente$Anzahl[segmente$Subkorpus=="kafka"]<-length(kafka.segmente)
segmente$Mittel[segmente$Subkorpus=="kafka"]<-mean(kafka.segmente)
segmente$SD[segmente$Subkorpus=="kafka"]<-sd(kafka.segmente)
segmente$Median[segmente$Subkorpus=="kafka"]<-median(kafka.segmente)

anselm.segmente<-with(subset(nostad, subset=(!is.na(dep) &
                             subkorpus=="anselm" &
                             edition=="orig")),
                      table(tmp))

segmente$Anzahl[segmente$Subkorpus=="anselm"]<-length(anselm.segmente)
segmente$Mittel[segmente$Subkorpus=="anselm"]<-mean(anselm.segmente)
segmente$SD[segmente$Subkorpus=="anselm"]<-sd(anselm.segmente)
segmente$Median[segmente$Subkorpus=="anselm"]<-median(anselm.segmente)

falko.segmente<-with(subset(nostad, subset=(!is.na(dep) &
                            subkorpus=="falko" &
                            edition=="orig")),
                      table(tmp))

segmente$Anzahl[segmente$Subkorpus=="falko"]<-length(falko.segmente)
segmente$Mittel[segmente$Subkorpus=="falko"]<-mean(falko.segmente)
segmente$SD[segmente$Subkorpus=="falko"]<-sd(falko.segmente)
segmente$Median[segmente$Subkorpus=="falko"]<-median(falko.segmente)

nostad$tmp<-NULL

segmente
rm(segmente)

# H0: Mittlere-Satzlnge in NoSta-D-unicum gleich der aus NoSta-D-bematac

t.test(unicum.segmente, bematac.segmente, alternative="two.sided")

# H0: Mittlere-Satzlnge in NoSta-D-unicum gleich der aus NoSta-D-tuebadz

t.test(unicum.segmente, tuebadz.segmente, alternative="two.sided")

# H0: Mittlere-Satzlnge in NoSta-D-bematac gleich der aus NoSta-D-tuebadz

t.test(bematac.segmente, tuebadz.segmente, alternative="two.sided")

rm(unicum.segmente,
   bematac.segmente,
   tuebadz.segmente,
   kafka.segmente,
   anselm.segmente,
   falko.segmente)