################################################################################

# X-Dependenzen in unicum:

tb1<-with(subset(nostad, subset=(!is.na(nostad$dep) &
                                 nostad$subkorpus=="unicum" &
                                 nostad$edition=="orig")),
          table(substr(dep, 1, 1)!="X"))

# X-Dependenzen in bematac:

tb2<-with(subset(nostad, subset=(!is.na(nostad$dep) &
                                 nostad$subkorpus=="bematac" &
                                 nostad$edition=="orig")),
          table(substr(dep, 1, 1)!="X"))

# X-Dependenzen in tuebadz

tb3<-with(subset(nostad, subset=(!is.na(nostad$dep) &
                                 nostad$subkorpus=="tuebadz" &
                                 nostad$edition=="orig")),
          table(substr(dep, 1, 1)!="X"))

# X-Dependenzen in kafka:

tb4<-with(subset(nostad, subset=(!is.na(nostad$dep) &
                                 nostad$subkorpus=="kafka" &
                                 nostad$edition=="orig")),
          table(substr(dep, 1, 1)!="X"))

# X-Dependenzen in anselm:

tb5<-with(subset(nostad, subset=(!is.na(nostad$dep) &
                                 nostad$subkorpus=="anselm" &
                                 nostad$edition=="orig")),
          table(substr(dep, 1, 1)!="X"))

# X-Dependenzen in falko

tb6<-with(subset(nostad, subset=(!is.na(nostad$dep) &
                                 nostad$subkorpus=="falko" &
                                 nostad$edition=="orig")),
          table(substr(dep, 1, 1)!="X"))

tb<-rbind(tb1, tb2, tb3, tb4, tb5, tb6)
dimnames(tb)<-list(Subkorpus=c("NoSta-D-unicum",
                               "NoSta-D-bematac",
                               "NoSta-D-tuebadz",
                               "NoSta-D-kafka",
                               "NoSta-D-anselm",
                               "NoSta-D-falko"),
                   "X-Dependenz"=c("Ja",
                                   "Nein"))
rm(tb1, tb2, tb3, tb4, tb5, tb6)

for(i in 1:length(tb[,1]))
  {
  if(tb[i,1]==tb[i,2]) tb[i,1]<-0
  }
rm(i)

tb

# H0: X-Dependenzen in NoSta-D-unicum genauso wahrscheinlich wie in NoSta-D-bematac

binom.test(tb["NoSta-D-unicum",1], sum(tb["NoSta-D-unicum",]), tb["NoSta-D-bematac",1]/tb["NoSta-D-bematac",2])


# H0: X-Dependenzen in NoSta-D-unicum genauso wahrscheinlich wie in NoSta-D-tuebadz

binom.test(tb["NoSta-D-unicum",1], sum(tb["NoSta-D-unicum",]), tb["NoSta-D-tuebadz",1]/tb["NoSta-D-tuebadz",2])


# Alle vergebenen X-Dependenzlabels

as.character(levels(as.factor(nostad$dep[!is.na(nostad$dep) & substr(nostad$dep, 1, 1)=="X"])))

rm(tb)