/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapName;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.SearchResultWithControls;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;

final class LdapSearchEnumeration
extends LdapNamingEnumeration {
    private Name startName;
    private LdapCtx.SearchArgs searchArgs = null;

    protected void update(LdapNamingEnumeration ldapNamingEnumeration) {
        super.update(ldapNamingEnumeration);
        LdapSearchEnumeration ldapSearchEnumeration = (LdapSearchEnumeration)ldapNamingEnumeration;
        this.startName = ldapSearchEnumeration.startName;
    }

    public void appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        this.startName = null;
        super.appendUnprocessedReferrals(ldapReferralException);
    }

    void setStartName(Name name) {
        this.startName = name;
    }

    protected LdapNamingEnumeration getReferredResults(LdapReferralContext ldapReferralContext) throws NamingException {
        return (LdapSearchEnumeration)ldapReferralContext.search(this.searchArgs.name, this.searchArgs.filter, this.searchArgs.cons);
    }

    protected NameClassPair createItem(String string, Attributes attributes, Vector vector) throws NamingException {
        String string2;
        String string3;
        Name name;
        Object object = null;
        boolean bl2 = true;
        try {
            name = new LdapName(string);
            if (this.startName != null && name.startsWith(this.startName)) {
                string3 = name.getSuffix(this.startName.size()).toString();
                string2 = name.getSuffix(this.homeCtx.currentParsedDN.size()).toString();
            } else {
                bl2 = false;
                string2 = string3 = LdapURL.toUrlString(this.homeCtx.hostname, this.homeCtx.port_number, string, this.homeCtx.hasLdapsScheme);
            }
        }
        catch (NamingException namingException) {
            bl2 = false;
            string2 = string3 = LdapURL.toUrlString(this.homeCtx.hostname, this.homeCtx.port_number, string, this.homeCtx.hasLdapsScheme);
        }
        name = new CompositeName();
        if (!string3.equals("")) {
            ((CompositeName)name).add(string3);
        }
        CompositeName compositeName = new CompositeName();
        if (!string2.equals("")) {
            compositeName.add(string2);
        }
        this.homeCtx.setParents(attributes, compositeName);
        if (this.searchArgs.cons.getReturningObjFlag()) {
            if (attributes.get(Obj.JAVA_ATTRIBUTES[2]) != null) {
                object = Obj.decodeObject(attributes);
            }
            if (object == null) {
                object = new LdapCtx(this.homeCtx, string);
            }
            try {
                object = DirectoryManager.getObjectInstance(object, name, bl2 ? this.homeCtx : null, this.homeCtx.envprops, attributes);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
            String[] stringArray = this.searchArgs.reqAttrs;
            if (this.searchArgs.reqAttrs != null) {
                int n2;
                BasicAttributes basicAttributes = new BasicAttributes(true);
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    basicAttributes.put(stringArray[n2], null);
                }
                for (n2 = 0; n2 < Obj.JAVA_ATTRIBUTES.length; ++n2) {
                    if (basicAttributes.get(Obj.JAVA_ATTRIBUTES[n2]) != null) continue;
                    attributes.remove(Obj.JAVA_ATTRIBUTES[n2]);
                }
            }
        }
        if (vector != null) {
            return new SearchResultWithControls(bl2 ? ((CompositeName)name).toString() : string3, object, attributes, bl2, this.homeCtx.convertControls(vector));
        }
        return new SearchResult(bl2 ? ((CompositeName)name).toString() : string3, object, attributes, bl2);
    }

    LdapSearchEnumeration(LdapCtx ldapCtx, LdapResult ldapResult, String string, LdapCtx.SearchArgs searchArgs, Continuation continuation) throws NamingException {
        super(ldapCtx, ldapResult, searchArgs.name, continuation);
        this.startName = new LdapName(string);
        this.searchArgs = searchArgs;
    }
}

