/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.awt.color.CMM;
import sun.awt.color.ICC_Transform;
import sun.security.action.LoadLibraryAction;

public abstract class ColorModel
implements Transparency {
    private long pData;
    protected int pixel_bits;
    int[] nBits;
    int transparency = 3;
    boolean supportsAlpha = true;
    boolean isAlphaPremultiplied = false;
    int numComponents = -1;
    int numColorComponents = -1;
    ColorSpace colorSpace = ColorSpace.getInstance(1000);
    int colorSpaceType = 5;
    int maxBits;
    boolean is_sRGB = true;
    protected int transferType;
    private static boolean loaded = false;
    private static ColorModel RGBdefault;
    static byte[] l8Tos8;
    static byte[] s8Tol8;
    static byte[] l16Tos8;
    static short[] s8Tol16;
    static Map g8Tos8Map;
    static Map lg16Toog8Map;
    static Map g16Tos8Map;
    static Map lg16Toog16Map;

    public int getNumColorComponents() {
        return this.numColorComponents;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public final int getTransferType() {
        return this.transferType;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = (this.supportsAlpha ? 2 : 3) + (this.isAlphaPremultiplied ? 4 : 5) + this.pixel_bits * 6 + this.transparency * 7 + this.numComponents * 8;
        if (this.nBits != null) {
            for (int i2 = 0; i2 < this.numComponents; ++i2) {
                n2 += this.nBits[i2] * (i2 + 9);
            }
        }
        return n2;
    }

    static {
        ColorModel.loadLibraries();
        ColorModel.initIDs();
        l8Tos8 = null;
        s8Tol8 = null;
        l16Tos8 = null;
        s8Tol16 = null;
        g8Tos8Map = null;
        lg16Toog8Map = null;
        g16Tos8Map = null;
        lg16Toog16Map = null;
    }

    public void finalize() {
    }

    private static native void initIDs();

    static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new LoadLibraryAction("awt"));
            loaded = true;
        }
    }

    public final boolean hasAlpha() {
        return this.supportsAlpha;
    }

    public final boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    static byte[] getLinearRGB16TosRGB8LUT() {
        if (l16Tos8 == null) {
            l16Tos8 = new byte[65536];
            for (int i2 = 0; i2 <= 65535; ++i2) {
                float f2 = (float)i2 / 65535.0f;
                float f3 = f2 <= 0.0031308f ? f2 * 12.92f : 1.055f * (float)Math.pow(f2, 0.4166666666666667) - 0.055f;
                ColorModel.l16Tos8[i2] = (byte)Math.round(f3 * 255.0f);
            }
        }
        return l16Tos8;
    }

    static byte[] getLinearRGB8TosRGB8LUT() {
        if (l8Tos8 == null) {
            l8Tos8 = new byte[256];
            for (int i2 = 0; i2 <= 255; ++i2) {
                float f2 = (float)i2 / 255.0f;
                float f3 = f2 <= 0.0031308f ? f2 * 12.92f : 1.055f * (float)Math.pow(f2, 0.4166666666666667) - 0.055f;
                ColorModel.l8Tos8[i2] = (byte)Math.round(f3 * 255.0f);
            }
        }
        return l8Tos8;
    }

    static byte[] getsRGB8ToLinearRGB8LUT() {
        if (s8Tol8 == null) {
            s8Tol8 = new byte[256];
            for (int i2 = 0; i2 <= 255; ++i2) {
                float f2 = (float)i2 / 255.0f;
                float f3 = f2 <= 0.04045f ? f2 / 12.92f : (float)Math.pow((f2 + 0.055f) / 1.055f, 2.4);
                ColorModel.s8Tol8[i2] = (byte)Math.round(f3 * 255.0f);
            }
        }
        return s8Tol8;
    }

    public int[] getComponentSize() {
        if (this.nBits != null) {
            return (int[])this.nBits.clone();
        }
        return null;
    }

    static short[] getsRGB8ToLinearRGB16LUT() {
        if (s8Tol16 == null) {
            s8Tol16 = new short[256];
            for (int i2 = 0; i2 <= 255; ++i2) {
                float f2 = (float)i2 / 255.0f;
                float f3 = f2 <= 0.04045f ? f2 / 12.92f : (float)Math.pow((f2 + 0.055f) / 1.055f, 2.4);
                ColorModel.s8Tol16[i2] = (short)Math.round(f3 * 65535.0f);
            }
        }
        return s8Tol16;
    }

    public abstract int getAlpha(int var1);

    public abstract int getBlue(int var1);

    public int getComponentSize(int n2) {
        if (this.nBits == null) {
            throw new NullPointerException("Number of bits array is null.");
        }
        return this.nBits[n2];
    }

    static int getDefaultTransferType(int n2) {
        if (n2 <= 8) {
            return 0;
        }
        if (n2 <= 16) {
            return 1;
        }
        if (n2 <= 32) {
            return 3;
        }
        return 32;
    }

    public abstract int getGreen(int var1);

    public int getRGB(int n2) {
        return this.getAlpha(n2) << 24 | this.getRed(n2) << 16 | this.getGreen(n2) << 8 | this.getBlue(n2) << 0;
    }

    public abstract int getRed(int var1);

    public ColorModel(int n2) {
        this.pixel_bits = n2;
        if (n2 < 1) {
            throw new IllegalArgumentException("Number of bits must be > 0");
        }
        this.numComponents = 4;
        this.numColorComponents = 3;
        this.maxBits = n2;
        this.transferType = ColorModel.getDefaultTransferType(n2);
    }

    public int[] getComponents(int n2, int[] nArray, int n3) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public int getDataElement(float[] fArray, int n2) {
        int[] nArray = this.getUnnormalizedComponents(fArray, n2, null, 0);
        return this.getDataElement(nArray, 0);
    }

    public int[] getUnnormalizedComponents(float[] fArray, int n2, int[] nArray, int n3) {
        if (this.colorSpace == null) {
            throw new UnsupportedOperationException("This method is not supported by this color model.");
        }
        if (this.nBits == null) {
            throw new UnsupportedOperationException("This method is not supported.  Unable to determine #bits per component.");
        }
        if (fArray.length - n2 < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        if (nArray == null) {
            nArray = new int[n3 + this.numComponents];
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied) {
            float f2 = fArray[n2 + this.numColorComponents];
            for (int i2 = 0; i2 < this.numColorComponents; ++i2) {
                nArray[n3 + i2] = (int)(fArray[n2 + i2] * (float)((1 << this.nBits[i2]) - 1) * f2 + 0.5f);
            }
            nArray[n3 + this.numColorComponents] = (int)(f2 * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
        } else {
            for (int i3 = 0; i3 < this.numComponents; ++i3) {
                nArray[n3 + i3] = (int)(fArray[n2 + i3] * (float)((1 << this.nBits[i3]) - 1) + 0.5f);
            }
        }
        return nArray;
    }

    public int getDataElement(int[] nArray, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public float[] getNormalizedComponents(int[] nArray, int n2, float[] fArray, int n3) {
        if (this.colorSpace == null) {
            throw new UnsupportedOperationException("This method is not supported by this color model.");
        }
        if (this.nBits == null) {
            throw new UnsupportedOperationException("This method is not supported.  Unable to determine #bits per component.");
        }
        if (nArray.length - n2 < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        if (fArray == null) {
            fArray = new float[this.numComponents + n3];
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied) {
            float f2 = nArray[n2 + this.numColorComponents];
            if ((f2 /= (float)((1 << this.nBits[this.numColorComponents]) - 1)) != 0.0f) {
                for (int i2 = 0; i2 < this.numColorComponents; ++i2) {
                    fArray[n3 + i2] = (float)nArray[n2 + i2] / (f2 * (float)((1 << this.nBits[i2]) - 1));
                }
            } else {
                for (int i3 = 0; i3 < this.numColorComponents; ++i3) {
                    fArray[n3 + i3] = 0.0f;
                }
            }
            fArray[n3 + this.numColorComponents] = f2;
        } else {
            for (int i4 = 0; i4 < this.numComponents; ++i4) {
                fArray[n3 + i4] = (float)nArray[n2 + i4] / (float)((1 << this.nBits[i4]) - 1);
            }
        }
        return fArray;
    }

    public final ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    protected ColorModel(int n2, int[] nArray, ColorSpace colorSpace, boolean bl2, boolean bl3, int n3, int n4) {
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpace.getType();
        this.numColorComponents = colorSpace.getNumComponents();
        this.numComponents = this.numColorComponents + (bl2 ? 1 : 0);
        this.supportsAlpha = bl2;
        if (nArray.length < this.numComponents) {
            throw new IllegalArgumentException("Number of color/alpha components should be " + this.numComponents + " but length of bits array is " + nArray.length);
        }
        if (n3 < 1 || n3 > 3) {
            throw new IllegalArgumentException("Unknown transparency: " + n3);
        }
        if (!this.supportsAlpha) {
            this.isAlphaPremultiplied = false;
            this.transparency = 1;
        } else {
            this.isAlphaPremultiplied = bl3;
            this.transparency = n3;
        }
        this.nBits = (int[])nArray.clone();
        this.pixel_bits = n2;
        if (n2 <= 0) {
            throw new IllegalArgumentException("Number of pixel bits must be > 0");
        }
        this.maxBits = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] < 0) {
                throw new IllegalArgumentException("Number of bits must be >= 0");
            }
            if (this.maxBits >= nArray[i2]) continue;
            this.maxBits = nArray[i2];
        }
        if (this.maxBits == 0) {
            throw new IllegalArgumentException("There must be at least one component with > 0 pixel bits.");
        }
        if (colorSpace != ColorSpace.getInstance(1000)) {
            this.is_sRGB = false;
        }
        this.transferType = n4;
    }

    static boolean isLinearGRAYspace(ColorSpace colorSpace) {
        return colorSpace == CMM.GRAYspace;
    }

    static boolean isLinearRGBspace(ColorSpace colorSpace) {
        return colorSpace == CMM.LINEAR_RGBspace;
    }

    static byte[] getGray16TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        Object[] objectArray;
        if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
            return ColorModel.getLinearRGB16TosRGB8LUT();
        }
        if (g16Tos8Map != null && (objectArray = (Object[])((byte[])g16Tos8Map.get(iCC_ColorSpace))) != null) {
            return objectArray;
        }
        objectArray = new short[65536];
        for (int i2 = 0; i2 <= 65535; ++i2) {
            objectArray[i2] = (short)i2;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        objectArray = iCC_Transform.colorConvert((short[])objectArray, null);
        byte[] byArray = new byte[65536];
        int n2 = 0;
        int n3 = 2;
        while (n2 <= 65535) {
            byArray[n2] = (byte)((float)(objectArray[n3] & 0xFFFF) * 0.0038910506f + 0.5f);
            ++n2;
            n3 += 3;
        }
        if (g16Tos8Map == null) {
            g16Tos8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        g16Tos8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static byte[] getGray8TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        byte[] byArray;
        if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
            return ColorModel.getLinearRGB8TosRGB8LUT();
        }
        if (g8Tos8Map != null && (byArray = (byte[])g8Tos8Map.get(iCC_ColorSpace)) != null) {
            return byArray;
        }
        byArray = new byte[256];
        for (int i2 = 0; i2 <= 255; ++i2) {
            byArray[i2] = (byte)i2;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        byte[] byArray2 = iCC_Transform.colorConvert(byArray, (byte[])null);
        int n2 = 0;
        int n3 = 2;
        while (n2 <= 255) {
            byArray[n2] = byArray2[n3];
            ++n2;
            n3 += 3;
        }
        if (g8Tos8Map == null) {
            g8Tos8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        g8Tos8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static byte[] getLinearGray16ToOtherGray8LUT(ICC_ColorSpace iCC_ColorSpace) {
        Object[] objectArray;
        if (lg16Toog8Map != null && (objectArray = (Object[])((byte[])lg16Toog8Map.get(iCC_ColorSpace))) != null) {
            return objectArray;
        }
        objectArray = new short[65536];
        for (int i2 = 0; i2 <= 65535; ++i2) {
            objectArray[i2] = (short)i2;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1003);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        objectArray = iCC_Transform.colorConvert((short[])objectArray, null);
        byte[] byArray = new byte[65536];
        for (int i3 = 0; i3 <= 65535; ++i3) {
            byArray[i3] = (byte)((float)(objectArray[i3] & 0xFFFF) * 0.0038910506f + 0.5f);
        }
        if (lg16Toog8Map == null) {
            lg16Toog8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        lg16Toog8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static short[] getLinearGray16ToOtherGray16LUT(ICC_ColorSpace iCC_ColorSpace) {
        short[] sArray;
        if (lg16Toog16Map != null && (sArray = (short[])lg16Toog16Map.get(iCC_ColorSpace)) != null) {
            return sArray;
        }
        sArray = new short[65536];
        for (int i2 = 0; i2 <= 65535; ++i2) {
            sArray[i2] = (short)i2;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1003);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        short[] sArray2 = iCC_Transform.colorConvert(sArray, null);
        if (lg16Toog16Map == null) {
            lg16Toog16Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        lg16Toog16Map.put(iCC_ColorSpace, sArray2);
        return sArray2;
    }

    public static ColorModel getRGBdefault() {
        if (RGBdefault == null) {
            RGBdefault = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }
        return RGBdefault;
    }

    public boolean isCompatibleRaster(Raster raster) {
        throw new UnsupportedOperationException("This method has not been implemented for this ColorModel.");
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getAlpha(Object object) {
        int n2 = 0;
        int n3 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                n3 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                n3 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                n3 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n3 == 1) {
            return this.getAlpha(n2);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getBlue(Object object) {
        int n2 = 0;
        int n3 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                n3 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                n3 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                n3 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n3 == 1) {
            return this.getBlue(n2);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getGreen(Object object) {
        int n2 = 0;
        int n3 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                n3 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                n3 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                n3 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n3 == 1) {
            return this.getGreen(n2);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getRGB(Object object) {
        return this.getAlpha(object) << 24 | this.getRed(object) << 16 | this.getGreen(object) << 8 | this.getBlue(object) << 0;
    }

    public int getRed(Object object) {
        int n2 = 0;
        int n3 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                n3 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                n3 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                n3 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n3 == 1) {
            return this.getRed(n2);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorModel)) {
            return false;
        }
        ColorModel colorModel = (ColorModel)object;
        if (this == colorModel) {
            return true;
        }
        if (this.supportsAlpha != colorModel.hasAlpha() || this.isAlphaPremultiplied != colorModel.isAlphaPremultiplied() || this.pixel_bits != colorModel.getPixelSize() || this.transparency != colorModel.getTransparency() || this.numComponents != colorModel.getNumComponents()) {
            return false;
        }
        int[] nArray = colorModel.getComponentSize();
        if (this.nBits != null && nArray != null) {
            for (int i2 = 0; i2 < this.numComponents; ++i2) {
                if (this.nBits[i2] == nArray[i2]) continue;
                return false;
            }
        } else {
            return this.nBits == null && nArray == null;
        }
        return true;
    }

    public float[] getNormalizedComponents(Object object, float[] fArray, int n2) {
        int[] nArray = this.getComponents(object, null, 0);
        return this.getNormalizedComponents(nArray, 0, fArray, n2);
    }

    public int[] getComponents(Object object, int[] nArray, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public String toString() {
        return new String("ColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.colorSpace + " transparency = " + this.transparency + " has alpha = " + this.supportsAlpha + " isAlphaPre = " + this.isAlphaPremultiplied);
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl2) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        return null;
    }

    public Object getDataElements(int n2, Object object) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public Object getDataElements(float[] fArray, int n2, Object object) {
        int[] nArray = this.getUnnormalizedComponents(fArray, n2, null, 0);
        return this.getDataElements(nArray, 0, object);
    }

    public Object getDataElements(int[] nArray, int n2, Object object) {
        throw new UnsupportedOperationException("This method has not been implemented for this color model.");
    }
}

