/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.security.util.ManifestEntryVerifier;

public class JarInputStream
extends ZipInputStream {
    private Manifest man;
    private JarEntry first;
    private JarVerifier jv;
    private ManifestEntryVerifier mev;

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.first == null ? super.read(byArray, n2, n3) : -1;
        if (this.jv != null) {
            this.jv.update(n4, byArray, n2, n3, this.mev);
        }
        return n4;
    }

    public JarInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    private byte[] getBytes(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public JarInputStream(InputStream inputStream, boolean bl2) throws IOException {
        super(inputStream);
        JarEntry jarEntry = (JarEntry)super.getNextEntry();
        if (jarEntry != null && jarEntry.getName().equalsIgnoreCase("META-INF/")) {
            jarEntry = (JarEntry)super.getNextEntry();
        }
        if (jarEntry != null && "META-INF/MANIFEST.MF".equalsIgnoreCase(jarEntry.getName())) {
            this.man = new Manifest();
            byte[] byArray = this.getBytes(new BufferedInputStream(this));
            this.man.read(new ByteArrayInputStream(byArray));
            this.closeEntry();
            if (bl2) {
                this.jv = new JarVerifier(this.man, byArray);
                this.mev = new ManifestEntryVerifier(this.man);
            }
            this.first = this.getNextJarEntry();
        } else {
            this.first = jarEntry;
        }
    }

    public JarEntry getNextJarEntry() throws IOException {
        return (JarEntry)this.getNextEntry();
    }

    public Manifest getManifest() {
        return this.man;
    }

    public ZipEntry getNextEntry() throws IOException {
        JarEntry jarEntry;
        if (this.first == null) {
            jarEntry = (JarEntry)super.getNextEntry();
        } else {
            jarEntry = this.first;
            this.first = null;
        }
        if (this.jv != null && jarEntry != null) {
            if (this.jv.nothingToVerify()) {
                this.jv = null;
                this.mev = null;
            } else {
                this.jv.beginEntry(jarEntry, this.mev);
            }
        }
        return jarEntry;
    }

    protected ZipEntry createZipEntry(String string) {
        JarEntry jarEntry = new JarEntry(string);
        if (this.man != null) {
            jarEntry.attr = this.man.getAttributes(string);
        }
        return jarEntry;
    }
}

