/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderManager;
import sun.awt.shell.Win32ShellFolder2;
import sun.security.action.LoadLibraryAction;

public class Win32ShellFolderManager2
extends ShellFolderManager {
    private static Win32ShellFolder2 desktop;
    private static Win32ShellFolder2 drives;
    private static Win32ShellFolder2 recent;
    private static Win32ShellFolder2 network;
    private static Win32ShellFolder2 personal;
    private static String osName;
    private static boolean isXP;
    private static File[] roots;
    private Comparator driveComparator = new Comparator(this){
        private final Win32ShellFolderManager2 this$0;
        {
            this.this$0 = win32ShellFolderManager2;
        }

        public int compare(Object object, Object object2) {
            return ((ShellFolder)object).getPath().compareTo(((ShellFolder)object2).getPath());
        }
    };
    private static List topFolderList;
    private Comparator fileComparator = new Comparator(this){
        private final Win32ShellFolderManager2 this$0;
        {
            this.this$0 = win32ShellFolderManager2;
        }

        public int compare(File file, File file2) {
            return Win32ShellFolderManager2.compareFiles(file, file2);
        }

        public int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }
    };

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        osName = System.getProperty("os.name");
        isXP = osName != null && osName.startsWith("Windows XP");
        topFolderList = null;
    }

    public boolean isComputerNode(File file) {
        if (file != null && file == Win32ShellFolderManager2.getDrives()) {
            return true;
        }
        String string = file.getAbsolutePath();
        return string.startsWith("\\\\") && string.indexOf("\\", 2) < 0;
    }

    public boolean isFileSystemRoot(File file) {
        if (file != null) {
            Object object;
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDrives();
            if (file instanceof Win32ShellFolder2) {
                object = (Win32ShellFolder2)file;
                if (((Win32ShellFolder2)object).isFileSystem()) {
                    if (((Win32ShellFolder2)object).parent != null) {
                        return ((Win32ShellFolder2)object).parent.equals(win32ShellFolder2);
                    }
                } else {
                    return false;
                }
            }
            return ((String)(object = file.getPath())).length() == 3 && ((String)object).charAt(1) == ':' && Arrays.asList(win32ShellFolder2.listFiles()).contains(file);
        }
        return false;
    }

    public void sortFiles(List list) {
        Collections.sort(list, this.fileComparator);
    }

    static Win32ShellFolder2 getDesktop() {
        if (desktop == null) {
            try {
                desktop = new Win32ShellFolder2(null, 0, true);
            }
            catch (IOException iOException) {
                desktop = null;
            }
        }
        return desktop;
    }

    static Win32ShellFolder2 getDrives() {
        if (drives == null) {
            try {
                drives = new Win32ShellFolder2(Win32ShellFolderManager2.getDesktop(), 17, true);
            }
            catch (IOException iOException) {
                drives = null;
            }
        }
        return drives;
    }

    static Win32ShellFolder2 getNetwork() {
        if (network == null) {
            try {
                network = new Win32ShellFolder2(Win32ShellFolderManager2.getDesktop(), 18, true);
            }
            catch (IOException iOException) {
                network = null;
            }
        }
        return network;
    }

    static Win32ShellFolder2 getPersonal() {
        if (personal == null) {
            try {
                String string = Win32ShellFolder2.getFileSystemPath(5);
                if (string != null) {
                    Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
                    personal = win32ShellFolder2.getChildByPath(string);
                    if (personal == null) {
                        personal = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(string));
                    }
                    if (personal != null) {
                        personal.setIsPersonal();
                    }
                }
            }
            catch (IOException iOException) {
                personal = null;
            }
        }
        return personal;
    }

    static Win32ShellFolder2 getRecent() {
        if (recent == null) {
            try {
                String string = Win32ShellFolder2.getFileSystemPath(8);
                if (string != null) {
                    recent = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(string));
                }
            }
            catch (IOException iOException) {
                recent = null;
            }
        }
        return recent;
    }

    static int compareFiles(File file, File file2) {
        if (file instanceof Win32ShellFolder2) {
            return file.compareTo(file2);
        }
        if (file2 instanceof Win32ShellFolder2) {
            return -1 * file2.compareTo(file);
        }
        return Win32ShellFolderManager2.compareNames(file.getName(), file2.getName());
    }

    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getPersonal();
            if (win32ShellFolder2 == null) {
                win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
            }
            return win32ShellFolder2;
        }
        if (string.equals("roots")) {
            if (roots == null) {
                Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
                roots = win32ShellFolder2 != null ? new File[]{win32ShellFolder2} : (File[])super.get(string);
            }
            return roots;
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
            if (win32ShellFolder2 != null) {
                ArrayList arrayList = new ArrayList();
                Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.getDrives();
                arrayList.add(win32ShellFolder2);
                Object[] objectArray = win32ShellFolder2.listFiles();
                Arrays.sort(objectArray);
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Object[] objectArray2;
                    Win32ShellFolder2 win32ShellFolder23 = (Win32ShellFolder2)objectArray[i2];
                    if (win32ShellFolder23.isFileSystem() && !win32ShellFolder23.isDirectory()) continue;
                    arrayList.add(win32ShellFolder23);
                    if (!win32ShellFolder23.equals(win32ShellFolder22) || (objectArray2 = win32ShellFolder23.listFiles()) == null) continue;
                    Arrays.sort(objectArray2, this.driveComparator);
                    for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                        arrayList.add(objectArray2[i3]);
                    }
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            return super.get(string);
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            File[] fileArray = new File[]{Win32ShellFolderManager2.getRecent(), Win32ShellFolderManager2.getDesktop(), Win32ShellFolderManager2.getPersonal(), Win32ShellFolderManager2.getDrives(), Win32ShellFolderManager2.getNetwork()};
            ArrayList arrayList = new ArrayList();
            for (int i4 = 0; i4 < fileArray.length; ++i4) {
                if (fileArray[i4] == null) continue;
                arrayList.add(fileArray[i4]);
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        if (string.startsWith("fileChooserIcon ")) {
            int n2;
            block17: {
                n2 = -1;
                String string2 = string.substring(string.indexOf(" ") + 1);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.equals("ListView")) {
                        n2 = isXP ? 21 : 2;
                    }
                    if (string2.equals("DetailsView")) {
                        n2 = isXP ? 23 : 3;
                    }
                    if (string2.equals("UpFolder")) {
                        n2 = isXP ? 28 : 8;
                    }
                    if (!string2.equals("NewFolder")) break block17;
                    int n3 = n2 = isXP ? 31 : 11;
                }
            }
            if (n2 >= 0) {
                return Win32ShellFolder2.getFileChooserIcon(n2);
            }
        }
        return null;
    }

    static int compareNames(String string, String string2) {
        int n2 = string.toLowerCase().compareTo(string2.toLowerCase());
        if (n2 != 0) {
            return n2;
        }
        return string.compareTo(string2);
    }

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), file);
    }

    static Win32ShellFolder2 createShellFolderFromRelativePIDL(Win32ShellFolder2 win32ShellFolder2, long l2) {
        while (l2 != 0L) {
            long l3 = Win32ShellFolder2.copyFirstPIDLEntry(l2);
            if (l3 == 0L) continue;
            win32ShellFolder2 = new Win32ShellFolder2(win32ShellFolder2, l3);
            l2 = Win32ShellFolder2.getNextPIDLEntry(l2);
        }
        return win32ShellFolder2;
    }

    static int compareShellFolders(Win32ShellFolder2 win32ShellFolder2, Win32ShellFolder2 win32ShellFolder22) {
        boolean bl2 = win32ShellFolder2.isSpecial();
        boolean bl3 = win32ShellFolder22.isSpecial();
        if (bl2 || bl3) {
            if (topFolderList == null) {
                ArrayList arrayList = new ArrayList();
                arrayList.add(Win32ShellFolderManager2.getPersonal());
                arrayList.add(Win32ShellFolderManager2.getDesktop());
                arrayList.add(Win32ShellFolderManager2.getDrives());
                arrayList.add(Win32ShellFolderManager2.getNetwork());
                topFolderList = arrayList;
            }
            int n2 = topFolderList.indexOf(win32ShellFolder2);
            int n3 = topFolderList.indexOf(win32ShellFolder22);
            if (n2 >= 0 && n3 >= 0) {
                return n2 - n3;
            }
            if (n2 >= 0) {
                return -1;
            }
            if (n3 >= 0) {
                return 1;
            }
        }
        if (bl2 && !bl3) {
            return -1;
        }
        if (bl3 && !bl2) {
            return 1;
        }
        return Win32ShellFolderManager2.compareNames(win32ShellFolder2.getAbsolutePath(), win32ShellFolder22.getAbsolutePath());
    }

    static Win32ShellFolder2 createShellFolder(Win32ShellFolder2 win32ShellFolder2, File file) throws FileNotFoundException {
        long l2 = win32ShellFolder2.parseDisplayName(file.getAbsolutePath());
        if (l2 == 0L) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.createShellFolderFromRelativePIDL(win32ShellFolder2, l2);
        Win32ShellFolder2.releasePIDL(l2);
        return win32ShellFolder22;
    }
}

