/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    FileDescriptor fd = null;
    int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private InetAddress cachedSenderInetAddress = null;
    private int cachedSenderPort = 0;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static int ST_UNCONNECTED;
    private static int ST_CONNECTED;
    private static final int ST_KILLED = 2;
    private int state = -1;
    private SocketAddress localAddress = null;
    private SocketAddress remoteAddress = null;
    private SocketOpts.IP options = null;
    private DatagramSocket socket = null;
    private SocketAddress sender;
    static final boolean $assertionsDisabled;
    static Class class$sun$nio$ch$DatagramChannelImpl;

    public int getFDVal() {
        return this.fdVal;
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$DatagramChannelImpl == null ? (class$sun$nio$ch$DatagramChannelImpl = DatagramChannelImpl.class$("sun.nio.ch.DatagramChannelImpl")) : class$sun$nio$ch$DatagramChannelImpl).desiredAssertionStatus();
        nd = new DatagramDispatcher();
        ST_UNCONNECTED = 0;
        ST_CONNECTED = 1;
        Util.load();
        DatagramChannelImpl.initIDs();
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state != ST_UNCONNECTED) {
                throw new IllegalStateException("Connect already invoked");
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long l2 = this.readerThread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
            if ((l2 = this.writerThread) != 0L) {
                NativeThread.signal(l2);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            if (this.state == -1) {
                this.state = 2;
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.state = 2;
        }
    }

    public boolean isBound() {
        return Net.localPortNumber(this.fd) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ST_CONNECTED;
        }
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    private static native void disconnect0(FileDescriptor var0) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4, boolean var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            SecurityManager securityManager;
            if (this.isConnected() && this.localAddress == null) {
                this.localAddress = Net.localAddress(this.fd);
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.localAddress;
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpen();
                    if (this.isBound()) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n2;
            int n3;
            block15: {
                boolean bl2;
                int n4;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n3 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n4 = 0;
                            Object var6_7 = null;
                            this.readerThread = 0L;
                            bl2 = n3 > 0 || n3 == -2;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((n3 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
                        }
                        n2 = IOStatus.normalize(n3);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.readerThread = 0L;
                        this.end(n3 > 0 || n3 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            Object var6_8 = null;
            this.readerThread = 0L;
            this.end(n3 > 0 || n3 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n2;
            int n3;
            block15: {
                boolean bl2;
                int n4;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n3 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n4 = 0;
                            Object var6_7 = null;
                            this.writerThread = 0L;
                            bl2 = n3 > 0 || n3 == -2;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n3 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
                        }
                        n2 = IOStatus.normalize(n3);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.writerThread = 0L;
                        this.end(n3 > 0 || n3 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            Object var6_8 = null;
            this.writerThread = 0L;
            this.end(n3 > 0 || n3 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            long l2;
            long l3;
            block15: {
                boolean bl2;
                long l4;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    l3 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l4 = 0L;
                            Object var8_7 = null;
                            this.readerThread = 0L;
                            bl2 = l3 > 0L || l3 == -2L;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((l3 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l2 = IOStatus.normalize(l3);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.readerThread = 0L;
                        this.end(l3 > 0L || l3 == -2L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return l4;
            }
            Object var8_8 = null;
            this.readerThread = 0L;
            this.end(l3 > 0L || l3 == -2L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long write0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            long l2;
            long l3;
            block15: {
                boolean bl2;
                long l4;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    l3 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l4 = 0L;
                            Object var8_7 = null;
                            this.writerThread = 0L;
                            bl2 = l3 > 0L || l3 == -2L;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((l3 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l2 = IOStatus.normalize(l3);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.writerThread = 0L;
                        this.end(l3 > 0L || l3 == -2L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return l4;
            }
            Object var8_8 = null;
            this.writerThread = 0L;
            this.end(l3 > 0L || l3 == -2L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return l2;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n2, n3));
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected() || !this.isOpen()) {
                        return this;
                    }
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)this.remoteAddress;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    DatagramChannelImpl.disconnect0(this.fd);
                    this.remoteAddress = null;
                    this.state = ST_UNCONNECTED;
                }
            }
        }
        return this;
    }

    public DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ST_UNCONNECTED;
    }

    public boolean translateReadyOps(int n2, int n3, SelectionKeyImpl selectionKeyImpl) {
        int n4 = selectionKeyImpl.interestOps();
        int n5 = selectionKeyImpl.readyOps();
        int n6 = n3;
        if ((n2 & 0x20) != 0) {
            return false;
        }
        if ((n2 & 0x18) != 0) {
            n6 = n4;
            selectionKeyImpl.readyOps(n6);
            return (n6 & ~n5) != 0;
        }
        if ((n2 & 1) != 0 && (n4 & 1) != 0) {
            n6 |= 1;
        }
        if ((n2 & 4) != 0 && (n4 & 4) != 0) {
            n6 |= 4;
        }
        selectionKeyImpl.readyOps(n6);
        return (n6 & ~n5) != 0;
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 8) != 0) {
            n3 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n3);
    }

    public boolean translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, 0, selectionKeyImpl);
    }

    public boolean translateAndUpdateReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, selectionKeyImpl.readyOps(), selectionKeyImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher dispatcher = new SocketOptsImpl.Dispatcher(this){
                    private final DatagramChannelImpl this$0;

                    int getInt(int n2) throws IOException {
                        return Net.getIntOption(this.this$0.fd, n2);
                    }

                    void setInt(int n2, int n3) throws IOException {
                        Net.setIntOption(this.this$0.fd, n2, n3);
                    }
                    {
                        this.this$0 = datagramChannelImpl;
                    }
                };
                this.options = new SocketOptsImpl.IP(dispatcher);
            }
            return this.options;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private native int send0(FileDescriptor var1, long var2, int var4, SocketAddress var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            SocketAddress socketAddress;
            ByteBuffer byteBuffer2;
            int n2;
            block30: {
                SocketAddress socketAddress2;
                block29: {
                    SocketAddress socketAddress3;
                    block27: {
                        block28: {
                            this.ensureOpen();
                            if (!this.isBound()) {
                                return null;
                            }
                            n2 = 0;
                            byteBuffer2 = null;
                            try {
                                this.begin();
                                if (!this.isOpen()) {
                                    socketAddress3 = null;
                                    Object var9_7 = null;
                                    if (byteBuffer2 == null) break block27;
                                    break block28;
                                }
                                SecurityManager securityManager = System.getSecurityManager();
                                this.readerThread = NativeThread.current();
                                if (this.isConnected() || securityManager == null) {
                                    while ((n2 = this.receive(this.fd, byteBuffer)) == -3 && this.isOpen()) {
                                    }
                                    if (n2 == -2) {
                                        socketAddress2 = null;
                                        break block29;
                                    }
                                } else {
                                    byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
                                    while (true) {
                                        if ((n2 = this.receive(this.fd, byteBuffer2)) == -3 && this.isOpen()) {
                                            continue;
                                        }
                                        if (n2 == -2) {
                                            socketAddress = null;
                                            Object var9_9 = null;
                                            if (byteBuffer2 != null) {
                                                Util.releaseTemporaryDirectBuffer(byteBuffer2);
                                            }
                                            this.readerThread = 0L;
                                            this.end(n2 > 0 || n2 == -2);
                                            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                                                throw new AssertionError();
                                            }
                                            return socketAddress;
                                        }
                                        socketAddress = (InetSocketAddress)this.sender;
                                        try {
                                            securityManager.checkAccept(((InetSocketAddress)socketAddress).getAddress().getHostAddress(), ((InetSocketAddress)socketAddress).getPort());
                                        }
                                        catch (SecurityException securityException) {
                                            byteBuffer2.clear();
                                            n2 = 0;
                                            continue;
                                        }
                                        break;
                                    }
                                    byteBuffer2.flip();
                                    byteBuffer.put(byteBuffer2);
                                }
                                socketAddress = this.sender;
                                break block30;
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                if (byteBuffer2 != null) {
                                    Util.releaseTemporaryDirectBuffer(byteBuffer2);
                                }
                                this.readerThread = 0L;
                                this.end(n2 > 0 || n2 == -2);
                                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                                    throw new AssertionError();
                                }
                                throw throwable;
                            }
                        }
                        Util.releaseTemporaryDirectBuffer(byteBuffer2);
                    }
                    this.readerThread = 0L;
                    this.end(n2 > 0 || n2 == -2);
                    if (!$assertionsDisabled && !IOStatus.check(n2)) {
                        throw new AssertionError();
                    }
                    return socketAddress3;
                }
                Object var9_8 = null;
                if (byteBuffer2 != null) {
                    Util.releaseTemporaryDirectBuffer(byteBuffer2);
                }
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return socketAddress2;
            }
            Object var9_10 = null;
            if (byteBuffer2 != null) {
                Util.releaseTemporaryDirectBuffer(byteBuffer2);
            }
            this.readerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return socketAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n2;
            int n3;
            block25: {
                boolean bl2;
                int n4;
                block24: {
                    this.ensureOpen();
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    InetAddress inetAddress = inetSocketAddress.getAddress();
                    if (inetAddress == null) {
                        throw new IOException("Target address not resolved");
                    }
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        if (!this.isConnected()) {
                            if (socketAddress == null) {
                                throw new NullPointerException();
                            }
                            SecurityManager securityManager = System.getSecurityManager();
                            if (securityManager != null) {
                                if (inetAddress.isMulticastAddress()) {
                                    securityManager.checkMulticast(inetSocketAddress.getAddress());
                                } else {
                                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                                }
                            }
                        } else if (socketAddress == null) {
                            socketAddress = this.remoteAddress;
                        } else if (!socketAddress.equals(this.remoteAddress)) {
                            throw new IllegalArgumentException("Connected address not equal to  target address");
                        }
                    }
                    n3 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n4 = 0;
                            Object var10_11 = null;
                            this.writerThread = 0L;
                            bl2 = n3 > 0 || n3 == -2;
                            break block24;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n3 = this.send(this.fd, byteBuffer, socketAddress)) == -3 && this.isOpen()) {
                        }
                        n2 = IOStatus.normalize(n3);
                        break block25;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        this.writerThread = 0L;
                        this.end(n3 > 0 || n3 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            Object var10_12 = null;
            this.writerThread = 0L;
            this.end(n3 > 0 || n3 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws IOException {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (!$assertionsDisabled && n3 > n4) {
            throw new AssertionError();
        }
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (byteBuffer instanceof DirectBuffer && n2 > 0) {
            return this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer, n2, n3);
        }
        int n6 = Math.max(n2, 1);
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
            int n7 = this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer2, n6, 0);
            byteBuffer2.flip();
            if (n7 > 0 && n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n8 = n7;
            return n8;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int receiveIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n2, int n3) throws IOException {
        int n4 = this.receive0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2, this.isConnected());
        if (n4 > 0) {
            byteBuffer.position(n3 + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        int n2 = 0;
        boolean bl2 = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    int n3;
                    this.ensureOpenAndUnconnected();
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    if ((n3 = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n2)) <= 0) {
                        throw new Error();
                    }
                    this.state = ST_CONNECTED;
                    this.remoteAddress = socketAddress;
                    this.sender = inetSocketAddress;
                    this.cachedSenderInetAddress = inetSocketAddress.getAddress();
                    this.cachedSenderPort = inetSocketAddress.getPort();
                }
            }
        }
        return this;
    }

    private int send(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fileDescriptor, byteBuffer, socketAddress);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        byteBuffer.position(n2);
        int n5 = this.sendFromNativeBuffer(fileDescriptor, byteBuffer2, socketAddress);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    private int sendFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = this.send0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4, socketAddress);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }
}

