/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

final class WindowsSelectorImpl
extends SelectorImpl {
    private final int INIT_CAP = 8;
    private static final int MAX_SELECTABLE_FDS = 1024;
    private SelectionKeyImpl[] channelArray = new SelectionKeyImpl[8];
    private PollArrayWrapper pollWrapper;
    private int totalChannels = 1;
    private int threadsCount = 0;
    private final List threads = new ArrayList();
    private final Pipe wakeupPipe;
    private final int wakeupSourceFd;
    private final int wakeupSinkFd;
    private final FdMap fdMap = new FdMap(null);
    private final SubSelector subSelector = new SubSelector(this, null);
    private long timeout;
    private final Object interruptLock = new Object();
    private volatile boolean interruptTriggered = false;
    private final StartLock startLock = new StartLock(this, null);
    private final FinishLock finishLock = new FinishLock(this, null);
    private long updateCount = 0L;

    private int updateSelectedKeys() {
        ++this.updateCount;
        int n2 = 0;
        n2 += SubSelector.access$2600(this.subSelector, this.updateCount);
        Iterator iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            n2 += SubSelector.access$2600(((SelectThread)iterator.next()).subSelector, this.updateCount);
        }
        return n2;
    }

    static {
        Util.load();
    }

    private void adjustThreadsCount() {
        block3: {
            block2: {
                if (this.threadsCount <= this.threads.size()) break block2;
                for (int i2 = this.threads.size(); i2 < this.threadsCount; ++i2) {
                    SelectThread selectThread = new SelectThread(this, i2, null);
                    this.threads.add(selectThread);
                    selectThread.setDaemon(true);
                    selectThread.start();
                }
                break block3;
            }
            if (this.threadsCount >= this.threads.size()) break block3;
            for (int i3 = this.threads.size() - 1; i3 >= this.threadsCount; --i3) {
                this.threads.remove(i3);
            }
        }
    }

    private void growIfNeeded() {
        if (this.channelArray.length == this.totalChannels) {
            int n2 = this.totalChannels * 2;
            SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n2];
            System.arraycopy(this.channelArray, 1, selectionKeyImplArray, 1, this.totalChannels - 1);
            this.channelArray = selectionKeyImplArray;
            this.pollWrapper.grow(n2);
        }
        if (this.totalChannels % 1024 == 0) {
            this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, this.totalChannels);
            ++this.totalChannels;
            ++this.threadsCount;
        }
    }

    protected void implClose() throws IOException {
        if (this.channelArray != null && this.pollWrapper != null) {
            this.wakeupPipe.sink().close();
            this.wakeupPipe.source().close();
            for (int i2 = 1; i2 < this.totalChannels; ++i2) {
                if (i2 % 1024 == 0) continue;
                this.deregister(this.channelArray[i2]);
                SelectableChannel selectableChannel = this.channelArray[i2].channel();
                if (selectableChannel.isOpen() || selectableChannel.isRegistered()) continue;
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.threads.clear();
            StartLock.access$300(this.startLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWakeupSocket() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                return;
            }
            this.resetWakeupSocket0(this.wakeupSourceFd);
            this.interruptTriggered = false;
        }
    }

    private void setWakeupSocket() {
        this.setWakeupSocket0(this.wakeupSinkFd);
    }

    private native void resetWakeupSocket0(int var1);

    private native void setWakeupSocket0(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l2) throws IOException {
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.timeout = l2;
        this.processDeregisterQueue();
        if (this.interruptTriggered) {
            this.resetWakeupSocket();
            return 0;
        }
        this.adjustThreadsCount();
        FinishLock.access$200(this.finishLock);
        StartLock.access$300(this.startLock);
        try {
            this.begin();
            try {
                SubSelector.access$400(this.subSelector);
            }
            catch (IOException iOException) {
                FinishLock.access$500(this.finishLock, iOException);
            }
            if (this.threads.size() > 0) {
                FinishLock.access$600(this.finishLock);
            }
        }
        finally {
            this.end();
        }
        this.resetWakeupSocket();
        FinishLock.access$700(this.finishLock);
        this.processDeregisterQueue();
        return this.updateSelectedKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.setWakeupSocket();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    WindowsSelectorImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.pollWrapper = new PollArrayWrapper(8);
        this.wakeupPipe = Pipe.open();
        this.wakeupSourceFd = ((SelChImpl)((Object)this.wakeupPipe.source())).getFDVal();
        this.wakeupSinkFd = ((SelChImpl)((Object)this.wakeupPipe.sink())).getFDVal();
        this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, 0);
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        Object object;
        int n2 = selectionKeyImpl.getIndex();
        if (n2 != this.totalChannels - 1) {
            object = this.channelArray[this.totalChannels - 1];
            this.channelArray[n2] = object;
            ((SelectionKeyImpl)object).setIndex(n2);
            this.pollWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n2);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        if (this.totalChannels != 1 && this.totalChannels % 1024 == 1) {
            --this.totalChannels;
            --this.threadsCount;
        }
        FdMap.access$2800(this.fdMap, selectionKeyImpl);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        object = selectionKeyImpl.channel();
        if (!((AbstractInterruptibleChannel)object).isOpen() && !((SelectableChannel)object).isRegistered()) {
            ((SelChImpl)object).kill();
        }
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        this.growIfNeeded();
        this.channelArray[this.totalChannels] = selectionKeyImpl;
        selectionKeyImpl.setIndex(this.totalChannels);
        FdMap.access$2700(this.fdMap, selectionKeyImpl);
        this.keys.add(selectionKeyImpl);
        this.pollWrapper.addEntry(this.totalChannels, selectionKeyImpl);
        ++this.totalChannels;
    }

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n2) {
        this.pollWrapper.putEventOps(selectionKeyImpl.getIndex(), n2);
    }

    static int access$1600(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.totalChannels;
    }

    static int access$1800(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.wakeupSourceFd;
    }

    static long access$1700(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.timeout;
    }

    static List access$1200(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.threads;
    }

    static PollArrayWrapper access$1500(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.pollWrapper;
    }

    static FdMap access$1900(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.fdMap;
    }

    static FinishLock access$1400(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.finishLock;
    }

    static StartLock access$1000(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.startLock;
    }

    static class 1 {
    }

    private static final class FdMap
    extends HashMap {
        private FdMap() {
        }

        FdMap(1 var1_1) {
            this();
        }

        private MapEntry get(int n2) {
            return (MapEntry)this.get(new Integer(n2));
        }

        private Object put(SelectionKeyImpl selectionKeyImpl) {
            return this.put(new Integer(selectionKeyImpl.channel.getFDVal()), new MapEntry(selectionKeyImpl));
        }

        private Object remove(SelectionKeyImpl selectionKeyImpl) {
            return this.remove(new Integer(selectionKeyImpl.channel.getFDVal()));
        }

        static MapEntry access$2000(FdMap fdMap, int n2) {
            return fdMap.get(n2);
        }

        static Object access$2700(FdMap fdMap, SelectionKeyImpl selectionKeyImpl) {
            return fdMap.put(selectionKeyImpl);
        }

        static Object access$2800(FdMap fdMap, SelectionKeyImpl selectionKeyImpl) {
            return fdMap.remove(selectionKeyImpl);
        }
    }

    private final class FinishLock {
        private int threadsToFinish;
        IOException exception;
        private final WindowsSelectorImpl this$0;

        private void checkForException() throws IOException {
            if (this.exception == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("An exception occured during the execution of select(): \n");
            stringBuffer.append(this.exception);
            stringBuffer.append('\n');
            this.exception = null;
            throw new IOException(stringBuffer.toString());
        }

        private void reset() {
            this.threadsToFinish = WindowsSelectorImpl.access$1200(this.this$0).size();
        }

        private synchronized void threadFinished() {
            if (this.threadsToFinish == WindowsSelectorImpl.access$1200(this.this$0).size()) {
                this.this$0.wakeup();
            }
            --this.threadsToFinish;
            if (this.threadsToFinish == 0) {
                this.notify();
            }
        }

        private synchronized void waitForHelperThreads() {
            if (this.threadsToFinish == WindowsSelectorImpl.access$1200(this.this$0).size()) {
                this.this$0.wakeup();
            }
            while (this.threadsToFinish != 0) {
                try {
                    WindowsSelectorImpl.access$1400(this.this$0).wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void setException(IOException iOException) {
            this.exception = iOException;
        }

        private FinishLock(WindowsSelectorImpl windowsSelectorImpl) {
            this.this$0 = windowsSelectorImpl;
            this.exception = null;
        }

        static void access$200(FinishLock finishLock) {
            finishLock.reset();
        }

        static void access$2400(FinishLock finishLock) {
            finishLock.threadFinished();
        }

        static void access$600(FinishLock finishLock) {
            finishLock.waitForHelperThreads();
        }

        static void access$700(FinishLock finishLock) throws IOException {
            finishLock.checkForException();
        }

        static void access$500(FinishLock finishLock, IOException iOException) {
            finishLock.setException(iOException);
        }

        FinishLock(WindowsSelectorImpl windowsSelectorImpl, 1 var2_2) {
            this(windowsSelectorImpl);
        }
    }

    private static final class MapEntry {
        SelectionKeyImpl ski;
        long updateCount = 0L;
        long clearedCount = 0L;

        MapEntry(SelectionKeyImpl selectionKeyImpl) {
            this.ski = selectionKeyImpl;
        }
    }

    private final class SelectThread
    extends Thread {
        private int index;
        SubSelector subSelector;
        private long lastRun;
        private final WindowsSelectorImpl this$0;

        public void run() {
            while (!StartLock.access$2200(WindowsSelectorImpl.access$1000(this.this$0), this)) {
                try {
                    SubSelector.access$2300(this.subSelector, this.index);
                }
                catch (IOException iOException) {
                    FinishLock.access$500(WindowsSelectorImpl.access$1400(this.this$0), iOException);
                }
                FinishLock.access$2400(WindowsSelectorImpl.access$1400(this.this$0));
            }
            return;
        }

        private SelectThread(WindowsSelectorImpl windowsSelectorImpl, int n2) {
            this.this$0 = windowsSelectorImpl;
            this.lastRun = 0L;
            this.index = n2;
            this.subSelector = new SubSelector(windowsSelectorImpl, n2, null);
        }

        static int access$1100(SelectThread selectThread) {
            return selectThread.index;
        }

        static long access$900(SelectThread selectThread) {
            return selectThread.lastRun;
        }

        static long access$902(SelectThread selectThread, long l2) {
            selectThread.lastRun = l2;
            return selectThread.lastRun;
        }

        SelectThread(WindowsSelectorImpl windowsSelectorImpl, int n2, 1 var3_3) {
            this(windowsSelectorImpl, n2);
        }
    }

    private final class StartLock {
        private long runsCounter;
        private final WindowsSelectorImpl this$0;

        private synchronized void startThreads() {
            ++this.runsCounter;
            this.notifyAll();
        }

        private StartLock(WindowsSelectorImpl windowsSelectorImpl) {
            this.this$0 = windowsSelectorImpl;
        }

        private synchronized boolean waitForStart(SelectThread selectThread) {
            while (this.runsCounter == SelectThread.access$900(selectThread)) {
                try {
                    WindowsSelectorImpl.access$1000(this.this$0).wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (SelectThread.access$1100(selectThread) >= WindowsSelectorImpl.access$1200(this.this$0).size()) {
                return true;
            }
            SelectThread.access$902(selectThread, this.runsCounter);
            return false;
        }

        static void access$300(StartLock startLock) {
            startLock.startThreads();
        }

        StartLock(WindowsSelectorImpl windowsSelectorImpl, 1 var2_2) {
            this(windowsSelectorImpl);
        }

        static boolean access$2200(StartLock startLock, SelectThread selectThread) {
            return startLock.waitForStart(selectThread);
        }
    }

    private final class SubSelector {
        private final int pollArrayIndex;
        private final int[] readFds;
        private final int[] writeFds;
        private final int[] exceptFds;
        private final WindowsSelectorImpl this$0;

        private int poll() throws IOException {
            return this.poll0(WindowsSelectorImpl.access$1500((WindowsSelectorImpl)this.this$0).pollArrayAddress, Math.min(WindowsSelectorImpl.access$1600(this.this$0), 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.access$1700(this.this$0));
        }

        private int poll(int n2) throws IOException {
            return this.poll0(WindowsSelectorImpl.access$1500((WindowsSelectorImpl)this.this$0).pollArrayAddress + (long)(this.pollArrayIndex * PollArrayWrapper.SIZE_POLLFD), Math.min(1024, WindowsSelectorImpl.access$1600(this.this$0) - (n2 + 1) * 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.access$1700(this.this$0));
        }

        private int processSelectedKeys(long l2) {
            int n2 = 0;
            n2 += this.processFDSet(l2, this.readFds, 1);
            n2 += this.processFDSet(l2, this.writeFds, 6);
            return n2 += this.processFDSet(l2, this.exceptFds, 7);
        }

        private native int poll0(long var1, int var3, int[] var4, int[] var5, int[] var6, long var7);

        private int processFDSet(long l2, int[] nArray, int n2) {
            int n3 = 0;
            for (int i2 = 1; i2 <= nArray[0]; ++i2) {
                int n4 = nArray[i2];
                if (n4 == WindowsSelectorImpl.access$1800(this.this$0)) continue;
                MapEntry mapEntry = FdMap.access$2000(WindowsSelectorImpl.access$1900(this.this$0), n4);
                SelectionKeyImpl selectionKeyImpl = mapEntry.ski;
                if (this.this$0.selectedKeys.contains(selectionKeyImpl)) {
                    if (mapEntry.clearedCount != l2) {
                        if (selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl) && mapEntry.updateCount != l2) {
                            mapEntry.updateCount = l2;
                            ++n3;
                        }
                    } else if (selectionKeyImpl.channel.translateAndUpdateReadyOps(n2, selectionKeyImpl) && mapEntry.updateCount != l2) {
                        mapEntry.updateCount = l2;
                        ++n3;
                    }
                    mapEntry.clearedCount = l2;
                    continue;
                }
                if (mapEntry.clearedCount != l2) {
                    selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl);
                    if ((selectionKeyImpl.readyOps() & selectionKeyImpl.interestOps()) != 0) {
                        this.this$0.selectedKeys.add(selectionKeyImpl);
                        mapEntry.updateCount = l2;
                        ++n3;
                    }
                } else {
                    selectionKeyImpl.channel.translateAndUpdateReadyOps(n2, selectionKeyImpl);
                    if ((selectionKeyImpl.readyOps() & selectionKeyImpl.interestOps()) != 0) {
                        this.this$0.selectedKeys.add(selectionKeyImpl);
                        mapEntry.updateCount = l2;
                        ++n3;
                    }
                }
                mapEntry.clearedCount = l2;
            }
            return n3;
        }

        private SubSelector(WindowsSelectorImpl windowsSelectorImpl) {
            this.this$0 = windowsSelectorImpl;
            this.readFds = new int[1025];
            this.writeFds = new int[1025];
            this.exceptFds = new int[1025];
            this.pollArrayIndex = 0;
        }

        private SubSelector(WindowsSelectorImpl windowsSelectorImpl, int n2) {
            this.this$0 = windowsSelectorImpl;
            this.readFds = new int[1025];
            this.writeFds = new int[1025];
            this.exceptFds = new int[1025];
            this.pollArrayIndex = (n2 + 1) * 1024;
        }

        static int access$400(SubSelector subSelector) throws IOException {
            return subSelector.poll();
        }

        static int access$2300(SubSelector subSelector, int n2) throws IOException {
            return subSelector.poll(n2);
        }

        static int access$2600(SubSelector subSelector, long l2) {
            return subSelector.processSelectedKeys(l2);
        }

        SubSelector(WindowsSelectorImpl windowsSelectorImpl, int n2, 1 var3_3) {
            this(windowsSelectorImpl, n2);
        }

        SubSelector(WindowsSelectorImpl windowsSelectorImpl, 1 var2_2) {
            this(windowsSelectorImpl);
        }
    }
}

