/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;

public class CertificateExtensions
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private Hashtable map = new Hashtable(11);
    private boolean unsupportedCritExt = false;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Object;

    public int hashCode() {
        return this.map.hashCode();
    }

    public CertificateExtensions() {
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.init(derValue.data);
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl2) throws CertificateException, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        Collection collection = this.map.values();
        Object[] objectArray = collection.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof CertAttrSet) {
                ((CertAttrSet)objectArray[i2]).encode(derOutputStream2);
                continue;
            }
            if (objectArray[i2] instanceof Extension) {
                ((Extension)objectArray[i2]).encode(derOutputStream2);
                continue;
            }
            throw new CertificateException("Illegal extension object");
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        if (!bl2) {
            derOutputStream = new DerOutputStream();
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream3);
        } else {
            derOutputStream = derOutputStream3;
        }
        outputStream.write(derOutputStream.toByteArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertificateExtensions)) {
            return false;
        }
        Collection collection = ((CertificateExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 != this.map.size()) {
            return false;
        }
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Extension extension;
            if (objectArray[i2] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[i2]).getName();
            }
            Extension extension2 = (Extension)objectArray[i2];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = (Extension)this.map.get(string)) == null) {
                return false;
            }
            if (extension.equals(extension2)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return this.map.toString();
    }

    public void delete(String string) throws IOException {
        Object object = this.map.get(string);
        if (object == null) {
            throw new IOException("No extension found with name " + string);
        }
        this.map.remove(string);
    }

    public Collection getAllExtensions() {
        return this.map.values();
    }

    public Enumeration getElements() {
        return this.map.elements();
    }

    public CertificateExtensions(DerInputStream derInputStream) throws IOException {
        this.init(derInputStream);
    }

    private void init(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSequence(5);
        for (int i2 = 0; i2 < derValueArray.length; ++i2) {
            Extension extension = new Extension(derValueArray[i2]);
            this.parseExtension(extension);
        }
    }

    private void parseExtension(Extension extension) throws IOException {
        try {
            Class clazz = OIDMap.getClass(extension.getExtensionId());
            if (clazz == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) == null) {
                    return;
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CertificateExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CertificateExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n2 = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Array.setByte(object, i2, byArray[i2]);
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), certAttrSet) != null) {
                throw new IOException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw (IOException)new IOException(throwable.toString()).initCause(throwable);
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.toString()).initCause(exception);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Object get(String string) throws IOException {
        Object object = this.map.get(string);
        if (object == null) {
            throw new IOException("No extension found with name " + string);
        }
        return object;
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Extension)) {
            throw new IOException("Unknown extension type.");
        }
        this.map.put(string, object);
    }
}

