/*
 * Decompiled with CFR 0.152.
 */
package javax.media.bean.playerbean;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.media.bean.playerbean.MediaPlayerRTPDialog;
import javax.media.bean.playerbean.MediaPlayerResource;

public class MediaPlayerMediaLocationEditor
extends Panel
implements PropertyEditor,
ActionListener,
ItemListener {
    PropertyChangeSupport support = new PropertyChangeSupport(this);
    String mediaLocationString;
    TextField mediaLocationTextField = new TextField(this.mediaLocationString, 60);
    private String browseString = "...";
    private Button browseB = new Button(this.browseString);
    private Choice protocolChooser = new Choice();
    private String httpString = MediaPlayerResource.getString("HTTP");
    private String httpsString = MediaPlayerResource.getString("HTTPS");
    private String fileString = MediaPlayerResource.getString("FILE");
    private String rtpString = MediaPlayerResource.getString("RTP");
    private String ftpString = MediaPlayerResource.getString("FTP");
    private String codeString = MediaPlayerResource.getString("CODEBASE");
    private String chooseOneString = MediaPlayerResource.getString("CHOOSE_ONE");
    private boolean isFile = false;
    Panel editPanel = new Panel();

    public MediaPlayerMediaLocationEditor() {
        this.setLayout(new BorderLayout());
        this.editPanel.setLayout(new BorderLayout());
        this.editPanel.add("Center", this.mediaLocationTextField);
        this.editPanel.add("East", this.browseB);
        this.browseB.addActionListener(this);
        this.browseB.setEnabled(false);
        this.protocolChooser.add(this.chooseOneString);
        this.protocolChooser.add(this.fileString);
        this.protocolChooser.add(this.httpString);
        this.protocolChooser.add(this.httpsString);
        this.protocolChooser.add(this.rtpString);
        this.protocolChooser.add(this.ftpString);
        this.protocolChooser.add(this.codeString);
        this.protocolChooser.addItemListener(this);
        this.editPanel.add("West", this.protocolChooser);
        this.add("Center", this.editPanel);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                MediaPlayerMediaLocationEditor.this.mediaLocationString = MediaPlayerMediaLocationEditor.this.mediaLocationTextField.getText();
            }
        };
        this.mediaLocationTextField.addKeyListener(keyAdapter);
        this.mediaLocationTextField.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.browseString)) {
            if (this.isFile) {
                FileDialog fileDialog = new FileDialog(this.getFrame(this.editPanel), MediaPlayerResource.getString("SET_MEDIA_LOCATION"), 0);
                fileDialog.setDirectory("c:\\");
                ((Dialog)fileDialog).setTitle(MediaPlayerResource.getString("SET_MEDIA_LOCATION"));
                fileDialog.show();
                String string2 = fileDialog.getFile();
                if (string2 != null && fileDialog.getDirectory() != null) {
                    string2 = String.valueOf(fileDialog.getDirectory()) + string2;
                }
                if (string2 != null) {
                    string2 = string2.replace('\\', '/');
                    String string3 = "file:///" + string2;
                    this.mediaLocationTextField.setText(string3);
                    this.setAsText(string3);
                }
            } else {
                MediaPlayerRTPDialog mediaPlayerRTPDialog = new MediaPlayerRTPDialog(this.getFrame(this.editPanel));
                mediaPlayerRTPDialog.show();
                String string4 = mediaPlayerRTPDialog.getRTPAdr();
                if (string4 != null) {
                    String string5 = "rtp://" + string4;
                    this.mediaLocationTextField.setText(string5);
                    this.setAsText(string5);
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        return this.mediaLocationString;
    }

    public Component getCustomEditor() {
        return this.editPanel;
    }

    Frame getFrame(Component component) {
        Point point = component.getLocationOnScreen();
        Frame frame = new Frame();
        ((Component)frame).setLocation(point);
        return frame;
    }

    public String getJavaInitializationString() {
        String string = this.mediaLocationString.length() == 0 ? "new java.lang.String(\"\\\")" : "new java.lang.String(\"" + this.mediaLocationString + "\")";
        return string;
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 100);
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.getAsText();
    }

    public boolean isPaintable() {
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (!string.equals(this.chooseOneString)) {
            this.mediaLocationTextField.setEnabled(true);
            if (string.equals(this.fileString)) {
                this.browseB.setEnabled(true);
                this.isFile = true;
            } else if (string.equals(this.rtpString)) {
                this.browseB.setEnabled(true);
            } else {
                this.browseB.setEnabled(false);
            }
            if (!string.equals(this.codeString)) {
                this.mediaLocationTextField.setText(string);
            } else {
                this.mediaLocationTextField.setText("");
            }
            this.mediaLocationString = this.mediaLocationTextField.getText();
        } else {
            this.mediaLocationTextField.setEnabled(false);
            this.browseB.setEnabled(false);
        }
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawString(this.mediaLocationString, rectangle.x, rectangle.y + rectangle.height - 6);
        graphics.setColor(color);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) {
        this.mediaLocationString = string;
    }

    public void setValue(Object object) {
        this.setAsText(object.toString());
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

