/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import net.dialang.client.ClientDebug;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Config {
    public static final String IOERROR = "ioerror";
    public static final String PUNCTUATION = "punctuation";
    public static final String LOCAL = "local";
    public static final String DEBUGWINDOW = "debugwindow";
    public static final String PROXY = "proxy";
    public static final String PROXYUSERNAME = "proxyusername";
    public static final String PROXYPASSWORD = "proxypassword";
    public static final String DOMAIN = "domain";
    public static final String ALLOC = "alloc";
    public static final String VERSION = "version";
    public static final String RDB = "rdb";
    public static final String CACHE = "cache";
    public static final String PRECACHE = "precache";
    public static final String DEBUG = "debug";
    public static final String MEMORY = "memory";
    public static final String CONFIG = "config";
    public static final String BOOKLET = "booklet";
    public static final String LOGFILE = "logfile";
    public static final String LOGIN = "username";
    public static final String PASSWORD = "password";
    public static final String DATACAPTURE = "datacapture";
    public static final String ITEMLEVELADAPTIVITY = "itemleveladaptivity";
    private HashMap converterLookup;
    private Properties props;
    private File sourceFile;

    private final HashMap createLookup() {
        HashMap<String, Converter> hashMap = new HashMap<String, Converter>(16);
        BooleanConverter booleanConverter = new BooleanConverter();
        FileConverter fileConverter = new FileConverter();
        StringConverter stringConverter = new StringConverter();
        hashMap.put(IOERROR, fileConverter);
        hashMap.put(PUNCTUATION, fileConverter);
        hashMap.put(LOCAL, booleanConverter);
        hashMap.put(DEBUGWINDOW, booleanConverter);
        hashMap.put(PROXY, new ProxyConverter());
        hashMap.put(PROXYUSERNAME, stringConverter);
        hashMap.put(PROXYPASSWORD, stringConverter);
        hashMap.put(DOMAIN, stringConverter);
        hashMap.put(ALLOC, fileConverter);
        hashMap.put(VERSION, fileConverter);
        hashMap.put(RDB, new RDBConverter());
        hashMap.put(CACHE, fileConverter);
        hashMap.put(PRECACHE, booleanConverter);
        hashMap.put(DEBUG, new DebugConverter());
        hashMap.put(MEMORY, booleanConverter);
        hashMap.put(CONFIG, booleanConverter);
        hashMap.put(BOOKLET, new IntegerConverter());
        hashMap.put(LOGFILE, fileConverter);
        hashMap.put(LOGIN, stringConverter);
        hashMap.put(PASSWORD, stringConverter);
        hashMap.put(DATACAPTURE, booleanConverter);
        hashMap.put(ITEMLEVELADAPTIVITY, booleanConverter);
        return hashMap;
    }

    public void loadConfig(File file) throws IOException {
        this.sourceFile = file;
        this.props.load(new FileInputStream(this.sourceFile));
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.converterLookup.get(string) != null) continue;
            this.props.remove(string);
        }
    }

    public Object getConfig(String string) throws Exception {
        Converter converter = (Converter)this.converterLookup.get(string);
        return converter.convert(this.props.getProperty(string));
    }

    public void save() throws IOException {
        this.props.store(new FileOutputStream(this.sourceFile), "Machine written");
    }

    public void put(String string, String string2) throws IOException {
        this.props.put(string, string2);
        this.save();
    }

    public void remove(String string) {
        this.props.remove(string);
    }

    private final /* synthetic */ void this() {
        this.props = new Properties();
    }

    public Config() {
        this.this();
        this.converterLookup = this.createLookup();
    }

    private class FileConverter
    implements Converter {
        public Object convert(String string) throws Exception {
            if (string == null) {
                return null;
            }
            string = string.replace('/', File.separatorChar);
            return new File(string);
        }

        private FileConverter() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DebugConverter
    implements Converter {
        int debugLevel;
        ClientDebug dbg;

        public Object convert(String string) throws Exception {
            if (string == null) {
                return new Integer(this.debugLevel);
            }
            if (string.equals("ALL")) {
                string = "DEFAULT,IDENT,CACHE,COMMS,MEMORY,RESOURCE,ITEM,MODEL,PROTOCOL,PAGE,HTMLSTACK,WIDGET,VIEW,JAM,NAVIGATE,DIALOGUE,MEDIA,PREEST,CAT,DATACAPTURE,PRECACHE";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                int n = this.dbg.getLevel(string2);
                if (n == -1) continue;
                this.debugLevel |= n;
            }
            return new Integer(this.debugLevel);
        }

        private final /* synthetic */ void this() {
            this.debugLevel = 0;
            this.dbg = new ClientDebug(-1);
        }

        private DebugConverter() {
            this.this();
        }
    }

    private class BooleanConverter
    implements Converter {
        public Object convert(String string) throws Exception {
            if (string == null) {
                return Boolean.FALSE;
            }
            return Boolean.valueOf(string);
        }

        private BooleanConverter() {
        }
    }

    private class ProxyConverter
    implements Converter {
        public Object convert(String string) throws Exception {
            if (string == null) {
                return null;
            }
            int n = string.lastIndexOf(58);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return string;
        }

        private ProxyConverter() {
        }
    }

    private class RDBConverter
    implements Converter {
        ArrayList v;

        public Object convert(String string) {
            Object object;
            this.v = new ArrayList();
            if (string == null) {
                return this.v;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                object = ((String)object).replace('/', File.separatorChar);
                this.v.add(new File((String)object));
            }
            object = this.v.toArray();
            File[] fileArray = new File[((Object[])object).length];
            int n = 0;
            while (n < ((Object)object).length) {
                fileArray[n] = (File)object[n];
                ++n;
            }
            this.v = null;
            return fileArray;
        }

        private RDBConverter() {
        }
    }

    private class LookAndFeelConverter
    implements Converter {
        public Object convert(String string) throws Exception {
            return string;
        }

        private LookAndFeelConverter() {
        }
    }

    private class IntegerConverter
    implements Converter {
        public Object convert(String string) throws Exception {
            if (string == null) {
                return null;
            }
            return new Integer(string);
        }

        private IntegerConverter() {
        }
    }

    private class StringConverter
    implements Converter {
        public Object convert(String string) throws Exception {
            return string;
        }

        private StringConverter() {
        }
    }

    private static interface Converter {
        public Object convert(String var1) throws Exception;
    }
}

