/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Timer;
import net.dialang.client.Main;
import net.dialang.client.Navigation;
import net.dialang.client.media.Media;
import net.dialang.client.model.Model;
import net.dialang.client.pages.error.ErrorHandleView;
import net.dialang.client.splash.Splash;
import net.dialang.client.views.ApplicationView;
import net.dialang.client.views.GraphViewer;
import net.dialang.client.widget.ResourceManager;
import net.dialang.client.widget.Widget;
import net.dialang.common.cat.CATListener;
import net.dialang.common.cat.ThetaEvent;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.jam.Application;
import net.dialang.mytest.jam.Jam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Dialang
extends Jam
implements Application,
CATListener {
    protected static Model model;
    protected static ResourceManager rdb;
    private static ApplicationView av;
    protected static Debug debug;
    private static Timer memoryTracer;
    static Navigation nav;
    private static Splash splash;
    public static final boolean researchMode = false;
    private static GraphViewer gv;
    protected static PrintStream stdErr;
    protected static PrintStream stdOut;
    private ArrayList thetaHistory;
    private ArrayList seHistory;

    public void startPilotMode() {
        av.setTitle("Dialang - Piloting Mode");
    }

    void setNavigation(Navigation navigation) {
        nav = navigation;
        model.setNavigation(navigation);
        this.getFrame(av).addWindowListener(nav);
    }

    public void thetaCalculated(ThetaEvent thetaEvent) {
    }

    public static void setSplash(Splash splash) {
        Dialang.splash = splash;
    }

    public void configure() throws IOException {
        stdOut = System.out;
        stdErr = System.err;
        this.initDebug();
        av = new ApplicationView(model);
        av.setDebug(debug, 8192);
        av.build();
        av.setVisible(true);
        av.setWaitCursor(true);
        splash.requestFocus();
        new ErrorHandleView();
        if (model.isItemLevelAdaptive()) {
            model.addCATListener(this);
        }
        this.getFrame(av).setIconImage(model.getImageIcon("tinylogo.gif").getImage());
        this.getFrame(av).addWindowListener(nav);
        splash.requestFocus();
    }

    public void initDebug() {
        debug = model.getDebug();
        super.setDebug(debug, 16384);
        Media.setDebug(debug, 131072);
        if (debug.getLevel() == 0) {
            return;
        }
        debug.prettyPrintLevel();
        if ((debug.getLevel() & 0x10) != 0) {
            memoryTracer = this.memoryTrace(30000, debug, 16);
            memoryTracer.start();
        }
    }

    private final Timer memoryTrace(int n, Debug debug, int n2) {
        ActionListener actionListener = new ActionListener(this, n2, debug){
            long peak;
            long lastUsed;
            Runtime runtime;
            final /* synthetic */ Dialang this$0;
            final /* synthetic */ int val$id;
            final /* synthetic */ Debug val$dbg;

            public final void actionPerformed(ActionEvent actionEvent) {
                long l = this.runtime.freeMemory() / 1024L;
                long l2 = this.runtime.totalMemory() / 1024L;
                long l3 = l2 - l;
                long l4 = l3 - this.lastUsed;
                this.peak = Math.max(l3, this.peak);
                this.lastUsed = l3;
                StringBuffer stringBuffer = new StringBuffer(96);
                stringBuffer.append("Total ");
                stringBuffer.append(l2);
                stringBuffer.append("k ");
                stringBuffer.append("Free ");
                stringBuffer.append(l);
                stringBuffer.append("k ");
                stringBuffer.append("Used ");
                stringBuffer.append(l3);
                stringBuffer.append("k ");
                stringBuffer.append("Diff ");
                stringBuffer.append(l4);
                stringBuffer.append("k ");
                stringBuffer.append("Peak ");
                stringBuffer.append(this.peak);
                stringBuffer.append("k ");
                this.val$dbg.println(this.val$id, stringBuffer.toString());
            }

            private final /* synthetic */ void this() {
                this.peak = 0L;
                this.lastUsed = 0L;
                this.runtime = Runtime.getRuntime();
            }
            {
                this.this$0 = dialang;
                this.val$id = n;
                this.val$dbg = debug;
                this.this();
            }
        };
        return new Timer(n, actionListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        model.propertyChange(propertyChangeEvent);
    }

    public void quit() {
        if (memoryTracer != null) {
            memoryTracer.stop();
        }
        model.softStopPrecache();
        try {
            if (!model.isLocal()) {
                model.getCommsHandler().disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getFrame(av).dispose();
        debug.println(1, "registered resources:");
        Enumeration enumeration = Widget.getNames();
        while (enumeration.hasMoreElements()) {
            debug.println(1, "\t" + (String)enumeration.nextElement());
        }
        Main.quit(0);
    }

    public void begin(Class clazz) {
        debug.println(1, "starting");
        this.start(clazz);
        model.startPhase1Precache();
    }

    private final /* synthetic */ void this() {
        this.thetaHistory = new ArrayList(50);
        this.seHistory = new ArrayList(50);
    }

    public Dialang() {
        this.this();
    }

    static {
        memoryTracer = null;
    }
}

