/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.swing.Timer;
import net.dialang.client.Main;
import net.dialang.client.Navigation;
import net.dialang.client.media.Media;
import net.dialang.client.model.Model;
import net.dialang.client.monitor.Monitor;
import net.dialang.client.pages.error.ErrorHandleView;
import net.dialang.client.splash.Splash;
import net.dialang.client.views.ApplicationView;
import net.dialang.client.views.DebugViewer;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.jam.Application;
import net.dialang.mytest.jam.Jam;
import net.dialang.widget.ResourceManager;
import net.dialang.widget.Widget;

public class Proto
extends Jam
implements Application {
    protected static Model model;
    protected static ResourceManager rdb;
    protected static Monitor monitor;
    private static ApplicationView av;
    private static DebugViewer dv;
    protected static Debug debug;
    private static Timer memoryTracer;
    static Navigation nav;
    private static Splash splash;
    protected static PrintStream stdErr;
    protected static PrintStream stdOut;

    public static void setSplash(Splash splash) {
        Proto.splash = splash;
    }

    public void configure() throws IOException {
        stdOut = System.out;
        stdErr = System.err;
        this.initDebug();
        av = new ApplicationView(model);
        av.setDebug(debug, 8192);
        av.build();
        av.setVisible(true);
        av.setWaitCursor(true);
        splash.requestFocus();
        new ErrorHandleView();
        nav = new Navigation();
        model.setNavigation(nav);
        ((Frame)this.getFrame(av)).setIconImage(model.getImageIcon("tinylogo.gif").getImage());
        this.getFrame(av).addWindowListener(nav);
        splash.requestFocus();
    }

    public void initDebug() {
        debug = model.getDebug();
        super.setDebug(debug, 16384);
        Media.setDebug(debug, 131072);
        if (debug.getLevel() == 0) {
            return;
        }
        debug.prettyPrintLevel();
        if ((debug.getLevel() & 0x10) != 0) {
            memoryTracer = this.memoryTrace(30000, debug, 16);
            memoryTracer.start();
        }
    }

    private Timer memoryTrace(int n, Debug debug, int n2) {
        Proto proto = this;
        if (proto == null) {
            throw null;
        }
        ActionListener actionListener = new ActionListener(proto, n2, debug){
            long peak;
            long lastUsed;
            Runtime runtime;
            private final /* synthetic */ Proto this$0;
            private final /* synthetic */ int val$id;
            private final /* synthetic */ Debug val$dbg;

            public void actionPerformed(ActionEvent actionEvent) {
                long l = this.runtime.freeMemory() / 1024L;
                long l2 = this.runtime.totalMemory() / 1024L;
                long l3 = l2 - l;
                long l4 = l3 - this.lastUsed;
                this.peak = Math.max(l3, this.peak);
                this.lastUsed = l3;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Total ");
                stringBuffer.append(l2);
                stringBuffer.append("k ");
                stringBuffer.append("Free ");
                stringBuffer.append(l);
                stringBuffer.append("k ");
                stringBuffer.append("Used ");
                stringBuffer.append(l3);
                stringBuffer.append("k ");
                stringBuffer.append("Diff ");
                stringBuffer.append(l4);
                stringBuffer.append("k ");
                stringBuffer.append("Peak ");
                stringBuffer.append(this.peak);
                stringBuffer.append("k ");
                this.val$dbg.println(this.val$id, stringBuffer.toString());
            }
            {
                this.val$id = n;
                this.val$dbg = debug;
                this.this$0 = proto;
                this.peak = 0L;
                this.lastUsed = 0L;
                this.runtime = Runtime.getRuntime();
                this.constructor$0(proto);
            }

            private final void constructor$0(Proto proto) {
            }
        };
        return new Timer(n, actionListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        model.propertyChange(propertyChangeEvent);
    }

    public void quit() {
        if (memoryTracer != null) {
            memoryTracer.stop();
        }
        try {
            if (!model.isLocal()) {
                model.getCommsHandler().getCache().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getFrame(av).dispose();
        debug.println(1, "registered resources:");
        Enumeration enumeration = Widget.getNames();
        while (enumeration.hasMoreElements()) {
            debug.println(1, "\t" + (String)enumeration.nextElement());
        }
        Main.quit(0);
    }

    public void begin(Class clazz) {
        debug.println(1, "starting");
        this.start(clazz);
    }

    public ApplicationView getAV() {
        return av;
    }

    static {
        memoryTracer = null;
    }
}

