/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.cache;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import net.dialang.client.cache.CacheEntry;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.io.Utils;

public class Cache {
    public static final int GZIPOBJECT = 1;
    public static final int STREAM = 2;
    public static final int MEMORY = 4;
    public static final int DISK = 8;
    private Debug debug;
    private int debugID;
    private URL baseURL;
    private File cacheDir;
    private File indexFile;
    private HashMap index = null;
    private String FILEKEY = "filekey";
    private String FILESUFFIX = ".dcf";
    private int fileID = 1000;

    public void setRoot(File file) throws IOException {
        this.cacheDir = new File(file.getCanonicalPath());
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            throw new IOException("failed creating directory " + this.cacheDir);
        }
        this.indexFile = new File(this.cacheDir, "index" + this.FILESUFFIX);
        String string = this.cacheDir.toString() + "/";
        string = string.replace(File.separatorChar, '/');
        try {
            this.baseURL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        if (this.debug != null) {
            this.debug.println(this.debugID, "cacheBaseURL: " + this.baseURL.toExternalForm());
            this.debug.println(this.debugID, "cacheDir: " + this.cacheDir.getPath());
            this.debug.println(this.debugID, "call open");
        }
        this.open();
        if (this.debug != null) {
            this.debug.println(this.debugID, "open successful");
        }
    }

    public void close() throws IOException {
        if (this.debug != null) {
            this.debug.println(this.debugID, "close");
        }
        if (this.index == null) {
            throw new RuntimeException("not open");
        }
        this.index.put(this.FILEKEY, new Integer(this.fileID));
        Iterator iterator = this.index.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.FILEKEY.equals(string)) continue;
            CacheEntry cacheEntry = (CacheEntry)this.index.get(string);
            if (Cache.isSet(cacheEntry.flags, 2)) continue;
            if (Cache.isSet(cacheEntry.flags, 12) && cacheEntry.obj != null) {
                File file = new File(this.cacheDir, cacheEntry.fileName);
                if (this.debug != null) {
                    this.debug.println(this.debugID, "put", "caching gzo", file);
                }
                Utils.writeGZIPObject(cacheEntry.obj, file);
            }
            cacheEntry.obj = null;
        }
        Utils.writeGZIPObject((Object)this.index, this.indexFile);
        this.index = null;
        if (this.debug != null) {
            this.debug.println(this.debugID, "close completed");
        }
    }

    private void newIndex() {
        if (this.debug != null) {
            this.debug.println(this.debugID, "new Index");
        }
        this.index = new HashMap();
        this.fileID = 1000;
    }

    public void open() throws IOException {
        if (this.debug != null) {
            this.debug.println(this.debugID, "open");
        }
        if (!this.indexFile.exists()) {
            this.newIndex();
            return;
        }
        if (!this.indexFile.canRead()) {
            throw new IOException("no read permissions on index file");
        }
        try {
            this.index = (HashMap)Utils.readGZIPObject(this.indexFile);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IOException(classNotFoundException.getMessage());
        }
        catch (EOFException eOFException) {
            if (this.debug != null) {
                this.debug.println(this.debugID, "truncated index file!");
            }
            this.newIndex();
            return;
        }
        this.fileID = (Integer)this.index.get(this.FILEKEY);
        if (this.debug != null) {
            this.debug.println(this.debugID, "loaded index ", this.indexFile);
        }
    }

    public synchronized void sync() throws IOException {
        if (this.debug != null) {
            this.debug.println(this.debugID, "sync");
        }
        this.close();
        this.open();
    }

    public void setDebug(Debug debug, int n) {
        if (debug == null) {
            return;
        }
        this.debug = debug;
        this.debugID = n;
        this.debug.println(this.debugID, "Debug set");
    }

    public boolean isCached(String string) {
        return this.index.containsKey(string);
    }

    public boolean isCachedInMemory(String string) {
        if (!this.isCached(string)) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)this.index.get(string);
        return cacheEntry.obj != null;
    }

    public long getTimeStamp(String string) {
        CacheEntry cacheEntry;
        if (this.debug != null) {
            this.debug.println(this.debugID, "getTimestamp", string);
        }
        if ((cacheEntry = (CacheEntry)this.index.get(string)) == null) {
            if (this.debug != null) {
                this.debug.println(this.debugID, "not cached");
            }
            return 0L;
        }
        return cacheEntry.timeStamp;
    }

    public long getLastUsed(String string) {
        CacheEntry cacheEntry;
        if (this.debug != null) {
            this.debug.println(this.debugID, "getLastUsed", string);
        }
        if ((cacheEntry = (CacheEntry)this.index.get(string)) == null) {
            if (this.debug != null) {
                this.debug.println(this.debugID, "not cached");
            }
            return 0L;
        }
        return cacheEntry.lastUsed;
    }

    public Object get(String string) throws IOException {
        Object object;
        CacheEntry cacheEntry;
        boolean bl = this.isImage(string);
        if (this.debug != null) {
            this.debug.println(this.debugID, "get", string);
        }
        if ((cacheEntry = (CacheEntry)this.index.get(string)) == null) {
            return null;
        }
        cacheEntry.lastUsed = System.currentTimeMillis();
        if (this.debug != null) {
            this.debug.println(this.debugID, "flags " + cacheEntry.flags);
        }
        if (cacheEntry.obj != null) {
            if (this.debug != null) {
                this.debug.println(this.debugID, "Returning Object from memory ...");
            }
            return cacheEntry.obj;
        }
        if (Cache.isSet(cacheEntry.flags, 2)) {
            if (bl) {
                if (this.debug != null) {
                    this.debug.println(this.debugID, "Returning ImageIcon ...");
                }
                return new ImageIcon(new URL(this.baseURL, cacheEntry.fileName));
            }
            if (this.debug != null) {
                this.debug.println(this.debugID, "Returning URL ...");
            }
            return new URL(this.baseURL, cacheEntry.fileName);
        }
        File file = new File(this.cacheDir, cacheEntry.fileName);
        if (this.debug != null) {
            this.debug.println(this.debugID, "get", "read", file);
        }
        try {
            object = Utils.readGZIPObject(file);
            if (this.debug != null) {
                this.debug.println(this.debugID, "Object type read from file - " + object.getClass());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        if (Cache.isSet(cacheEntry.flags, 4)) {
            if (this.debug != null) {
                this.debug.println(this.debugID, "get", "cacheing in core");
            }
            cacheEntry.obj = object;
        }
        return object;
    }

    private boolean isImage(String string) {
        return string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".jpeg");
    }

    private boolean isSound(String string) {
        return string.endsWith(".mp2") || string.endsWith(".mp3");
    }

    public URL getURL(String string) throws IOException {
        CacheEntry cacheEntry;
        if (this.debug != null) {
            this.debug.println(this.debugID, "getURL", string);
        }
        if ((cacheEntry = (CacheEntry)this.index.get(string)) == null) {
            return null;
        }
        URL uRL = new URL(this.baseURL, cacheEntry.fileName);
        if (this.debug != null) {
            this.debug.println(this.debugID, "getURL read" + uRL.toExternalForm());
        }
        return uRL;
    }

    public File getFile(String string) throws IOException {
        CacheEntry cacheEntry;
        if (this.debug != null) {
            this.debug.println(this.debugID, "getfile", string);
        }
        if ((cacheEntry = (CacheEntry)this.index.get(string)) == null) {
            return null;
        }
        File file = new File(this.cacheDir, cacheEntry.fileName);
        if (this.debug != null) {
            this.debug.println(this.debugID, "getfile", "read", file);
        }
        return file;
    }

    public void put(CacheEntry cacheEntry, String string) throws IOException {
        Object object;
        CacheEntry cacheEntry2;
        boolean bl = this.isImage(string);
        boolean bl2 = this.isSound(string);
        if (this.debug != null) {
            this.debug.println(this.debugID, "put", string, "timestamp " + cacheEntry.timeStamp);
        }
        if ((cacheEntry2 = (CacheEntry)this.index.get(string)) == null) {
            if (this.debug != null) {
                this.debug.println(this.debugID, "new entry for", string);
            }
            cacheEntry2 = new CacheEntry();
            if (bl || bl2) {
                cacheEntry2.fileName = string.substring(string.lastIndexOf(35) + 1);
            } else {
                object = null;
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    object = string.substring(n);
                }
                cacheEntry2.fileName = this.fileID++ + (String)(object != null ? object : this.FILESUFFIX);
            }
        }
        object = new File(this.cacheDir, cacheEntry2.fileName);
        cacheEntry2.flags = cacheEntry.flags;
        if (this.debug != null) {
            this.debug.println(this.debugID, "get flags " + cacheEntry2.flags);
        }
        cacheEntry2.timeStamp = cacheEntry.timeStamp;
        cacheEntry2.lastUsed = System.currentTimeMillis();
        if (cacheEntry.obj instanceof InputStream) {
            if (this.debug != null) {
                this.debug.println(this.debugID, "input is stream");
            }
            cacheEntry2.flags = Cache.setBit(cacheEntry2.flags, 2);
            if (Cache.isSet(cacheEntry2.flags, 4) && !bl) {
                if (this.debug != null) {
                    this.debug.println("Cannot temporarily cache sound or html input streams - flag ignored");
                }
                cacheEntry2.flags = Cache.clearBit(cacheEntry2.flags, 4);
            }
            if (!Cache.isSet(cacheEntry2.flags, 8)) {
                if (this.debug != null) {
                    this.debug.println("forcing DISK cache for input stream - flag not set");
                }
                cacheEntry2.flags = Cache.setBit(cacheEntry2.flags, 8);
            }
            InputStream inputStream = (InputStream)cacheEntry.obj;
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            if (this.debug != null) {
                this.debug.println(this.debugID, "caching input stream", object);
            }
            Utils.stream(inputStream, fileOutputStream);
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
            cacheEntry2.obj = bl ? new ImageIcon(((File)object).getPath()) : null;
        } else {
            if (this.debug != null) {
                this.debug.println(this.debugID, "input is object");
            }
            cacheEntry2.flags = Cache.setBit(cacheEntry2.flags, 1);
            if (Cache.isSet(cacheEntry2.flags, 4)) {
                if (this.debug != null) {
                    this.debug.println(this.debugID, "put", "caching in core", object);
                }
                cacheEntry2.obj = cacheEntry.obj;
            }
            if (Cache.isSet(cacheEntry2.flags, 8)) {
                if (this.debug != null) {
                    this.debug.println(this.debugID, "put", "caching gzo", object);
                }
                Utils.writeGZIPObject(cacheEntry.obj, (File)object);
            }
        }
        this.index.put(string, cacheEntry2);
        if (this.debug != null) {
            this.debug.println(this.debugID, "put", string, "done", "flags " + cacheEntry2.flags);
        }
    }

    public static final boolean isSet(int n, int n2) {
        return (n & n2) > 0;
    }

    public static final int setBit(int n, int n2) {
        return n |= n2;
    }

    public static final int clearBit(int n, int n2) {
        return n &= ~n2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: cachedump cache_dir");
            System.exit(1);
        }
        Cache cache = new Cache();
        try {
            cache.setRoot(new File(stringArray[0]));
            if (!cache.indexFile.canRead()) {
                System.err.println("No index file");
                System.exit(1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Iterator iterator = cache.index.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(cache.FILEKEY)) continue;
            CacheEntry cacheEntry = (CacheEntry)cache.index.get(string);
            System.out.println(string + " " + cacheEntry);
        }
        System.out.println("next id " + (Integer)cache.index.get(cache.FILEKEY));
    }

    public Cache() {
    }

    public Cache(File file) throws IOException {
        this.setRoot(file);
    }
}

