/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.dialogues;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.dialang.client.Status;
import net.dialang.client.dialogues.Dialogue;
import net.dialang.client.model.Model;
import net.dialang.client.wlib.WButton;
import net.dialang.client.wlib.WLabel;
import net.dialang.client.wlib.WPanel;
import net.dialang.client.wlib.WToggleButton;
import net.dialang.style.DialangBorder;

public abstract class DialangDialogue
extends Dialogue {
    protected static Model model;
    protected WPanel dialogue;
    protected JLabel graphic;
    private WLabel title;
    private WButton yesButton;
    private WButton noButton;
    private WButton okButton;
    private WButton quitButton;
    public WButton exitButton;
    private WPanel yesPanel;
    private WPanel noPanel;
    private WPanel okPanel;
    private WPanel quitPanel;
    private WLabel yesText;
    private WLabel noText;
    private WLabel okText;
    private WLabel quitText;
    private boolean loadImages;
    private WToggleButton[] itemButton;
    private WPanel titleCenter;

    public static void setModel(Model model) {
        DialangDialogue.model = model;
    }

    public void init(boolean bl, boolean bl2) {
        super.setModal(bl);
        this.dialogue = new WPanel(new BorderLayout());
        this.dialogue.setBorder(new DialangBorder(Color.yellow, 2, 0, 0, 0, 0));
        WPanel wPanel = new WPanel(new BorderLayout());
        wPanel.getWidget().setName("topbar");
        wPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.title = new WLabel();
        this.title.getWidget().setName("title");
        this.titleCenter = new WPanel(new FlowLayout(1));
        this.titleCenter.add(this.title);
        wPanel.add((Component)this.titleCenter, "Center");
        this.dialogue.add((Component)wPanel, "North");
        this.loadImages = bl2;
        if (!this.loadImages) {
            return;
        }
        try {
            this.graphic = new JLabel(model.getImageIcon("DialogueLogo.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            debug.println("DialangDialogue: error getting D1 image");
            throw new RuntimeException(iOException.toString());
        }
        this.exitButton = new WButton();
        this.exitButton.getWidget().setName("exitbutton");
        this.exitButton.setMargin(new Insets(0, 0, 0, 0));
        try {
            this.exitButton.setIcon(model.getImageIcon("ExitDialogue.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            debug.println("DialangDialogue:  Error getting exit image");
            throw new RuntimeException(iOException.toString());
        }
        this.exitButton.setEnabled(false);
        wPanel.add((Component)this.exitButton, "East");
        wPanel.add((Component)this.graphic, "West");
        try {
            this.yesButton = new WButton();
            this.yesButton.setIcon(model.getImageIcon("yes.gif"));
            this.yesButton.getWidget().setName("button");
            this.noButton = new WButton();
            this.noButton.setIcon(model.getImageIcon("no.gif"));
            this.noButton.getWidget().setName("button");
            this.okButton = new WButton();
            this.okButton.setIcon(model.getImageIcon("yes.gif"));
            this.okButton.getWidget().setName("button");
            this.quitButton = new WButton();
            this.quitButton.setIcon(model.getImageIcon("bigcross.gif"));
            this.quitButton.getWidget().setName("button");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            debug.println("DialangDialogue: problem getting button icon");
            throw new RuntimeException(iOException.toString());
        }
        this.yesPanel = new WPanel(new BorderLayout());
        this.yesPanel.getWidget().setName("dialoguebutton");
        this.yesPanel.getWidget().setRoot();
        this.yesText = new WLabel(model.getVocab(Status.Caption_Yes));
        this.yesText.getWidget().setName("buttontext");
        this.yesPanel.add((Component)this.yesButton, "Center");
        WPanel wPanel2 = new WPanel(new FlowLayout(1));
        wPanel2.add(this.yesText);
        this.yesPanel.add((Component)wPanel2, "South");
        this.noPanel = new WPanel(new BorderLayout());
        this.noPanel.getWidget().setName("dialoguebutton");
        this.noPanel.getWidget().setRoot();
        this.noText = new WLabel(model.getVocab(Status.Caption_No));
        this.noText.getWidget().setName("buttontext");
        this.noPanel.add((Component)this.noButton, "Center");
        WPanel wPanel3 = new WPanel(new FlowLayout(1));
        wPanel3.add(this.noText);
        this.noPanel.add((Component)wPanel3, "South");
        this.okPanel = new WPanel(new BorderLayout());
        this.okPanel.getWidget().setName("dialoguebutton");
        this.okPanel.getWidget().setRoot();
        this.okText = new WLabel("OK");
        this.okText.getWidget().setName("buttontext");
        this.okPanel.add((Component)this.okButton, "Center");
        WPanel wPanel4 = new WPanel(new FlowLayout(1));
        wPanel4.add(this.okText);
        this.okPanel.add((Component)wPanel4, "South");
        this.quitPanel = new WPanel(new BorderLayout());
        this.quitPanel.getWidget().setName("dialoguebutton");
        this.quitPanel.getWidget().setRoot();
        this.quitText = new WLabel(model.getVocab(Status.Caption_Quit));
        this.quitText.getWidget().setName("buttontext");
        this.quitPanel.add((Component)this.quitButton, "Center");
        WPanel wPanel5 = new WPanel(new FlowLayout(1));
        wPanel5.add(this.quitText);
        this.quitPanel.add((Component)wPanel5, "South");
    }

    public void useItemButtons(String[] stringArray, ActionListener actionListener, int n) {
        this.titleCenter.removeAll();
        this.itemButton = new WToggleButton[stringArray.length];
        ActionListener actionListener2 = new ActionListener(this){
            final /* synthetic */ DialangDialogue this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < DialangDialogue.access$0(this.this$0).length) {
                    if (!actionEvent.getSource().equals(DialangDialogue.access$0(this.this$0)[n])) {
                        DialangDialogue.access$0(this.this$0)[n].setSelected(false);
                    }
                    ++n;
                }
                ((WToggleButton)actionEvent.getSource()).setSelected(true);
            }
            {
                this.this$0 = dialangDialogue;
            }
        };
        int n2 = 0;
        while (n2 < this.itemButton.length) {
            this.itemButton[n2] = new WToggleButton();
            this.itemButton[n2].setText(stringArray[n2]);
            this.itemButton[n2].getWidget().setName("itembutton");
            this.itemButton[n2].addActionListener(actionListener);
            this.itemButton[n2].addActionListener(actionListener2);
            if (n2 == n) {
                this.itemButton[n2].setSelected(true);
            }
            this.titleCenter.add(this.itemButton[n2]);
            ++n2;
        }
    }

    public int getSelectedItem() {
        if (this.itemButton == null || this.itemButton.length < 1) {
            return -1;
        }
        int n = 0;
        while (n < this.itemButton.length) {
            if (this.itemButton[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void useTitle() {
        this.titleCenter.removeAll();
        this.titleCenter.add(this.title);
    }

    public void setDialogue(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialogue.add((Component)jComponent, "Center");
        super.setDialogue(this.dialogue);
        this.getWidget().setName("dialogue");
        this.getWidget().setRoot();
    }

    protected void addExitListener(ActionListener actionListener) {
        if (this.loadImages) {
            this.exitButton.addActionListener(actionListener);
        }
    }

    protected void setExitButtonVisible(boolean bl) {
        if (this.loadImages) {
            this.exitButton.setVisible(bl);
        }
    }

    protected boolean isButtonExitVisible() {
        if (!this.loadImages) {
            return false;
        }
        return this.exitButton.isVisible();
    }

    protected void setExitButtonEnabled(boolean bl) {
        if (this.loadImages) {
            this.exitButton.setEnabled(bl);
        }
    }

    protected boolean isExitButtonEnabled() {
        if (!this.loadImages) {
            return false;
        }
        return this.exitButton.isEnabled();
    }

    public void setExitAsForwards(boolean bl) {
        try {
            if (bl) {
                this.exitButton.setIcon(model.getImageIcon("next.gif"));
            } else {
                this.exitButton.setIcon(model.getImageIcon("ExitDialogue.gif"));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            debug.println("DialangDialogue: problem getting button icon");
            throw new RuntimeException(iOException.toString());
        }
        this.yesPanel = new WPanel(new BorderLayout());
    }

    public void setExitAsBackwards(boolean bl) {
        try {
            if (bl) {
                this.exitButton.setIcon(model.getImageIcon("prev.gif"));
            } else {
                this.exitButton.setIcon(model.getImageIcon("ExitDialogue.gif"));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            debug.println("DialangDialogue: problem getting button icon");
            throw new RuntimeException(iOException.toString());
        }
        this.yesPanel = new WPanel(new BorderLayout());
    }

    protected WPanel getYesButton() {
        if (!this.loadImages) {
            return null;
        }
        return this.yesPanel;
    }

    protected void addYesListener(ActionListener actionListener) {
        if (this.loadImages) {
            this.yesButton.addActionListener(actionListener);
        }
    }

    protected WPanel getNoButton() {
        if (!this.loadImages) {
            return null;
        }
        return this.noPanel;
    }

    protected void addNoListener(ActionListener actionListener) {
        if (this.loadImages) {
            this.noButton.addActionListener(actionListener);
        }
    }

    protected void changeButtonsALS() {
        if (!this.loadImages) {
            return;
        }
        this.yesText.setText(model.getVocab(Status.Caption_Yes));
        this.noText.setText(model.getVocab(Status.Caption_No));
        this.okText.setText("OK");
        this.quitText.setText(model.getVocab(Status.Caption_Quit));
    }

    protected WPanel getOKButton() {
        if (!this.loadImages) {
            return null;
        }
        return this.okPanel;
    }

    protected void addOKListener(ActionListener actionListener) {
        if (this.loadImages) {
            this.okButton.addActionListener(actionListener);
        }
    }

    protected WPanel getQuitButton() {
        if (!this.loadImages) {
            return null;
        }
        return this.quitPanel;
    }

    protected void addQuitListener(ActionListener actionListener) {
        if (this.loadImages) {
            this.quitButton.addActionListener(actionListener);
        }
    }

    protected void setTitle(String string) {
        this.title.setText(string);
    }

    static /* synthetic */ WToggleButton[] access$0(DialangDialogue dialangDialogue) {
        return dialangDialogue.itemButton;
    }

    public DialangDialogue() {
        this.init(true, true);
    }

    public DialangDialogue(boolean bl) {
        this.init(bl, true);
    }

    public DialangDialogue(boolean bl, boolean bl2) {
        this.init(bl, bl2);
    }
}

