/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.dialogues;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.dialang.client.Status;
import net.dialang.client.dialogues.NonModalDialogue;
import net.dialang.client.model.Model;
import net.dialang.client.wlib.WButton;
import net.dialang.client.wlib.WLabel;
import net.dialang.client.wlib.WPanel;
import net.dialang.style.DialangBorder;

public abstract class NonModalDialangDialogue
extends NonModalDialogue {
    protected static Model model;
    protected WPanel dialogue = new WPanel(new BorderLayout());
    protected JLabel graphic;
    private WLabel title;
    private WButton exitButton;
    private WButton yesButton;
    private WButton noButton;
    private WPanel yesPanel;
    private WPanel noPanel;
    private WLabel yesText;
    private WLabel noText;

    public static void setModel(Model model) {
        NonModalDialangDialogue.model = model;
    }

    public void setDialogue(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialogue.add((Component)jComponent, "Center");
        super.setDialogue(this.dialogue);
        this.getWidget().setName("dialogue");
        this.getWidget().setRoot();
    }

    protected void addExitListener(ActionListener actionListener) {
        this.exitButton.addActionListener(actionListener);
    }

    protected void setExitButtonVisible(boolean bl) {
        this.exitButton.setVisible(bl);
    }

    protected boolean isButtonExitVisible() {
        return this.exitButton.isVisible();
    }

    protected void setExitButtonEnabled(boolean bl) {
        this.exitButton.setEnabled(bl);
    }

    protected boolean isExitButtonEnabled() {
        return this.exitButton.isEnabled();
    }

    protected WPanel getYesButton() {
        return this.yesPanel;
    }

    protected void addYesListener(ActionListener actionListener) {
        this.yesButton.addActionListener(actionListener);
    }

    protected WPanel getNoButton() {
        return this.noPanel;
    }

    protected void addNoListener(ActionListener actionListener) {
        this.noButton.addActionListener(actionListener);
    }

    protected void changeButtonsALS() {
        this.yesText.setText(model.getVocab(Status.Caption_Yes));
        this.noText.setText(model.getVocab(Status.Caption_No));
    }

    protected void setTitle(String string) {
        this.title.setText(string);
    }

    public NonModalDialangDialogue() {
        this.dialogue.setBorder(new DialangBorder(Color.yellow, 2, 0, 0, 0, 0));
        WPanel wPanel = new WPanel(new BorderLayout());
        wPanel.getWidget().setName("topbar");
        try {
            this.graphic = new JLabel(model.getImageIcon("DialogueLogo.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            debug.println("NonModalDialangDialogue: couldn't get logo");
            throw new RuntimeException(iOException.toString());
        }
        this.exitButton = new WButton();
        this.exitButton.getWidget().setName("exitbutton");
        this.exitButton.setMargin(new Insets(0, 0, 0, 0));
        try {
            this.exitButton.setIcon(model.getImageIcon("ExitDialogue.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            debug.println("NonModalDialangDialogue: couldn't get exit graphic");
            throw new RuntimeException(iOException.toString());
        }
        this.exitButton.setEnabled(false);
        wPanel.add((Component)this.exitButton, "East");
        wPanel.setBorder(BorderFactory.createBevelBorder(0));
        wPanel.add((Component)this.graphic, "West");
        this.title = new WLabel();
        this.title.getWidget().setName("title");
        WPanel wPanel2 = new WPanel(new FlowLayout(1));
        wPanel2.add(this.title);
        wPanel.add((Component)wPanel2, "Center");
        this.dialogue.add((Component)wPanel, "North");
        this.yesButton = new WButton();
        this.yesButton.setIcon(new ImageIcon("Yes.gif"));
        this.noButton = new WButton();
        this.noButton.setIcon(new ImageIcon("No.gif"));
        this.yesPanel = new WPanel(new BorderLayout());
        this.yesText = new WLabel(model.getVocab(Status.Caption_Yes));
        this.yesText.getWidget().setName("yes");
        this.yesPanel.add((Component)this.yesButton, "Center");
        WPanel wPanel3 = new WPanel(new FlowLayout(1));
        wPanel3.add(this.yesText);
        this.yesPanel.add((Component)wPanel3, "South");
        this.noPanel = new WPanel(new BorderLayout());
        this.noText = new WLabel(model.getVocab(Status.Caption_No));
        this.noText.getWidget().setName("no");
        this.noPanel.add((Component)this.noButton, "Center");
        WPanel wPanel4 = new WPanel(new FlowLayout(1));
        wPanel4.add(this.noText);
        this.noPanel.add((Component)wPanel4, "South");
    }
}

