/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.keyext;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import net.dialang.client.keyext.KeyData;
import net.dialang.client.keyext.KeySet;
import net.dialang.mytest.util.Util;
import net.dialang.style.StyledButton;

public class KeyExt {
    private JPanel panel;
    private KeySet ks;
    private JWindow window = null;

    public static void main(String[] stringArray) {
        KeySet keySet;
        boolean bl = false;
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-r")) {
                bl = true;
            }
            if (stringArray[n].equals("-l")) {
                string = stringArray[++n];
            }
            ++n;
        }
        if (string == null) {
            System.err.println("Usage: KeyExt -r|-g -l lang_id\n(6 digit with leading zeros)");
            System.exit(1);
        }
        if ((keySet = KeyData.get(string)) == null) {
            System.err.println("language " + string + " not found ");
            System.exit(1);
        }
        JFrame jFrame = new JFrame("KeyExt demo");
        ((Component)jFrame).setSize(400, 400);
        KeyExt keyExt = new KeyExt(keySet, bl, jFrame);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setPreferredSize(new Dimension(200, 200));
        jFrame.getContentPane().add(jTextPane);
        jFrame.show();
        keyExt.getWindow().show();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JWindow getWindow() {
        return this.window;
    }

    private JPanel createKeyGrid() {
        return this.createKeyPanel(this.ks.getGrid(), new GridLayout(this.ks.getGridLayout().height, this.ks.getGridLayout().width, 0, 0));
    }

    private JPanel createKeyRow() {
        return this.createKeyPanel(this.ks.getRow(), new GridLayout(1, 0, 0, 0));
    }

    private JPanel createKeyPanel(Enumeration enumeration, LayoutManager layoutManager) {
        Object object;
        JPanel jPanel = new JPanel(layoutManager);
        jPanel.setOpaque(false);
        Insets insets = new Insets(0, 3, 0, 4);
        while (enumeration.hasMoreElements()) {
            StyledButton styledButton;
            object = (String)enumeration.nextElement();
            if (KeySet.isGap((String)object)) {
                JSeparator jSeparator = new JSeparator();
                jSeparator.setVisible(false);
                jPanel.add(jSeparator);
                continue;
            }
            if (this.ks.isModifier((String)object)) {
                styledButton = new StyledButton(false, (String)object, (String)object, new ModifyAction(this.ks));
                if (!((String)object).equals("^")) {
                    Util.adjFontSize(styledButton, 4);
                }
            } else {
                styledButton = new StyledButton(false, (String)object, (String)object, new PasteAction());
            }
            styledButton.setMargin(insets);
            styledButton.setFocusPainted(false);
            styledButton.setRequestFocusEnabled(false);
            styledButton.setMaximumSize(styledButton.getPreferredSize());
            jPanel.add(styledButton);
        }
        object = new JPanel(new FlowLayout(2, 0, 1));
        ((Container)object).add(jPanel);
        ((JComponent)object).setOpaque(false);
        ((JComponent)object).setMaximumSize(((JComponent)object).getPreferredSize());
        return object;
    }

    public KeyExt(KeySet keySet) {
        this.ks = keySet;
        this.panel = this.createKeyRow();
    }

    public KeyExt(KeySet keySet, boolean bl) {
        this.ks = keySet;
        this.panel = bl ? this.createKeyRow() : this.createKeyGrid();
    }

    public KeyExt(KeySet keySet, boolean bl, Frame frame) {
        this(keySet, bl);
        this.window = new JWindow(frame);
        JPanel jPanel = (JPanel)this.window.getContentPane();
        jPanel.setBorder(BorderFactory.createCompoundBorder(new BevelBorder(0), new BevelBorder(1)));
        jPanel.add(this.panel);
        ((Component)this.window).setSize(jPanel.getPreferredSize());
        ((Component)this.window).setLocation(frame.getLocation());
    }

    private static class PasteAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent == null) {
                return;
            }
            if (jTextComponent.getSelectedText() == "") {
                int n = jTextComponent.getCaretPosition();
                jTextComponent.setSelectionStart(n);
                jTextComponent.setSelectionEnd(n);
            }
            jTextComponent.replaceSelection(actionEvent.getActionCommand());
            jTextComponent.requestFocus();
        }

        PasteAction() {
            super("paste");
        }
    }

    private static class ModifyAction
    extends TextAction {
        private KeySet ks;

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent == null) {
                return;
            }
            int n = jTextComponent.getSelectedText() == "" ? jTextComponent.getCaretPosition() : jTextComponent.getSelectionEnd();
            if (n == 0) {
                return;
            }
            jTextComponent.setSelectionStart(n - 1);
            jTextComponent.setSelectionEnd(n);
            String string = actionEvent.getActionCommand();
            String string2 = jTextComponent.getSelectedText();
            String string3 = null;
            while (!this.ks.isModifiable(string, string2)) {
                string3 = KeyData.getBase(string2);
                if (string3 != null) {
                    string2 = string3;
                    continue;
                }
                jTextComponent.setSelectionStart(n);
                jTextComponent.setSelectionEnd(n);
                jTextComponent.requestFocus();
                return;
            }
            String string4 = KeyData.Modify(string, string2);
            if (string4.equals(jTextComponent.getSelectedText())) {
                string4 = string3;
            }
            jTextComponent.replaceSelection(string4);
            jTextComponent.requestFocus();
        }

        ModifyAction(KeySet keySet) {
            super("modify");
            this.ks = keySet;
        }
    }
}

