/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.media;

import java.io.IOException;
import net.dialang.client.media.MediaCompletedListener;
import net.dialang.client.media.MediaProvider;
import net.dialang.client.media.image.ImageMediaView;
import net.dialang.client.media.no.NoMediaView;
import net.dialang.client.media.sound.SoundMediaView;
import net.dialang.client.media.text.TextMediaView;
import net.dialang.client.wlib.WPanel;
import net.dialang.entity.MediaModel;
import net.dialang.mytest.debug.Debug;

public abstract class Media
extends WPanel {
    protected static int debugID;
    protected static Debug debug;
    private MediaCompletedListener completedListener;

    public static Media createMedia(MediaModel mediaModel) {
        Media media;
        if (mediaModel == null) {
            return null;
        }
        String string = mediaModel.getVocabSubKey();
        if (string.equals("NOMEDIA")) {
            media = new NoMediaView();
        } else if (string.equals("TEXT")) {
            media = new TextMediaView();
        } else if (string.equals("SOUND")) {
            media = new SoundMediaView();
        } else if (string.equals("IMAGE")) {
            media = new ImageMediaView();
        } else {
            throw new RuntimeException("unrecognised Media entity " + string);
        }
        return media;
    }

    public static void loadMedia(MediaModel mediaModel, MediaProvider mediaProvider) throws IOException {
        if (mediaModel == null) {
            return;
        }
        String string = mediaModel.getVocabSubKey();
        if (string.equals("NOMEDIA")) {
            return;
        }
        if (string.equals("TEXT")) {
            return;
        }
        if (string.equals("SOUND")) {
            String string2 = mediaModel.getRef();
            mediaProvider.getAudio(string2);
            return;
        }
        if (string.equals("IMAGE")) {
            String string3 = mediaModel.getRef();
            mediaProvider.getImageIcon(string3);
            return;
        }
        throw new RuntimeException("unrecognised Media entity " + string);
    }

    public static void setDebug(Debug debug, int n) {
        Media.debug = debug;
        debugID = n;
    }

    public void setCompletedListener(MediaCompletedListener mediaCompletedListener) {
        this.completedListener = mediaCompletedListener;
    }

    protected void mediaCompleted(boolean bl) {
        if (this.completedListener == null) {
            return;
        }
        this.completedListener.mediaCompleted(bl);
    }

    protected void mediaReady(boolean bl) {
        if (this.completedListener == null) {
            return;
        }
        this.completedListener.mediaReady(bl);
    }

    protected void mediaStarted(boolean bl) {
        if (this.completedListener == null) {
            return;
        }
        this.completedListener.mediaStarted(bl);
    }

    public abstract void setModel(MediaModel var1, MediaProvider var2) throws IOException;

    public void stop() {
    }

    public void reset() {
    }

    public void setEnabled(boolean bl) {
    }
}

