/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.media.sound;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaTimeSetEvent;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TransitionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.dialang.client.media.Media;
import net.dialang.client.media.MediaProvider;
import net.dialang.client.model.Model;
import net.dialang.client.model.Session;
import net.dialang.client.wlib.HTMLPane;
import net.dialang.client.wlib.WSlider;
import net.dialang.client.wlib.WToggleButton;
import net.dialang.entity.MediaModel;
import net.dialang.entity.SoundMediaModel;
import net.dialang.vocab.VocabStatus;

public class SoundMediaController
extends Media
implements ControllerListener {
    private static ImageIcon spkNotPressed;
    private static ImageIcon spkPressed;
    private static ImageIcon spkDisabled;
    private static ImageIcon spkFocus;
    private SoundMediaModel media;
    private WToggleButton playButton;
    private WToggleButton controlButton;
    private ButtonGroup group;
    private HTMLPane prompt;
    private Player player;
    private boolean stopped;
    private WSlider volume;
    private Model model;

    public void setModel(MediaModel mediaModel, MediaProvider mediaProvider) throws IOException {
        Media.debug.println(Media.debugID, "Thread: " + Thread.currentThread().getName() + ". MediaModel Ref: " + mediaModel.getRef());
        this.media = (SoundMediaModel)mediaModel;
        this.initIcons(mediaProvider);
        this.prompt.setText(mediaProvider.getVocab(VocabStatus.LangTest_PlaySound));
        int n = 10;
        Media.debug.println(Media.debugID, "Getting sound media URL  for " + mediaModel.getRef() + " ...");
        URL uRL = mediaProvider.getAudio(mediaModel.getRef());
        if (uRL == null) {
            Media.debug.println(Media.debugID, "Null URL returned from MediaProvider.");
        }
        Media.debug.println(Media.debugID, "Sound Media URL: " + uRL.toExternalForm());
        try {
            this.player = Manager.createPlayer((URL)uRL);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        this.player.addControllerListener((ControllerListener)this);
        Media.debug.println(Media.debugID, "TestMediaAudio/Realize...");
        SoundMediaController soundMediaController = this;
        if (soundMediaController == null) {
            throw null;
        }
        new Thread(new Runnable(soundMediaController){
            private final /* synthetic */ SoundMediaController this$0;

            public void run() {
                SoundMediaController.access$0(this.this$0).realize();
            }
            {
                this.this$0 = soundMediaController;
                this.constructor$0(soundMediaController);
            }

            private final void constructor$0(SoundMediaController soundMediaController) {
            }
        }).start();
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof RealizeCompleteEvent) {
            Media.debug.println(Media.debugID, "TestMediaAudio/RealizeComplete");
            this.mediaReady(true);
            return;
        }
        if (controllerEvent instanceof PrefetchCompleteEvent) {
            Media.debug.println(Media.debugID, "TestMediaAudio/PrefetchComplete");
            return;
        }
        if (controllerEvent instanceof EndOfMediaEvent || controllerEvent instanceof StopByRequestEvent) {
            this.volume.setEnabled(false);
            Media.debug.println(Media.debugID, "TestMediaAudio/end of media");
            this.playButton.setEnabled(false);
            this.controlButton.doClick();
            this.mediaCompleted(true);
            this.player.setMediaTime(new Time(0L));
            return;
        }
        if (controllerEvent instanceof ControllerErrorEvent) {
            return;
        }
        if (controllerEvent instanceof ControllerClosedEvent) {
            Media.debug.println(Media.debugID, "controller closed");
            return;
        }
        if (controllerEvent instanceof ControllerErrorEvent) {
            Media.debug.println(Media.debugID, "controllerErrorEvent");
            return;
        }
        if (controllerEvent instanceof DeallocateEvent) {
            Media.debug.println(Media.debugID, "DeallocateEvent");
            System.gc();
            return;
        }
        if (controllerEvent instanceof DurationUpdateEvent) {
            Media.debug.println(Media.debugID, "DurationUpdateEvent");
            return;
        }
        if (controllerEvent instanceof TransitionEvent) {
            Media.debug.println(Media.debugID, "TransitionEvent");
            return;
        }
        if (controllerEvent instanceof MediaTimeSetEvent) {
            Media.debug.println(Media.debugID, "MediaTimeSetEvent");
            return;
        }
        System.err.println("TestMediaAudio/Untrapped in controller update " + controllerEvent);
    }

    private void playMedia() {
        System.gc();
        this.mediaCompleted(false);
        this.player.start();
        this.volume.setEnabled(true);
        this.volume.setValue(Math.round(Session.getVolumeLevel() * 100.0f));
        this.player.getGainControl().setLevel(Session.getVolumeLevel());
        SoundMediaController soundMediaController = this;
        if (soundMediaController == null) {
            throw null;
        }
        this.volume.addChangeListener(new ChangeListener(soundMediaController){
            private final /* synthetic */ SoundMediaController this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                float f = SoundMediaController.access$2(this.this$0).getValue();
                float f2 = 100.0f;
                Session.setVolumeLevel(f / f2);
                SoundMediaController.access$0(this.this$0).getGainControl().setLevel(Session.getVolumeLevel());
            }
            {
                this.this$0 = soundMediaController;
                this.constructor$0(soundMediaController);
            }

            private final void constructor$0(SoundMediaController soundMediaController) {
            }
        });
        this.mediaStarted(true);
    }

    public void stop() {
        Media.debug.println(Media.debugID, "TestMediaAudio/stopMedia stopped:" + this.stopped);
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.volume.setEnabled(false);
        this.player.stop();
        this.player.deallocate();
        this.player.close();
    }

    public void reset() {
        Media.debug.println(Media.debugID, "reset - state: " + this.player.getState());
        if (600 == this.player.getState()) {
            Media.debug.println(Media.debugID, "player is started - stopping");
            this.player.stop();
        }
    }

    public void setEnabled(boolean bl) {
        Media.debug.println(Media.debugID, "setEnabled state: " + bl);
        if (true == bl == this.playButton.isEnabled()) {
            Media.debug.println(Media.debugID, "ignored - already enabled");
            return;
        }
        this.playButton.setEnabled(bl);
        this.controlButton.doClick();
    }

    private void initIcons(MediaProvider mediaProvider) {
        if (spkNotPressed == null || spkPressed == null || spkDisabled == null || spkFocus == null) {
            spkNotPressed = mediaProvider.getCachedImageIcon("speaker.gif");
            spkPressed = mediaProvider.getCachedImageIcon("spkpressed.gif");
            spkDisabled = mediaProvider.getCachedImageIcon("spkdisabled.gif");
            spkFocus = mediaProvider.getCachedImageIcon("spkfocus.gif");
        }
        this.playButton.setRolloverIcon(spkFocus);
        this.playButton.setDisabledIcon(spkDisabled);
        this.playButton.setIcon(spkNotPressed);
        this.playButton.setSelectedIcon(spkPressed);
    }

    static /* synthetic */ Player access$0(SoundMediaController soundMediaController) {
        return soundMediaController.player;
    }

    static /* synthetic */ void access$1(SoundMediaController soundMediaController) {
        soundMediaController.playMedia();
    }

    static /* synthetic */ WSlider access$2(SoundMediaController soundMediaController) {
        return soundMediaController.volume;
    }

    public SoundMediaController() {
        this.getWidget().setName("soundmedia");
        this.setBorder(new BevelBorder(1));
        this.stopped = false;
        this.playButton = new WToggleButton();
        this.playButton.getWidget().setName("play");
        this.playButton.setAlignmentX(0.0f);
        this.playButton.setMargin(new Insets(1, 1, 1, 1));
        this.playButton.setFocusPainted(false);
        this.playButton.setRolloverEnabled(true);
        this.playButton.setContentAreaFilled(false);
        SoundMediaController soundMediaController = this;
        if (soundMediaController == null) {
            throw null;
        }
        this.playButton.addActionListener(new ActionListener(soundMediaController){
            private final /* synthetic */ SoundMediaController this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                if (SoundMediaController.access$0(this.this$0).getState() != 600) {
                    SoundMediaController.access$1(this.this$0);
                }
            }
            {
                this.this$0 = soundMediaController;
                this.constructor$0(soundMediaController);
            }

            private final void constructor$0(SoundMediaController soundMediaController) {
            }
        });
        this.controlButton = new WToggleButton();
        this.group = new ButtonGroup();
        this.group.add(this.controlButton);
        this.group.add(this.playButton);
        this.prompt = new HTMLPane();
        this.prompt.getWidget().setName("prompt");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel.setOpaque(false);
        jPanel.add(this.playButton);
        jPanel.add(Box.createHorizontalStrut(10));
        this.volume = new WSlider(1);
        jPanel.add(this.volume);
        this.volume.getWidget().setName("volume");
        this.volume.setValue(Math.round(Session.getVolumeLevel() * 100.0f));
        this.volume.setEnabled(false);
        this.volume.setAlignmentX(0.0f);
        this.volume.setVisible(true);
        this.volume.setPreferredSize(new Dimension(30, 47));
        this.volume.setSize(30, 47);
        jPanel.add(this.prompt);
        this.add(jPanel);
    }
}

