/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BasketList
extends ArrayList {
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public void addBasket(String string) {
        this.add(string);
    }

    public void dump(File file) throws IOException {
        this.dump(new FileOutputStream(file));
    }

    public void dump(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.write(HEADER);
        bufferedWriter.write("<basket_list size=\"" + Integer.toString(this.size()) + "\">\n");
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            bufferedWriter.write("\t<basket id=\"" + string + "\"/>\n");
        }
        bufferedWriter.write("</basket_list>");
        bufferedWriter.close();
    }

    public BasketList(int n) {
        super(n);
    }

    public BasketList(InputStream inputStream) throws Exception {
        super(32);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        BasketList basketList = this;
        if (basketList == null) {
            throw null;
        }
        sAXParser.parse(inputStream, (DefaultHandler)basketList.new BasketListHandler());
        if (this.size() == 0) {
            throw new Exception("No baskets present in this booklet");
        }
    }

    private class BasketListHandler
    extends DefaultHandler {
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("basket")) {
                String string4 = attributes.getValue("id");
                string4 = Integer.toString(Integer.parseInt(string4));
                BasketList.this.add(string4);
            }
        }

        private BasketListHandler() {
        }
    }
}

