/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.model;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.dialang.client.model.BookletList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BookletList {
    private ArrayList bookletList = null;

    public int getSize() {
        return this.bookletList.size();
    }

    public Iterator iterator() {
        return ((AbstractList)this.bookletList).iterator();
    }

    public BookletList(InputStream inputStream) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        BookletList bookletList = this;
        if (bookletList == null) {
            throw null;
        }
        sAXParser.parse(inputStream, (DefaultHandler)bookletList.new BookletListHandler());
        if (this.bookletList == null) {
            throw new Exception("Failed to parse booklet listing");
        }
        if (this.bookletList.size() == 0) {
            throw new Exception("No booklets present in this list.");
        }
    }

    private class BookletListHandler
    extends DefaultHandler {
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("booklet_list")) {
                int n = Integer.parseInt(attributes.getValue("size"));
                BookletList.this.bookletList = new ArrayList(n);
            } else if (string3.equals("booklet")) {
                String string4 = attributes.getValue("id");
                String string5 = attributes.getValue("skill");
                String string6 = attributes.getValue("language");
                BookletList bookletList = BookletList.this;
                if (bookletList == null) {
                    throw null;
                }
                BookletList.this.bookletList.add(bookletList.new BookletMetaData(null, string4, string5, string6));
            } else {
                throw new SAXException("Invalid element in booklet XML: " + string3);
            }
        }

        private BookletListHandler() {
        }
    }

    public class BookletMetaData {
        private String bookletID;
        private String skill;
        private String language;

        public String getBookletID() {
            return this.bookletID;
        }

        public String getSkill() {
            return this.skill;
        }

        public String getLanguage() {
            return this.language;
        }

        public String toString() {
            return new String("ID: " + this.bookletID + ". Language: " + this.language + ". Skill: " + this.skill);
        }

        private BookletMetaData(String string, String string2, String string3) {
            this.bookletID = string;
            this.skill = string2;
            this.language = string3;
        }

        /* synthetic */ BookletMetaData(2 var2_2, String string, String string2, String string3) {
            this(string, string2, string3);
        }
    }
}

