/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import net.dialang.client.comms.ICommsHandler;
import net.dialang.client.comms.SetUCHeader;
import net.dialang.client.model.ModelControl;
import net.dialang.common.DownloadSite;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.io.Utils;
import net.dialang.mytest.xmltools.XMLUtils;
import net.dialang.xmltools.VersionInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Execution
extends ModelControl {
    private static HashMap punctuationList;
    protected static final int debugID = 256;
    private boolean local = false;
    private String clientID = "Net";
    protected ICommsHandler commsHandler;
    protected Debug debug;
    private String version;
    private String versionDate;
    private File ioErrorFile;
    private File punctuationFile;
    private String serverVersionNumber = null;
    private String serverVersionDate = null;
    private DownloadSite[] downloadSites = null;
    private boolean downloadRequired = false;
    private HashMap downloadInstruction = null;
    private Document ioErrorDoc;
    protected Properties calibratedProps = null;
    private static /* synthetic */ Class class$Lnet$dialang$client$pages$versioninfo$VersionInfoView;

    public void setDebug(Debug debug) {
        this.debug = debug;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public Class compareVersionNumbers(File file) throws Exception {
        this.debug.println(256, "Parsing local version number file ...");
        VersionInfo versionInfo = new VersionInfo(file);
        this.debug.println(256, "Local version number file parsed.");
        this.debug.println(256, "Parsing server version number file ...");
        VersionInfo versionInfo2 = this.getLatestVersionInfo();
        this.debug.println(256, "Server version number file  parsed.");
        String string = versionInfo.getVersionNumber();
        this.setVersion(string);
        this.setVersionDate(versionInfo.getVersionDate());
        this.serverVersionNumber = versionInfo2.getVersionNumber();
        if (string.equals(this.serverVersionNumber)) {
            this.serverVersionNumber = null;
            return null;
        }
        this.serverVersionDate = versionInfo2.getVersionDate();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer = new StringTokenizer(this.serverVersionNumber, ".");
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        int n6 = Integer.parseInt(stringTokenizer.nextToken());
        if (n4 > n || n4 == n && n5 > n2) {
            this.downloadRequired = true;
            this.downloadInstruction = versionInfo2.getInstruction(true);
        } else if (n4 == n && n5 == n2 && n6 > n3) {
            this.downloadRequired = false;
            this.downloadInstruction = versionInfo2.getInstruction(false);
        } else {
            this.downloadRequired = false;
            this.serverVersionNumber = null;
            return null;
        }
        this.downloadSites = versionInfo2.getDownloadSites();
        if (this.downloadSites.length < 1) {
            this.debug.println(256, "No download sites specified");
        }
        return class$Lnet$dialang$client$pages$versioninfo$VersionInfoView != null ? class$Lnet$dialang$client$pages$versioninfo$VersionInfoView : (class$Lnet$dialang$client$pages$versioninfo$VersionInfoView = Execution.class$("net.dialang.client.pages.versioninfo.VersionInfoView"));
    }

    public String[] getNewVersionLanguages() {
        String[] stringArray = new String[this.downloadInstruction.size()];
        int n = 0;
        Iterator iterator = this.downloadInstruction.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public boolean isDownloadRequired() {
        return this.downloadRequired;
    }

    public String getDownloadInstruction(String string) {
        return (String)this.downloadInstruction.get(string);
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersionDate(String string) {
        this.versionDate = string;
    }

    public String getVersionDate() {
        return this.versionDate;
    }

    private VersionInfo getLatestVersionInfo() throws Exception {
        URL uRL = new URL(this.commsHandler.getServer(), "/dialang/getlatestversiondetails");
        URLConnection uRLConnection = uRL.openConnection();
        SetUCHeader.setRequestProperties((URLConnection)uRLConnection);
        InputStream inputStream = uRLConnection.getInputStream();
        return new VersionInfo(inputStream);
    }

    public DownloadSite[] getDownloadSites() {
        return this.downloadSites;
    }

    public String getLatestVersionNumber() {
        return this.serverVersionNumber;
    }

    public String getLatestVersionDate() {
        return this.serverVersionDate;
    }

    public void setCommsHandler(ICommsHandler iCommsHandler) {
        this.commsHandler = iCommsHandler;
    }

    public ICommsHandler getCommsHandler() {
        return this.commsHandler;
    }

    public synchronized void connect() throws IOException {
        if (this.commsHandler == null) {
            throw new IllegalStateException("The comms handler has not been initialised");
        }
        try {
            this.commsHandler.connect();
        }
        catch (Exception exception) {
            this.debug.println(256, "Failed to connect. Reason: " + exception.getMessage());
        }
        try {
            this.loadCalibratedProperties();
        }
        catch (Exception exception) {
            this.debug.println(256, "Failed to download calibrated properties. Reason: " + exception.getMessage());
        }
        try {
            this.downloadIOErrorFile();
        }
        catch (IOException iOException) {
            this.debug.println(256, "Failed to download io error file. Reason: " + iOException.getMessage());
        }
        try {
            this.downloadPunctuationFile();
        }
        catch (IOException iOException) {
            this.debug.println(256, "Failed to download punctuation file. Reason: " + iOException.getMessage());
        }
        this.setClientID("Net");
    }

    private void loadCalibratedProperties() throws Exception {
        this.debug.println(256, "Loading calibrated properties ...");
        URL uRL = new URL(this.commsHandler.getServer(), "/dialang/getcalibratedinfo");
        URLConnection uRLConnection = uRL.openConnection();
        SetUCHeader.setRequestProperties((URLConnection)uRLConnection);
        this.calibratedProps = new Properties();
        this.calibratedProps.load(uRLConnection.getInputStream());
        this.debug.println(256, "Calibrated properties loaded.");
    }

    public boolean isNetworked() {
        return !this.local;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setClientID(String string) {
        this.clientID = string;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setDefaultIOErrorFile(File file) {
        this.ioErrorFile = file;
    }

    public String[] getIOErrorLanguages() {
        if (this.ioErrorFile == null) {
            this.debug.println(256, "ERROR: The io error file has not been initialised. Returning null.");
            return null;
        }
        if (this.ioErrorDoc == null) {
            this.ioErrorDoc = XMLUtils.parse(this.ioErrorFile, this.debug, 256);
        }
        Element element = this.ioErrorDoc.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("language");
        String[] stringArray = new String[nodeList.getLength()];
        int n = 0;
        while (n < nodeList.getLength()) {
            stringArray[n] = ((Element)nodeList.item(n)).getAttribute("iso_code");
            ++n;
        }
        return stringArray;
    }

    public String getIOErrorText(String string, String string2) {
        if (this.ioErrorDoc == null) {
            this.ioErrorDoc = XMLUtils.parse(this.ioErrorFile, this.debug, 256);
        }
        Element element = this.ioErrorDoc.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("language");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (((Element)nodeList.item(n)).getAttribute("iso_code").equals(string)) {
                NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName(string2);
                return ((Element)nodeList2.item(0)).getFirstChild().getNodeValue();
            }
            ++n;
        }
        return null;
    }

    private void downloadPunctuationFile() throws IOException {
        URL uRL = new URL(this.commsHandler.getServer(), "/dialang/getpunctuationlist");
        URLConnection uRLConnection = uRL.openConnection();
        SetUCHeader.setRequestProperties((URLConnection)uRLConnection);
        InputStream inputStream = uRLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(this.punctuationFile);
        Utils.stream(inputStream, fileOutputStream);
        fileOutputStream.close();
    }

    private void downloadIOErrorFile() throws IOException {
        GZIPInputStream gZIPInputStream;
        URL uRL = new URL(this.commsHandler.getServer(), "/dialang/geterrortexts");
        URLConnection uRLConnection = uRL.openConnection();
        SetUCHeader.setRequestProperties((URLConnection)uRLConnection);
        GZIPInputStream gZIPInputStream2 = gZIPInputStream = new GZIPInputStream(uRLConnection.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(this.ioErrorFile);
        Utils.stream(gZIPInputStream2, fileOutputStream);
        fileOutputStream.close();
    }

    private String removeLeadingZeros(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(0) != '0') {
            return stringBuffer.toString();
        }
        stringBuffer.deleteCharAt(0);
        if (stringBuffer.charAt(0) != '0') {
            return stringBuffer.toString();
        }
        stringBuffer.deleteCharAt(0);
        if (stringBuffer.charAt(0) != '0') {
            return stringBuffer.toString();
        }
        stringBuffer.deleteCharAt(0);
        return stringBuffer.toString();
    }

    public void setDefaultPunctuationFile(File file) {
        this.punctuationFile = file;
        punctuationList = new HashMap(100);
        Document document = XMLUtils.parse(this.punctuationFile, this.debug, 256);
        NodeList nodeList = document.getElementsByTagName("glyph");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            try {
                Element element = (Element)nodeList.item(n2);
                String string = element.getAttribute("unicode");
                punctuationList.put(this.removeLeadingZeros(string), null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n2;
        }
    }

    public static String removePunctuation(String string) {
        if (string == null || string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            Character c = new Character(string.charAt(n));
            String string2 = Integer.toHexString(c.charValue());
            if (!punctuationList.containsKey(string2)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

