/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.model;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.ImageIcon;
import net.dialang.client.model.BasketList;
import net.dialang.client.model.ScoringMethods;
import net.dialang.client.model.Session;
import net.dialang.client.precache.PrecacheListener;
import net.dialang.common.Answer;
import net.dialang.common.Booklet;
import net.dialang.common.ILogger;
import net.dialang.common.Item;
import net.dialang.common.SAGrade;
import net.dialang.common.SkillSet;
import net.dialang.common.TriState;
import net.dialang.datacapture.SAData;
import net.dialang.datacapture.VSPTData;
import net.dialang.entity.ALS;
import net.dialang.entity.ItemTypeModel;
import net.dialang.entity.SA;
import net.dialang.entity.Skill;
import net.dialang.entity.TLS;
import net.dialang.entity.TestLevel;
import net.dialang.entity.VSPT;

public class Pass
extends Session
implements PrecacheListener,
ILogger {
    private VSPT vspt;
    private TLS tls;
    private SA sa;
    private Skill skill;
    private boolean SASubmitted;
    private ItemTypeModel currentITM;
    private Iterator bookletIterator;
    private ArrayList itemResults;
    private boolean itemTestCompleted;
    private boolean feedback;
    private int itemGrade;
    private SAGrade.Record saGrade;
    private Booklet booklet;
    private int bookletLength;
    private boolean reviewMode;
    private ItemTypeModel reviewModelSelection;
    private Item reviewItemSelection;
    private String explanatoryHTML;
    private String previousBasket;
    private boolean showingEmbeddedBasket;
    private Stack uncalibratedBaskets;
    private boolean phase3Listener;
    private HashMap ITMMemoryCache;
    private int beingPrecached;
    private Iterator precacheIterator;
    private static /* synthetic */ Class class$Ljava$lang$String;

    public void newPass() {
        this.vspt = null;
        this.sa = null;
        this.skill = null;
        this.SASubmitted = false;
        this.setCurrentBasket(null);
        this.itemGrade = -1;
        this.bookletIterator = null;
        this.itemResults = new ArrayList();
        this.setItemTestCompleted(false);
        this.saGrade = null;
        this.booklet = null;
        this.explanatoryHTML = null;
        if (this.isPrecaching()) {
            this.phase3Listener = false;
            this.precache.removePrecacheListener(this);
        }
        this.reviewMode = false;
        this.reviewModelSelection = null;
        this.reviewItemSelection = null;
        this.resetITMMemoryCache();
        this.propertyChange(new PropertyChangeEvent(this, "newPass", null, this));
    }

    public void log(String string) {
        this.debug.println(256, string);
    }

    private void checkTLSIsSet() {
        if (this.tls == null) {
            throw new IllegalStateException("TLS not set");
        }
    }

    public void setTLS(TLS tLS) {
        TLS tLS2 = this.tls;
        this.tls = tLS;
        if (tLS2 != tLS) {
            this.vspt = null;
        }
        this.propertyChange(new PropertyChangeEvent(this, "TLS", tLS2, tLS));
    }

    public TLS getTLS() {
        return this.tls;
    }

    public void setItemTestCompleted(boolean bl) {
        this.itemTestCompleted = bl;
    }

    public int getItemGrade() {
        return this.itemGrade;
    }

    public boolean isItemResults() {
        return this.itemResults.size() > 0;
    }

    public void calculateItemGrade() throws IOException {
        if (this.isItemLevelAdaptive()) {
            this.itemGrade = this.catEngine.getCOELevel();
        } else if (this.itemGrade == -1) {
            this.itemGrade = this.produceItemGrade(this.itemResults, this.getTLS(), this.getSkill(), this.getBookletID());
        }
    }

    protected void setSAGrade(SAGrade.Record record) {
        this.saGrade = record;
    }

    public SAGrade.Record getSAGrade() {
        return this.saGrade;
    }

    public boolean isItemTestCompleted() {
        return this.itemTestCompleted;
    }

    public void setInstantFeedback(boolean bl) {
        this.feedback = bl;
    }

    public boolean isInstantFeedback() {
        return this.feedback;
    }

    protected String getItemTestCoEGrade() {
        if (this.itemGrade == -1) {
            throw new IllegalStateException("item grade not set!");
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("ITEM");
        stringBuffer.append("#");
        stringBuffer.append(this.getTLS().getVocabSubKey());
        stringBuffer.append("#");
        stringBuffer.append(this.getSkill().getVocabSubKey());
        stringBuffer.append("#");
        stringBuffer.append(Integer.toString(1));
        return stringBuffer.toString();
    }

    public ImageIcon getTestLevelIcon() throws IOException {
        if (this.itemGrade == -1) {
            throw new IllegalStateException("item grade not set!");
        }
        return this.getImageIcon(TestLevel.get(this.itemGrade).getIconID());
    }

    private Booklet getBooklet() throws IOException {
        return this.getBooklet(this.getBookletID());
    }

    private int getBookletID() throws IOException {
        this.debug.println(256, "Calculating booklet ID ...");
        while (this.isTrue) {
            try {
                if (this.forcedBooklet != null) {
                    return this.forcedBooklet;
                }
                int n = -1;
                try {
                    n = ScoringMethods.calculateBookletID(this.model, this);
                }
                catch (IOException iOException) {
                    this.debug.println(256, "Exception caught whilst calculating booklet ID.");
                    throw iOException;
                }
                this.debug.println(256, "Returning booklet: " + Integer.toString(n));
                return n;
            }
            catch (IOException iOException) {
                this.navigation.IOError(iOException);
            }
        }
        return -1;
    }

    public SkillSet getSkillSet() {
        this.checkTLSIsSet();
        return this.tls.getSkills();
    }

    public void setSkill(Skill skill) {
        Skill skill2 = this.skill;
        this.skill = skill;
        if (skill2 == skill) {
            this.debug.println(256, "setSkill", "no change");
            return;
        }
        this.propertyChange(new PropertyChangeEvent(this, "Skill", skill2, skill));
    }

    public Skill getSkill() {
        return this.skill;
    }

    public boolean isActiveSkill() {
        return this.getSkillSet().isEnabled();
    }

    public void startPhase2Precache() {
        if (!this.isPrecaching()) {
            return;
        }
        if (!this.isItemLevelAdaptive()) {
            return;
        }
        this.debug.println(256, "Starting phase 2 precaching ...");
        BasketList basketList = this.getEmbeddedBasketList();
        this.debug.println(256, "Setting precache job list to list of uncalibrated baskets ...");
        this.precache.setJobList(basketList);
        this.debug.println(256, "Loading uncalibrated basket stack ...");
        if (this.uncalibratedBaskets == null) {
            this.uncalibratedBaskets = new Stack();
        } else {
            this.uncalibratedBaskets.clear();
        }
        Iterator iterator = ((AbstractList)basketList).iterator();
        while (iterator.hasNext()) {
            this.uncalibratedBaskets.push(iterator.next());
        }
    }

    public void startPhase3Precache() {
        if (!this.isPrecaching()) {
            return;
        }
        this.debug.println(256, "Getting phase 3 precache list from CATEngine ...");
        BasketList basketList = this.catEngine.getPrecacheList();
    }

    public boolean hasSA() {
        if (this.skill == null) {
            throw new IllegalStateException("hasSA - skill not set");
        }
        ALS aLS = this.getALS();
        if (aLS == null) {
            throw new IllegalStateException("hasSA - als not set");
        }
        return this.hasSA(aLS, this.skill);
    }

    public SA getSA() throws IOException {
        if (this.sa != null) {
            return this.sa;
        }
        ALS aLS = this.getALS();
        if (!this.hasSA(aLS, this.skill)) {
            throw new IOException("no SA available for state");
        }
        this.sa = this.getSA(aLS, this.skill);
        return this.sa;
    }

    public void packAndSendSAData() throws Exception {
        if (!this.isCapturingData()) {
            return;
        }
        SAData sAData = new SAData(this.getSessionID(), this.sa.size());
        Enumeration enumeration = this.sa.elements();
        while (enumeration.hasMoreElements()) {
            SA.Record record = (SA.Record)enumeration.nextElement();
            String string = record.getState().equals(TriState.TRUE) ? "Yes" : "No";
            sAData.addSAEntry(record.getID(), string);
        }
        this.postVSPTSAData(sAData);
    }

    public void submitSA() throws Exception {
        this.debug.println(256, "SA Submitted");
        this.SASubmitted = true;
        this.packAndSendSAData();
    }

    public boolean isSASubmitted() {
        return this.SASubmitted;
    }

    public boolean hasVSPT() {
        if (this.tls == null) {
            throw new IllegalStateException("tls not set");
        }
        return this.tls.getVSPTSize() != 0;
    }

    public VSPT getVSPT() throws IOException {
        if (!this.hasVSPT()) {
            throw new IOException("No VSPT is available for this TLS!");
        }
        if (this.vspt == null) {
            this.vspt = this.getVSPT(this.tls);
        }
        return this.vspt;
    }

    private void packAndSendVSPTData(VSPT vSPT) throws Exception {
        if (!this.isCapturingData()) {
            return;
        }
        VSPTData vSPTData = new VSPTData(this.getSessionID(), vSPT.size());
        Enumeration enumeration = vSPT.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            VSPT.Record record = (VSPT.Record)enumeration.nextElement();
            int n = 0;
            if (record.getState().equals(TriState.TRUE)) {
                string = "Yes";
                if (record.isValid()) {
                    n = 1;
                }
            } else {
                string = "No";
                if (!record.isValid()) {
                    n = 1;
                }
            }
            vSPTData.addVSPTEntry(record.getID(), string, n);
        }
        this.postVSPTSAData(vSPTData);
    }

    public void submitVSPT() throws Exception {
        super.submitVSPT(this.vspt);
        this.packAndSendVSPTData(this.vspt);
    }

    public boolean isVSPTSubmitted() {
        return super.isVSPTSubmitted(this.tls);
    }

    public void setVSPTAttempted() {
        super.setVSPTAttempted(this.tls);
    }

    public boolean isVSPTAttempted() {
        return super.isVSPTAttempted(this.tls);
    }

    public String getVSPTFeedbackVocabSubKey() {
        return super.getVSPTFeedbackVocabSubKey(this.tls);
    }

    public int getVSPTFeedbackScore() {
        return super.getVSPTFeedbackScore(this.tls);
    }

    public int getVSPTFeedbackScaleSize() {
        this.confirmVSPTLoaded();
        return this.vspt.getFeedbackScaleSize();
    }

    public Enumeration getVSPTFeedbackScale() {
        this.confirmVSPTLoaded();
        return this.vspt.getFeedbackScale();
    }

    private void confirmVSPTLoaded() {
        if (this.vspt == null) {
            throw new RuntimeException("vspt has not been loaded");
        }
    }

    public boolean isAdvisoryFeedback() {
        return super.isAdvisoryFeedback(this.tls, this.skill, null);
    }

    public boolean isAdvisoryFeedback(String string) {
        return super.isAdvisoryFeedback(this.tls, this.skill, string);
    }

    public String getAdvisoryBulletKey(int n) {
        if (n > 6 || n < 1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(96);
        stringBuffer.append("advfb#");
        stringBuffer.append(this.getALS().getVocabSubKey().toLowerCase() + "#");
        stringBuffer.append(this.getTLS().getVocabSubKey().toLowerCase() + "#");
        stringBuffer.append(this.getSkill().getVocabSubKey().toLowerCase() + "#");
        if (n == 1) {
            stringBuffer.append("bullet_a1.html");
        } else if (n == 2) {
            stringBuffer.append("bullet_a2.html");
        } else if (n == 3) {
            stringBuffer.append("bullet_b1.html");
        } else if (n == 4) {
            stringBuffer.append("bullet_b2.html");
        } else if (n == 5) {
            stringBuffer.append("bullet_c1.html");
        } else if (n == 6) {
            stringBuffer.append("bullet_c1.html");
        }
        return stringBuffer.toString();
    }

    public String getAdvisoryGridKey(int n) {
        if (n > 6 || n < 1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(96);
        stringBuffer.append("advfb#");
        stringBuffer.append(this.getALS().getVocabSubKey().toLowerCase() + "#");
        stringBuffer.append(this.getTLS().getVocabSubKey().toLowerCase() + "#");
        stringBuffer.append(this.getSkill().getVocabSubKey().toLowerCase() + "#");
        if (n == 1) {
            stringBuffer.append("grid_a1.html");
        } else if (n == 2) {
            stringBuffer.append("grid_a2.html");
        } else if (n == 3) {
            stringBuffer.append("grid_b1.html");
        } else if (n == 4) {
            stringBuffer.append("grid_b2.html");
        } else if (n == 5) {
            stringBuffer.append("grid_c1.html");
        } else if (n == 6) {
            stringBuffer.append("grid_c1.html");
        }
        return stringBuffer.toString();
    }

    public boolean isExplanatoryFeedback() {
        return super.isExplanatoryFeedback(null);
    }

    public String getExplanatoryFeedbackKey() {
        return super.getExplanatoryFeedbackKey(null);
    }

    public void setExplanatoryHTMLKey(String string) {
        this.explanatoryHTML = string;
    }

    public String getExplanatoryHTMLKey() {
        return this.constructExplanKey(this.explanatoryHTML);
    }

    public String constructExplanKey(String string) {
        StringBuffer stringBuffer = new StringBuffer(10 + string.length());
        stringBuffer.append("explfb#");
        stringBuffer.append(this.getALS().getVocabSubKey());
        stringBuffer.append("#");
        stringBuffer.append(string);
        return stringBuffer.toString().toLowerCase();
    }

    public void resetITMMemoryCache() {
        this.ITMMemoryCache = new HashMap();
    }

    public ItemTypeModel getNextBasket() throws IOException {
        String string;
        if (!this.isItemLevelAdaptive()) {
            if (!this.bookletIterator.hasNext()) {
                this.debug.println(256, "No more baskets in booklet. Returning null");
                return null;
            }
            Integer n = (Integer)this.bookletIterator.next();
            this.setCurrentBasket(this.getBasket(n));
            return this.currentITM;
        }
        this.showingEmbeddedBasket = false;
        this.debug.println(256, "Getting next basket no from the CAT ...");
        this.previousBasket = string = this.catEngine.getBestBasket();
        this.debug.println(256, "CAT gave basket no: " + string);
        String string2 = null;
        if (this.uncalibratedBaskets != null) {
            try {
                this.debug.println(256, "Peeking at next basket on uncalibrated stackChecking stack for an uncalibrated item ...");
                string2 = (String)this.uncalibratedBaskets.peek();
                this.debug.println(256, "Next basket on uncalibrated stack is " + string2);
            }
            catch (EmptyStackException emptyStackException) {
                this.debug.println(256, "No more uncalibrated baskets on stack.");
            }
        } else {
            this.debug.println(256, "WARNING: We are running in adaptive mode and the uncalibrated basket stack has not been initialised.");
        }
        Integer n = null;
        if (string != null) {
            n = new Integer(string);
        }
        if (string == null && string2 == null) {
            this.debug.println(256, "There are neither calibrated nor uncalibrated baskets available. Returning null ...");
            return null;
        }
        if (string != null && string2 == null) {
            this.debug.println(256, "Getting the calibrated basket ...");
            this.currentITM = this.getBasket(n);
            this.showingEmbeddedBasket = false;
            return this.currentITM;
        }
        if (string == null && string2 != null) {
            this.debug.println(256, "Getting the uncalibrated basket ...");
            string2 = (String)this.uncalibratedBaskets.pop();
            this.currentITM = this.getBasket(new Integer(string2));
            this.showingEmbeddedBasket = true;
            return this.currentITM;
        }
        if (string != null && string2 != null) {
            if (this.hasBeenPrecached(string)) {
                this.debug.println(256, "Getting the calibrated basket from disk ...");
                this.currentITM = this.getBasket(2, n);
                this.showingEmbeddedBasket = false;
                return this.currentITM;
            }
            if (this.hasBeenPrecached(string2)) {
                this.debug.println(256, "Getting the uncalibrated basket from disk ...");
                string2 = (String)this.uncalibratedBaskets.pop();
                this.currentITM = this.getBasket(2, new Integer(string2));
                this.showingEmbeddedBasket = true;
                return this.currentITM;
            }
            this.debug.println(256, "Neither the calibrated nor uncalibrated baskets have been precached. Getting the calibrated basket ...");
            this.currentITM = this.getBasket(n);
            this.showingEmbeddedBasket = false;
            return this.currentITM;
        }
        this.debug.println(256, "Error in method logic. Returning null.");
        return null;
    }

    public boolean hasNextITM() {
        if (this.bookletIterator != null) {
            return this.bookletIterator.hasNext();
        }
        return true;
    }

    public ItemTypeModel getCurrentITM() {
        return this.currentITM;
    }

    protected void setCurrentBasket(ItemTypeModel itemTypeModel) {
        this.currentITM = itemTypeModel;
    }

    public void initItemTest() throws IOException {
        if (this.isItemLevelAdaptive()) {
            return;
        }
        this.debug.println(256, "Starting booklet-level adaptive test ...");
        this.currentITM = null;
        this.booklet = this.getBooklet();
        this.bookletIterator = ((AbstractList)this.booklet).iterator();
        this.bookletLength = this.booklet.size();
        this.setPrecacheJobList(this.booklet);
    }

    private void setPrecacheJobList(Booklet booklet) {
        if (!this.isPrecaching()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(booklet.size());
        Iterator iterator = ((AbstractList)booklet).iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        this.precache.setJobList(arrayList);
    }

    private void sendAllItemResults(ItemTypeModel itemTypeModel) {
        if (!this.isCapturingData()) {
            return;
        }
        this.debug.println(256, "Uploading item response data ...");
        int n = 0;
        Iterator iterator = itemTypeModel.items();
        while (iterator.hasNext()) {
            String string;
            ++n;
            Item item = (Item)iterator.next();
            int n2 = 0;
            if (item.getCorrect().booleanValue()) {
                n2 = 1;
            }
            if (item.getResponse().getClass().equals(class$Ljava$lang$String != null ? class$Ljava$lang$String : Pass.class$("java.lang.String"))) {
                string = (String)item.getResponse();
            } else {
                int n3 = (Integer)item.getResponse();
                Answer answer = item.getAnswer(n3);
                string = answer.getText();
            }
            this.debug.println(256, "Sending item data ...");
            this.postItemData(new Integer(item.getID()).toString(), string, n2, n + itemTypeModel.getPresentationID());
            this.debug.println(256, "Item response data sent.");
        }
    }

    public void basketPrecached(String string) {
        if (!this.isPrecaching()) {
            throw new IllegalStateException("basketPrecached called in a non-precaching environment.");
        }
    }

    public void basketExposed(ItemTypeModel itemTypeModel) {
        itemTypeModel.score();
        this.itemResults.add(itemTypeModel);
        this.sendAllItemResults(itemTypeModel);
        if (this.isItemLevelAdaptive()) {
            Object object;
            if (!this.showingEmbeddedBasket) {
                object = itemTypeModel.items();
                while (object.hasNext()) {
                    try {
                        this.catEngine.itemExposed((Item)object.next(), Integer.toString(itemTypeModel.getID()));
                    }
                    catch (Exception exception) {
                        this.debug.println(256, "The cat threw an exception in itemExposed(): " + exception);
                    }
                }
            }
            if (this.isPrecaching()) {
                this.debug.println(256, "Getting phase III precache list from CATEngine ...");
                object = this.catEngine.getPrecacheList();
                this.debug.println(256, "Amount of phase III baskets: " + ((ArrayList)object).size());
                this.debug.println(256, "Finished getting Phase III precache list");
                this.precache.setJobList((ArrayList)object);
                if (!this.phase3Listener) {
                    this.phase3Listener = true;
                    this.precache.addPrecacheListener(this);
                }
            }
        }
    }

    public Iterator getItemResults() {
        return ((AbstractList)this.itemResults).iterator();
    }

    public void setReviewMode(boolean bl) {
        this.reviewMode = bl;
        this.debug.println(256, "reviewMode " + bl);
        if (!this.reviewMode) {
            this.reviewModelSelection = null;
            this.reviewItemSelection = null;
        }
    }

    public boolean isReviewMode() {
        return this.reviewMode;
    }

    public void setReviewSelection(ItemTypeModel itemTypeModel, Item item) {
        this.reviewModelSelection = itemTypeModel;
        this.reviewItemSelection = item;
        this.setCurrentBasket(itemTypeModel);
    }

    public ItemTypeModel getReviewModelSelection() {
        return this.reviewModelSelection;
    }

    public Item getReviewItemSelection() {
        return this.reviewItemSelection;
    }

    public int getBookletLength() {
        return this.bookletLength;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

