/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.model;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import net.dialang.client.model.Model;
import net.dialang.client.model.VSPTLog;
import net.dialang.common.Grade;
import net.dialang.common.ILogger;
import net.dialang.common.ItemGrade;
import net.dialang.common.PreestAssign;
import net.dialang.common.PreestWeights;
import net.dialang.common.SAGrade;
import net.dialang.common.SAWeights;
import net.dialang.common.VSPTGrade;
import net.dialang.entity.ItemTypeModel;
import net.dialang.entity.SA;
import net.dialang.entity.Skill;
import net.dialang.entity.TLS;

public class ScoringMethods {
    public static int calculateBookletID(Model model, ILogger iLogger) throws IOException {
        TLS tLS = model.getTLS();
        Skill skill = model.getSkill();
        boolean bl = model.isVSPTSubmitted();
        boolean bl2 = model.isSASubmitted();
        PreestAssign preestAssign = model.getPreestAssign();
        if (!bl && !bl2) {
            int n = preestAssign.get(tLS, skill);
            return n;
        }
        float f = 0.0f;
        if (bl2) {
            SAGrade.Record record = ScoringMethods.produceSaGrade(model);
            iLogger.log("SA grade: " + record);
            model.setSAGrade(record);
            f = record.getPPE();
        }
        float f2 = 0.0f;
        if (bl) {
            f2 = model.getVSPT().getZScore();
        }
        PreestWeights preestWeights = model.getPreestWeights();
        PreestWeights.Record record = preestWeights.get(tLS, skill, bl, bl2);
        float f3 = record.getSA();
        float f4 = record.getVSPT();
        float f5 = record.getCOE();
        float f6 = f * record.getSA() + f2 * record.getVSPT() + record.getCOE();
        return preestAssign.get(tLS, skill, f6);
    }

    private static SAGrade.Record produceSaGrade(Model model) throws IOException {
        SA sA = model.getSA();
        TLS tLS = model.getTLS();
        Skill skill = model.getSkill();
        SAWeights sAWeights = model.getSAWeights(tLS, skill);
        int n = sA.getRawScore(sAWeights);
        int n2 = sA.getWeight(sAWeights);
        SAGrade sAGrade = model.getSAGrade(tLS, skill);
        int n3 = sAGrade.getMax();
        n = (int)((float)n * ((float)n3 / (float)n2));
        SAGrade.Record record = sAGrade.get(n);
        return record;
    }

    private static VSPTGrade.Record getVsptGrade(Model model, ILogger iLogger) throws IOException {
        TLS tLS = model.getTLS();
        VSPTLog vSPTLog = model.getVsptLog(tLS);
        if (vSPTLog == null) {
            throw new IllegalStateException("no vspt log entry!");
        }
        VSPTGrade.Record record = vSPTLog.getGrade();
        if (record != null) {
            iLogger.log("vspt grade cache hit");
            return record;
        }
        int n = vSPTLog.getRawScore();
        int n2 = vSPTLog.getWeight();
        VSPTGrade vSPTGrade = model.getVSPTGrade(tLS);
        int n3 = vSPTGrade.getMax();
        n = (int)((float)n * ((float)n3 / (float)n2));
        record = vSPTGrade.get(n);
        vSPTLog.setGrade(record);
        return record;
    }

    public static ItemGrade.Record produceItemGrade(Model model, ArrayList arrayList, ILogger iLogger) throws IOException {
        TLS tLS = model.getTLS();
        Skill skill = model.getSkill();
        int n = ScoringMethods.calculateBookletID(model, iLogger);
        int n2 = 0;
        int n3 = 0;
        Object object = ((AbstractList)arrayList).iterator();
        while (object.hasNext()) {
            ItemTypeModel itemTypeModel = (ItemTypeModel)object.next();
            n3 += itemTypeModel.getWeight();
            n2 += itemTypeModel.getRawScore();
        }
        object = model.getItemGrade(tLS, skill, n);
        int n4 = ((Grade)object).getMax();
        n2 = (int)((float)n2 * ((float)n4 / (float)n3));
        ItemGrade.Record record = ((ItemGrade)object).get(n2);
        return record;
    }

    public static int getConfidenceComparison(Model model) {
        int n;
        SAGrade.Record record = model.getSAGrade();
        if (record == null) {
            return 0;
        }
        ItemGrade.Record record2 = model.getItemGradeRecord();
        if (record2 == null) {
            throw new IllegalStateException("no item grade available");
        }
        int n2 = record.getGrade();
        if (n2 > (n = record2.getGrade())) {
            return 1;
        }
        if (n > n2) {
            return -1;
        }
        return 0;
    }
}

