/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.model;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import net.dialang.client.Status;
import net.dialang.client.comms.SetUCHeader;
import net.dialang.client.model.BookletList;
import net.dialang.client.model.Services;
import net.dialang.client.model.VSPTLog;
import net.dialang.common.AdvFbMap;
import net.dialang.common.ExplFbMap;
import net.dialang.common.SAMap;
import net.dialang.datacapture.SessionDataParser;
import net.dialang.entity.ALS;
import net.dialang.entity.Skill;
import net.dialang.entity.TLS;
import net.dialang.entity.VSPT;
import net.dialang.mytest.jam.StatusValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Session
extends Services {
    private static float vol = 0.5f;
    private ALS als;
    private SAMap saMap;
    private AdvFbMap advFbMap;
    private ExplFbMap explFbMap;
    private TLS[] tlsOptions;
    private boolean firstSession;
    private String login;
    private String password;
    private BookletList bookletList;
    private String sessionID;
    private boolean pilotingAllowed;
    private boolean pilotingMode;
    private Hashtable vsptLog;
    private int VSPTMaxSize;

    private final void newSession() {
        this.als = null;
        this.saMap = null;
        this.advFbMap = null;
        this.explFbMap = null;
        this.vsptLog = new Hashtable();
        this.tlsOptions = null;
        this.model.newPass();
        this.propertyChange(new PropertyChangeEvent(this, "newSession", null, this));
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void togglePilotingMode() {
        this.pilotingMode = 1 - this.pilotingMode;
        this.debug.println(256, "Piloting mode set to " + new Boolean(this.pilotingMode).toString());
    }

    public void setPilotingMode(boolean bl) {
        this.pilotingMode = this.pilotingAllowed && bl;
    }

    public void setPilotingAllowed(boolean bl) {
        this.pilotingAllowed = bl;
    }

    public boolean getPilotingMode() {
        return this.pilotingMode;
    }

    public void storeSessionID() throws Exception {
        boolean bl = true;
        while (bl) {
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                String string2 = this.commsHandler.getServer() + "/dialang/getnewsessionid?address=" + string + "&als=" + this.model.getALS().getVocabSubKey() + "&tls=" + this.model.getTLS().getVocabSubKey() + "&skill=" + this.model.getSkill().getVocabSubKey();
                if (this.pilotingMode) {
                    string2 = string2 + "&piloting=true";
                }
                URL uRL = new URL(string2);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                SetUCHeader.setRequestProperties((URLConnection)uRLConnection);
                InputStream inputStream = uRLConnection.getInputStream();
                SessionDataParser sessionDataParser = new SessionDataParser(inputStream);
                inputStream.close();
                this.sessionID = sessionDataParser.getSessionID();
                return;
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    this.navigation.IOError((IOException)exception);
                    continue;
                }
                throw exception;
            }
        }
    }

    public void setALS(ALS aLS) throws IOException {
        ALS aLS2 = this.als;
        this.newSession();
        this.als = aLS;
        if (aLS2 != aLS) {
            if (aLS2 != null) {
                aLS2.setVocab(null);
            }
            this.debug.println(256, "setALS", "loading vocab...");
            aLS.setVocab(this.getVocab(aLS));
        }
        if (this.saMap == null) {
            this.debug.println(256, "setALS", "loading SAMap...");
            this.saMap = this.getSAMap();
        }
        if (this.advFbMap == null) {
            this.debug.println(256, "setALS", "loading AdvFbMap...");
            this.advFbMap = this.getAdvFbMap();
        }
        if (this.explFbMap == null) {
            this.debug.println(256, "setALS", "loading ExplFbMap...");
            this.explFbMap = this.getExplFbMap();
        }
        this.propertyChange(new PropertyChangeEvent(this, "ALS", aLS2, aLS));
    }

    public ALS getALS() {
        return this.als;
    }

    protected void checkVocabIsSet() {
        if (this.als == null) {
            throw new IllegalStateException("ALS not set");
        }
        if (this.als.getVocab() == null) {
            throw new IllegalStateException("Vocab not set");
        }
    }

    public TLS[] getTLSOptions() throws IOException {
        this.tlsOptions = super.getTLSOptions();
        int n = 0;
        int n2 = 0;
        while (n2 < this.tlsOptions.length) {
            n = Math.max(n, this.tlsOptions[n2].getVSPTSize());
            ++n2;
        }
        this.setVSPTMaxSize(n);
        return this.tlsOptions;
    }

    public int getActiveTLSCount() {
        int n = 0;
        if (this.tlsOptions == null) {
            throw new IllegalStateException("tlsOptions not set");
        }
        int n2 = 0;
        while (n2 < this.tlsOptions.length) {
            if (this.tlsOptions[n2].isEnabled()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public StatusValue getVSPTFeedback() {
        return Status.INF_COELEVA1;
    }

    protected final VSPTLog getVsptLog(TLS tLS) {
        return this.getVsptLog(tLS.getVocabSubKey());
    }

    protected final VSPTLog getVsptLog(String string) {
        return (VSPTLog)this.vsptLog.get(string);
    }

    protected void setVSPTAttempted(TLS tLS) {
        String string = tLS.getVocabSubKey();
        VSPTLog vSPTLog = this.getVsptLog(string);
        if (vSPTLog == null) {
            vSPTLog = new VSPTLog();
            this.vsptLog.put(string, vSPTLog);
        }
        vSPTLog.setAttempted(true);
    }

    protected boolean isVSPTAttempted(TLS tLS) {
        VSPTLog vSPTLog = this.getVsptLog(tLS);
        if (vSPTLog == null) {
            return false;
        }
        return vSPTLog.isAttempted();
    }

    protected void submitVSPT(VSPT vSPT) {
        String string = vSPT.getVocabSubKey();
        this.debug.println(256, "submitVSPT for", string);
        VSPTLog vSPTLog = this.getVsptLog(string);
        if (vSPTLog == null) {
            vSPTLog = new VSPTLog();
            this.vsptLog.put(string, vSPTLog);
        }
        if (!vSPTLog.isAttempted()) {
            this.debug.println(256, "WARNING: submitVSPT forcing isAttempted");
            vSPTLog.setAttempted(true);
        }
        vSPTLog.setSubmitted(true);
        vSPTLog.setFBScore(vSPT.getFeedbackScore());
        vSPTLog.setFBVSK(vSPT.getFeedbackVocabSubKey());
        vSPTLog.setRawScore(vSPT.getRawScore());
        vSPTLog.setWeight(vSPT.getWeight());
        vSPTLog.setSize(vSPT.size());
    }

    protected int getVSPTSize(TLS tLS) {
        VSPTLog vSPTLog = this.getVsptLog(tLS);
        if (vSPTLog == null) {
            return 0;
        }
        return vSPTLog.getSize();
    }

    protected int getVSPTRawScore(TLS tLS) {
        VSPTLog vSPTLog = this.getVsptLog(tLS);
        if (vSPTLog == null) {
            return 0;
        }
        return vSPTLog.getRawScore();
    }

    protected boolean isVSPTSubmitted(TLS tLS) {
        VSPTLog vSPTLog = this.getVsptLog(tLS);
        if (vSPTLog == null) {
            return false;
        }
        return vSPTLog.isSubmitted();
    }

    protected int getVSPTFeedbackScore(TLS tLS) {
        VSPTLog vSPTLog = this.getVsptLog(tLS);
        if (vSPTLog == null) {
            return -1;
        }
        if (!vSPTLog.isSubmitted()) {
            return -1;
        }
        return vSPTLog.getFBScore();
    }

    protected String getVSPTFeedbackVocabSubKey(TLS tLS) {
        VSPTLog vSPTLog = this.getVsptLog(tLS);
        if (vSPTLog == null) {
            return null;
        }
        if (!vSPTLog.isSubmitted()) {
            return null;
        }
        return vSPTLog.getFBVSK();
    }

    public boolean hasSA(ALS aLS, Skill skill) {
        if (this.saMap == null) {
            throw new IllegalStateException("saMap not set");
        }
        return this.saMap.isSA(aLS, skill);
    }

    public int getSAMaxSize() {
        if (this.saMap == null) {
            throw new IllegalStateException("saMap not set");
        }
        return this.saMap.getMaxSize();
    }

    public int getVSPTMaxSize() {
        return this.VSPTMaxSize;
    }

    private final void setVSPTMaxSize(int n) {
        this.VSPTMaxSize = n;
    }

    protected boolean isAdvisoryFeedback(TLS tLS, Skill skill, String string) {
        if (this.advFbMap == null) {
            throw new IllegalStateException("advFbmap not set");
        }
        return this.advFbMap.isAdvFb(this.als, tLS, skill, string);
    }

    protected String getAdvisoryFeedbackKey(TLS tLS, Skill skill, String string) {
        if (this.advFbMap == null) {
            throw new IllegalStateException("advFbmap not set");
        }
        String string2 = this.advFbMap.key(this.als, tLS, skill, string);
        if (!this.advFbMap.isAdvFb(string2)) {
            return null;
        }
        return string2;
    }

    public URL getAdvisoryFeedbackForKey(String string) throws IOException {
        return this.getHTML(string);
    }

    public boolean isExplanatoryFeedback(String string) {
        if (this.explFbMap == null) {
            throw new IllegalStateException("explFbmap not set");
        }
        return this.explFbMap.isExplFb(this.als, string);
    }

    public String getExplanatoryFeedbackKey(String string) {
        if (this.explFbMap == null) {
            throw new IllegalStateException("explFbmap not set");
        }
        String string2 = this.explFbMap.key(this.als, string);
        if (!this.explFbMap.isExplFb(string2)) {
            return null;
        }
        return string2;
    }

    public URL getExplanatoryFeedbackForKey(String string) throws IOException {
        return this.getHTML(string);
    }

    public static void setVolumeLevel(float f) {
        vol = f;
    }

    public static float getVolumeLevel() {
        return vol;
    }

    public void setFirewallLogin(String string) {
        this.login = string;
    }

    public String getFirewallLogin() {
        return this.login;
    }

    public void setFirewallPassword(String string) {
        this.password = string;
    }

    public String getFirewallPassword() {
        return this.password;
    }

    private final /* synthetic */ void this() {
        this.firstSession = true;
        this.VSPTMaxSize = 0;
    }

    public Session() {
        this.this();
    }
}

