/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.pages.itemreviewmenu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.dialang.client.Dialang;
import net.dialang.client.Status;
import net.dialang.client.model.Model;
import net.dialang.client.pages.itemreviewmenu.ColumnLayout;
import net.dialang.client.pages.itemreviewmenu.ColumnTitles;
import net.dialang.client.pages.itemreviewmenu.MenuOption;
import net.dialang.client.pages.itemreviewmenu.SubSkillOption;
import net.dialang.client.views.ApplicationView;
import net.dialang.client.wlib.WLabel;
import net.dialang.client.wlib.WPanel;
import net.dialang.client.wlib.WTextPane;
import net.dialang.common.Item;
import net.dialang.entity.ItemTypeModel;
import net.dialang.mytest.jam.Display;
import net.dialang.mytest.jam.FatalErrorException;
import net.dialang.mytest.jam.Jam;
import net.dialang.mytest.jam.JamException;
import net.dialang.mytest.jam.ViewController;
import net.dialang.vocab.VocabStatus;

public class ItemReviewMenuViewController
extends Dialang
implements ViewController {
    private WPanel mainAreaPanel;
    protected WLabel title;
    private ApplicationView display;
    private ActionListener actionListener;
    private MouseListener mouseListener;
    protected HashMap options;
    protected WPanel optionsPane;
    protected WTextPane blurb;
    private static /* synthetic */ Class class$Lnet$dialang$client$views$ApplicationView;

    private String processSubskillKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("LISTENING")) {
            string2 = "Listening";
        } else if (string2.equalsIgnoreCase("READING")) {
            string2 = "Reading";
        } else if (string2.equalsIgnoreCase("WRITING")) {
            string2 = "Writing";
        } else if (string2.equalsIgnoreCase("STRUCTURES")) {
            string2 = "Structures";
        } else if (string2.equalsIgnoreCase("VOCABULARY")) {
            string2 = "Vocabulary";
        }
        return string2 + "." + string3;
    }

    protected void build() throws JamException {
        Serializable serializable;
        Object object;
        this.title = new WLabel();
        this.title.getWidget().setName("title");
        this.blurb = new WTextPane();
        this.blurb.getWidget().setName("blurb");
        this.actionListener = this.createActionListener();
        this.mouseListener = this.createMouseListener();
        this.options = new HashMap();
        this.optionsPane = new WPanel();
        this.optionsPane.getWidget().setName("options");
        this.optionsPane.setLayout(new BoxLayout(this.optionsPane, 1));
        this.optionsPane.setBorder(new LineBorder(Color.black));
        int n = this.getButtonSize();
        int n2 = this.getButtonCount();
        int n3 = this.getDescWidth();
        Dialang.debug.println(1024, " size " + n, " count " + n2, " desc " + n3);
        ColumnLayout.setButtonSize(n);
        ColumnLayout.setButtonCount(n2);
        ColumnLayout.setDescWidth(n3);
        try {
            WLabel wLabel = new WLabel(Dialang.model.getImageIcon("smiley.gif"));
            wLabel.getWidget().setName("icon");
            object = new WLabel(Dialang.model.getImageIcon("frowney.gif"));
            ((WLabel)object).getWidget().setName("icon");
            serializable = new ColumnTitles(wLabel, (WLabel)object);
            this.optionsPane.add((Component)serializable);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Dialang.debug.println("ItemReviewMenu: Error getting SKILEYFACE/FROWNYFACE image");
            this.completed(new FatalErrorException(this, "Getting smiley/frowny image", iOException, null));
        }
        int n4 = 1;
        object = Dialang.model.getItemResults();
        while (object.hasNext()) {
            Serializable serializable2;
            serializable = (ItemTypeModel)object.next();
            ArrayList<MenuOption> arrayList = new ArrayList<MenuOption>(((ItemTypeModel)serializable).size());
            Iterator iterator = ((ItemTypeModel)serializable).items();
            while (iterator.hasNext()) {
                serializable2 = (Item)iterator.next();
                if (((Item)serializable2).getCorrect() == null) {
                    System.err.println("ignoring " + n4);
                } else {
                    MenuOption menuOption = new MenuOption((ItemTypeModel)serializable, (Item)serializable2, n4, n);
                    menuOption.addActionListener(this.actionListener);
                    menuOption.addMouseListener(this.mouseListener);
                    arrayList.add(menuOption);
                    String string = ((Item)serializable2).getSubSkill().getVocabSubKey();
                    string = this.processSubskillKey(string);
                    SubSkillOption subSkillOption = (SubSkillOption)this.options.get(string);
                    if (subSkillOption == null) {
                        subSkillOption = new SubSkillOption();
                        subSkillOption.setDescription(Dialang.model.getVocab(VocabStatus.Subskill, string));
                        this.options.put(string, subSkillOption);
                        this.optionsPane.add(new JSeparator(0));
                        this.optionsPane.add(subSkillOption);
                    }
                    subSkillOption.addMenuOption(menuOption, ((Item)serializable2).getCorrect());
                }
                ++n4;
            }
            iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                serializable2 = (MenuOption)iterator.next();
                ((MenuOption)serializable2).setSiblings(arrayList);
            }
        }
        this.display = (ApplicationView)Jam.getDisplay(class$Lnet$dialang$client$views$ApplicationView != null ? class$Lnet$dialang$client$views$ApplicationView : (class$Lnet$dialang$client$views$ApplicationView = ItemReviewMenuViewController.class$("net.dialang.client.views.ApplicationView")));
    }

    private ActionListener createActionListener() {
        ItemReviewMenuViewController itemReviewMenuViewController = this;
        if (itemReviewMenuViewController == null) {
            throw null;
        }
        return new ActionListener(itemReviewMenuViewController){
            private final /* synthetic */ ItemReviewMenuViewController this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                MenuOption menuOption = (MenuOption)actionEvent.getSource();
                ItemReviewMenuViewController.access$0().setReviewMode(true);
                ItemReviewMenuViewController.access$0().setReviewSelection(menuOption.getITM(), menuOption.getItem());
                this.this$0.completed(Status.REVIEW_SELECTED);
            }
            {
                this.this$0 = itemReviewMenuViewController;
                this.constructor$0(itemReviewMenuViewController);
            }

            private final void constructor$0(ItemReviewMenuViewController itemReviewMenuViewController) {
            }
        };
    }

    private MouseListener createMouseListener() {
        ItemReviewMenuViewController itemReviewMenuViewController = this;
        if (itemReviewMenuViewController == null) {
            throw null;
        }
        return new MouseAdapter(itemReviewMenuViewController){
            private final /* synthetic */ ItemReviewMenuViewController this$0;

            public void mousePressed(MouseEvent mouseEvent) {
                MenuOption menuOption = (MenuOption)mouseEvent.getSource();
                Iterator iterator = menuOption.siblings();
                while (iterator.hasNext()) {
                    MenuOption menuOption2 = (MenuOption)iterator.next();
                    menuOption2.setForeground(Color.white);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                MenuOption menuOption = (MenuOption)mouseEvent.getSource();
                Iterator iterator = menuOption.siblings();
                while (iterator.hasNext()) {
                    MenuOption menuOption2 = (MenuOption)iterator.next();
                    menuOption2.setForeground(Color.black);
                }
            }
            {
                this.this$0 = itemReviewMenuViewController;
                this.constructor$0(itemReviewMenuViewController);
            }

            private final void constructor$0(ItemReviewMenuViewController itemReviewMenuViewController) {
            }
        };
    }

    public JButton getDefaultButton() {
        return null;
    }

    public void registerView(Component component) {
        this.mainAreaPanel = (WPanel)component;
        this.mainAreaPanel.setOpaque(false);
        this.mainAreaPanel.getWidget().setName("itemreviewmenu");
        this.mainAreaPanel.getWidget().setRoot();
    }

    public void refresh() {
    }

    public boolean isBuilt() {
        return this.mainAreaPanel != null;
    }

    public void setDisplay(Display display) {
        this.display = (ApplicationView)display;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void mapView() {
        this.title.setText(Dialang.model.getVocab(VocabStatus.Title_ItemReview));
        try {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, 1);
            this.blurb.getDocument().remove(0, this.blurb.getDocument().getLength());
            this.blurb.getDocument().insertString(0, Dialang.model.getVocab(VocabStatus.ItemReview_Text), simpleAttributeSet);
            this.blurb.setParagraphAttributes(simpleAttributeSet, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Dialang.debug.println("ItemReviewMenu: Error changing text(1)");
            this.completed(new FatalErrorException(this, "chaning text", exception, null));
        }
        Dialang.model.setReviewMode(false);
        this.display.getMainArea().getBackdrop().add(this.mainAreaPanel);
    }

    public void unmapView() {
        this.display.getMainArea().getBackdrop().remove(this.mainAreaPanel);
        if (!Dialang.model.isReviewMode()) {
            this.dispose();
        }
    }

    public void dispose() {
        this.mainAreaPanel = null;
    }

    public void save() {
    }

    public void load() {
    }

    private int getButtonSize() {
        String string = Dialang.rdb.getProperty("itemreviewmenu.options.subclass.incorrect.itembutton", "font");
        MenuOption menuOption = new MenuOption(99);
        menuOption.setProperty("font", string);
        Dimension dimension = menuOption.getPreferredSize();
        return Math.max(dimension.width, dimension.height);
    }

    private int getButtonCount() {
        int n;
        try {
            String string = Dialang.rdb.getProperty("itemreview.options.subclass", "buttons");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 6;
        }
        return n;
    }

    private int getDescWidth() {
        int n;
        try {
            String string = Dialang.rdb.getProperty("itemreview.options.subclass", "descwidth");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 275;
        }
        return n;
    }

    static /* synthetic */ Model access$0() {
        return Dialang.model;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

