/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.pages.itemtype.gapdrop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.dialang.client.dialogues.Dialogue;
import net.dialang.client.model.Model;
import net.dialang.client.pages.itemtype.ItemFeedbackViewChangeListener;
import net.dialang.client.pages.itemtype.ItemTypeController;
import net.dialang.client.pages.itemtype.ItemTypeListener;
import net.dialang.client.pages.itemtype.MultipleNamedItems;
import net.dialang.client.pages.itemtype.NamedItem;
import net.dialang.client.pages.itemtype.QuestionView;
import net.dialang.client.pages.itemtype.gapdrop.GapDropOption;
import net.dialang.client.widget.ResourceManager;
import net.dialang.client.widget.Widget;
import net.dialang.client.wlib.WPanel;
import net.dialang.client.wlib.WTextPane;
import net.dialang.common.GapDropItem;
import net.dialang.common.Item;
import net.dialang.entity.GapDropModel;
import net.dialang.entity.ItemTypeModel;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.jam.Display;

public class GapDropController
extends ItemTypeController
implements ItemFeedbackViewChangeListener {
    protected WPanel main = new WPanel();
    protected QuestionView prompt;
    protected WTextPane gapPane;
    private ActionListener listener;
    private GapDropModel itm;
    private ButtonGroup bg;
    private ItemTypeListener itl;
    protected Debug debug;
    private ArrayList options;
    private SimpleAttributeSet gapTextAttributes;
    private boolean reviewMode;
    private Dialogue feedbackDialogue;
    private Display display;
    private GapDropOption focusGDO;
    private boolean isTrue = true;
    private int originalSelection = -1;
    private Model model;
    private HashMap optionsNotDone;

    public void viewChanged(int n) {
        Iterator iterator = ((AbstractList)this.options).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            GapDropOption gapDropOption = (GapDropOption)iterator.next();
            gapDropOption.setHighlightBorder(n2 == n);
            ++n2;
        }
    }

    public void setItemNoOffset(int n) {
    }

    public ItemTypeModel getResult() {
        Iterator iterator = ((AbstractList)this.options).iterator();
        while (iterator.hasNext()) {
            GapDropOption gapDropOption = (GapDropOption)iterator.next();
            gapDropOption.mapResponse();
        }
        return this.itm;
    }

    public Component getView() {
        return this.main;
    }

    public void setItemTypeListener(ItemTypeListener itemTypeListener) {
        this.itl = itemTypeListener;
        this.debug = itemTypeListener.getDebug();
    }

    public void mediaCompleted(boolean bl) {
    }

    public void mediaReady(boolean bl) {
    }

    public void mediaStarted(boolean bl) {
    }

    private SimpleAttributeSet getGapTextAttributes(ResourceManager resourceManager) {
        Font font = null;
        Color color = null;
        String string = resourceManager.getProperty("gapdrop.gaptext", "font");
        if (string == null) {
            System.err.println("<WARNING> missing resource: gapdrop.gaptext.font");
            string = "SansSerif-plain-14";
        }
        try {
            font = Font.decode(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.debug.println("GapDropController: problem decoding font");
        }
        String string2 = resourceManager.getProperty("gapdrop.gaptext", "foreground");
        if (string2 == null) {
            System.err.println("<WARNING> missing resource: gapdrop.gaptext.foreground");
            string2 = "black";
        }
        try {
            color = Color.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            this.debug.println("GapDropController: Error decoding colour");
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, color);
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
        StyleConstants.setBold(simpleAttributeSet, font.isBold());
        return simpleAttributeSet;
    }

    public void setItemTypeModel(ItemTypeModel itemTypeModel) {
        Serializable serializable;
        Object object;
        this.itm = (GapDropModel)itemTypeModel;
        this.prompt.setText(this.itm.getPrompt());
        this.options = new ArrayList();
        Iterator iterator = this.itm.items();
        while (iterator.hasNext()) {
            object = (GapDropItem)iterator.next();
            serializable = new GapDropOption((GapDropItem)object);
            ((JComboBox)serializable).addActionListener(this.listener);
            this.options.add(serializable);
        }
        this.optionsNotDone = new HashMap();
        iterator = ((AbstractList)this.options).iterator();
        while (iterator.hasNext()) {
            this.optionsNotDone.put(iterator.next(), "");
        }
        object = this.gapPane.getDocument();
        serializable = this.itm.getGapText();
        Iterator iterator2 = ((AbstractList)((Object)serializable)).iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            if (e instanceof String) {
                String string = (String)e;
                try {
                    object.insertString(object.getLength(), string, this.gapTextAttributes);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    this.debug.println("GapDropController: text change Error (1)");
                }
                continue;
            }
            if (!(e instanceof Integer)) continue;
            int n = (Integer)e;
            GapDropOption gapDropOption = (GapDropOption)this.options.get(n);
            GapDropController gapDropController = this;
            if (gapDropController == null) {
                throw null;
            }
            gapDropOption.addHierarchyListener(new HierarchyListener(gapDropController, gapDropOption){
                private Container oldParent;
                private final /* synthetic */ GapDropController this$0;
                private final /* synthetic */ GapDropOption val$comp;

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    Container container = this.val$comp.getParent();
                    if (container != this.oldParent) {
                        if (this.oldParent != null) {
                            this.this$0.gapPane.remove(this.oldParent);
                        }
                        this.oldParent = container;
                    }
                }
                {
                    this.val$comp = gapDropOption;
                    this.this$0 = gapDropController;
                    this.constructor$0(gapDropController);
                }

                private final void constructor$0(GapDropController gapDropController) {
                }
            });
            if (gapDropOption == null) {
                throw new RuntimeException("inconsistent answer error @ " + n);
            }
            this.gapPane.setCaretPosition(object.getLength());
            this.gapPane.insertComponent(gapDropOption);
        }
        this.gapPane.setEditable(false);
    }

    public ItemTypeModel getItemTypeModel() {
        return this.itm;
    }

    private int getSelectedItemNo() {
        Iterator iterator = ((AbstractList)this.options).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            GapDropOption gapDropOption = (GapDropOption)iterator.next();
            if (!gapDropOption.equals(this.focusGDO)) continue;
            return n - 1 + this.itm.getPresentationID();
        }
        return -1;
    }

    public void setReviewMode(boolean bl) {
        this.reviewMode = bl;
        if (!this.reviewMode) {
            return;
        }
        Iterator iterator = ((AbstractList)this.options).iterator();
        Iterator iterator2 = this.itm.items();
        while (iterator2.hasNext()) {
            GapDropOption gapDropOption = (GapDropOption)iterator.next();
            GapDropItem gapDropItem = (GapDropItem)iterator2.next();
            int n = (Integer)gapDropItem.getResponse();
            if (this.model.isReviewMode()) {
                ++n;
            }
            gapDropOption.setResponse(new Integer(n));
            gapDropOption.setEnabled(false);
        }
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setFeedbackDialogue(Dialogue dialogue) {
        this.feedbackDialogue = dialogue;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public void displayReview(Item item) {
        Object object;
        int n;
        Object object2;
        MultipleNamedItems multipleNamedItems = new MultipleNamedItems();
        int n2 = this.itm.size();
        multipleNamedItems.setItemFeedbackViewChangeListener(this);
        if (item != null) {
            object2 = ((AbstractList)this.options).iterator();
            n = 0;
            while (object2.hasNext()) {
                object = (GapDropOption)object2.next();
                if (((GapDropOption)object).getItem() == item) {
                    multipleNamedItems.setDefault(n);
                }
                ++n;
            }
        } else {
            multipleNamedItems.setDefault(0);
        }
        object2 = new Vector();
        n = 0;
        object = ((AbstractList)this.options).iterator();
        while (object.hasNext()) {
            GapDropOption gapDropOption = (GapDropOption)object.next();
            NamedItem namedItem = new NamedItem();
            namedItem.setItem(gapDropOption.getItem());
            namedItem.setName(new Integer(n + this.itm.getPresentationID()).toString());
            namedItem.setResponse(gapDropOption.getItem().getAnswer((Integer)gapDropOption.getItem().getResponse()).getText());
            ((Vector)object2).add(namedItem);
            ++n;
        }
        multipleNamedItems.setNamedItems((Vector)object2);
        this.feedbackDialogue.setObject(multipleNamedItems);
        GapDropController gapDropController = this;
        if (gapDropController == null) {
            throw null;
        }
        new Thread(new Runnable(gapDropController){
            private final /* synthetic */ GapDropController this$0;

            public void run() {
                GapDropController.access$4(this.this$0).popUp(GapDropController.access$3(this.this$0));
            }
            {
                this.this$0 = gapDropController;
                this.constructor$0(gapDropController);
            }

            private final void constructor$0(GapDropController gapDropController) {
            }
        }).start();
    }

    static /* synthetic */ HashMap access$0(GapDropController gapDropController) {
        return gapDropController.optionsNotDone;
    }

    static /* synthetic */ ItemTypeListener access$1(GapDropController gapDropController) {
        return gapDropController.itl;
    }

    static /* synthetic */ ActionListener access$2(GapDropController gapDropController) {
        return gapDropController.listener;
    }

    static /* synthetic */ Dialogue access$3(GapDropController gapDropController) {
        return gapDropController.feedbackDialogue;
    }

    static /* synthetic */ Display access$4(GapDropController gapDropController) {
        return gapDropController.display;
    }

    public GapDropController() {
        this.main.getWidget().setName("gapdrop");
        this.main.setLayout(new BoxLayout(this.main, 1));
        this.prompt = new QuestionView();
        this.prompt.getWidget().setName("prompt");
        this.gapPane = new WTextPane();
        this.gapPane.getWidget().setName("gaptext");
        this.gapPane.setOpaque(true);
        this.gapPane.setBorder(new EmptyBorder(10, 20, 20, 10));
        this.gapPane.setEditable(true);
        GapDropController gapDropController = this;
        if (gapDropController == null) {
            throw null;
        }
        this.listener = new ActionListener(gapDropController){
            private final /* synthetic */ GapDropController this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                if (GapDropController.access$0(this.this$0).containsKey(actionEvent.getSource())) {
                    GapDropController.access$0(this.this$0).remove(actionEvent.getSource());
                }
                if (GapDropController.access$0(this.this$0).size() == 0) {
                    GapDropController.access$1(this.this$0).setResponseAvailable(true);
                }
                GapDropOption gapDropOption = (GapDropOption)actionEvent.getSource();
                gapDropOption.removeActionListener(GapDropController.access$2(this.this$0));
            }
            {
                this.this$0 = gapDropController;
                this.constructor$0(gapDropController);
            }

            private final void constructor$0(GapDropController gapDropController) {
            }
        };
        this.gapPane.getWidget();
        this.gapTextAttributes = this.getGapTextAttributes(Widget.getRDB());
    }
}

