/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.pages.itemtype.gaptext;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.dialang.client.wlib.WTextField;
import net.dialang.common.GapTextItem;
import net.dialang.mytest.util.LimitedPlainDocument;

public class GapTextOption
extends WTextField {
    static Border defaultBorder;
    private GapTextItem item;

    public void setResponse(String string) {
        this.setText(string);
    }

    public void mapResponse() {
        this.item.setResponse(this.getText());
    }

    public GapTextItem getItem() {
        return this.item;
    }

    public void setHighlightBorder(boolean bl) {
        if (!bl) {
            this.setBorder(defaultBorder);
            return;
        }
        this.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.red, 2), this.getBorder()));
    }

    public GapTextOption(GapTextItem gapTextItem, DocumentListener documentListener) {
        this.item = gapTextItem;
        this.getWidget().setName("gap");
        this.getWidget().setActive(true);
        this.setBorder(LineBorder.createBlackLineBorder());
        if (defaultBorder == null) {
            defaultBorder = this.getBorder();
        }
        this.setOpaque(true);
        this.setEditable(true);
        this.setAlignmentY(0.75f);
        int n = gapTextItem.getLongestAnswer();
        n = Math.max(n, 6);
        this.setColumns(n);
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        LimitedPlainDocument limitedPlainDocument = new LimitedPlainDocument(Math.max(40, n));
        limitedPlainDocument.addDocumentListener(documentListener);
        ((JTextComponent)this).setDocument(limitedPlainDocument);
    }
}

