/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.pages.itemtype.gaptext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.dialang.client.dialogues.Dialogue;
import net.dialang.client.model.Model;
import net.dialang.client.pages.itemtype.ItemFeedbackViewChangeListener;
import net.dialang.client.pages.itemtype.ItemTypeController;
import net.dialang.client.pages.itemtype.ItemTypeListener;
import net.dialang.client.pages.itemtype.MultipleNamedItems;
import net.dialang.client.pages.itemtype.NamedItem;
import net.dialang.client.pages.itemtype.QuestionView;
import net.dialang.client.pages.itemtype.gaptext.GapTextOption;
import net.dialang.client.widget.ResourceManager;
import net.dialang.client.widget.Widget;
import net.dialang.client.wlib.WPanel;
import net.dialang.client.wlib.WTextPane;
import net.dialang.common.GapTextItem;
import net.dialang.common.Item;
import net.dialang.entity.GapTextModel;
import net.dialang.entity.ItemTypeModel;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.jam.Display;
import net.dialang.mytest.jam.Sponge;

public class GapTextView
extends ItemTypeController
implements ItemFeedbackViewChangeListener {
    protected WPanel main = new WPanel();
    protected QuestionView prompt;
    protected WTextPane gapPane;
    private DocumentListener listener;
    private GapTextModel itm;
    private ButtonGroup bg;
    private ItemTypeListener itl;
    protected Debug debug;
    private ArrayList options;
    private SimpleAttributeSet gapTextAttributes;
    private boolean reviewMode;
    private Display display;
    private Dialogue feedbackDialogue;
    private GapTextOption focusGTO;
    private HashMap optionsNotDone;

    public void viewChanged(int n) {
        Iterator iterator = ((AbstractList)this.options).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            GapTextOption gapTextOption = (GapTextOption)iterator.next();
            gapTextOption.setHighlightBorder(n2 == n);
            ++n2;
        }
    }

    public void setItemNoOffset(int n) {
    }

    public ItemTypeModel getResult() {
        Iterator iterator = ((AbstractList)this.options).iterator();
        while (iterator.hasNext()) {
            GapTextOption gapTextOption = (GapTextOption)iterator.next();
            gapTextOption.mapResponse();
        }
        return this.itm;
    }

    public Component getView() {
        return this.main;
    }

    public boolean requiresKeyExt() {
        return true;
    }

    public void setItemTypeListener(ItemTypeListener itemTypeListener) {
        this.itl = itemTypeListener;
        this.debug = itemTypeListener.getDebug();
    }

    public void mediaCompleted(boolean bl) {
    }

    public void mediaReady(boolean bl) {
    }

    public void mediaStarted(boolean bl) {
    }

    private SimpleAttributeSet getGapTextAttributes(ResourceManager resourceManager) {
        Font font = null;
        Color color = null;
        String string = resourceManager.getProperty("gaptext.gaptext", "font");
        if (string == null) {
            System.err.println("<WARNING> missing resource: gaptext.gaptext.font");
            string = "SansSerif-plain-14";
        }
        try {
            font = Font.decode(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.debug.println("GapTextController: Problem decoding font");
        }
        String string2 = resourceManager.getProperty("gaptext.gaptext", "foreground");
        if (string2 == null) {
            System.err.println("<WARNING> missing resource: gaptext.gaptext.foreground");
            string2 = "0";
        }
        try {
            color = Color.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            this.debug.println("GapTextController: Problem decoding foreground");
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, color);
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
        StyleConstants.setBold(simpleAttributeSet, font.isBold());
        StyleConstants.setAlignment(simpleAttributeSet, 3);
        StyleConstants.setLineSpacing(simpleAttributeSet, (float)font.getSize() * 0.5f);
        return simpleAttributeSet;
    }

    public void setItemTypeModel(ItemTypeModel itemTypeModel) {
        Serializable serializable;
        Object object;
        this.itm = (GapTextModel)itemTypeModel;
        this.prompt.setText(this.itm.getPrompt());
        this.options = new ArrayList();
        Iterator iterator = this.itm.items();
        while (iterator.hasNext()) {
            object = (GapTextItem)iterator.next();
            serializable = new GapTextOption((GapTextItem)object, this.listener);
            this.options.add(serializable);
        }
        this.optionsNotDone = new HashMap();
        iterator = ((AbstractList)this.options).iterator();
        while (iterator.hasNext()) {
            this.optionsNotDone.put(((GapTextOption)iterator.next()).getDocument(), "");
        }
        object = this.gapPane.getDocument();
        serializable = this.itm.getGapText();
        Iterator iterator2 = ((AbstractList)((Object)serializable)).iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            if (e instanceof String) {
                String string = (String)e;
                try {
                    object.insertString(object.getLength(), string, this.gapTextAttributes);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    this.debug.println("GapTextController: problem inserting text");
                }
                continue;
            }
            if (!(e instanceof Integer)) continue;
            int n = (Integer)e;
            GapTextOption gapTextOption = (GapTextOption)this.options.get(n);
            GapTextView gapTextView = this;
            if (gapTextView == null) {
                throw null;
            }
            gapTextOption.addHierarchyListener(new HierarchyListener(gapTextView, gapTextOption){
                private Container oldParent;
                private final /* synthetic */ GapTextView this$0;
                private final /* synthetic */ GapTextOption val$comp;

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    Container container = this.val$comp.getParent();
                    if (container != this.oldParent) {
                        if (this.oldParent != null) {
                            this.this$0.gapPane.remove(this.oldParent);
                        }
                        this.oldParent = container;
                    }
                }
                {
                    this.val$comp = gapTextOption;
                    this.this$0 = gapTextView;
                    this.constructor$0(gapTextView);
                }

                private final void constructor$0(GapTextView gapTextView) {
                }
            });
            if (gapTextOption == null) {
                throw new RuntimeException("inconsistent answer error @ " + n);
            }
            this.gapPane.setCaretPosition(object.getLength());
            this.gapPane.insertComponent(gapTextOption);
        }
        this.gapPane.setEditable(false);
    }

    public ItemTypeModel getItemTypeModel() {
        return this.itm;
    }

    public void displayReview(Item item) {
        Object object;
        int n;
        Object object2;
        MultipleNamedItems multipleNamedItems = new MultipleNamedItems();
        multipleNamedItems.setItemFeedbackViewChangeListener(this);
        int n2 = this.itm.size();
        if (item != null) {
            object2 = ((AbstractList)this.options).iterator();
            n = 0;
            while (object2.hasNext()) {
                object = (GapTextOption)object2.next();
                if (((GapTextOption)object).getItem() == item) {
                    multipleNamedItems.setDefault(n);
                }
                ++n;
            }
        } else {
            multipleNamedItems.setDefault(0);
        }
        object2 = new Vector();
        n = 0;
        object = ((AbstractList)this.options).iterator();
        while (object.hasNext()) {
            GapTextOption gapTextOption = (GapTextOption)object.next();
            NamedItem namedItem = new NamedItem();
            namedItem.setItem(gapTextOption.getItem());
            namedItem.setName(new Integer(n + this.itm.getPresentationID()).toString());
            namedItem.setResponse((String)gapTextOption.getItem().getResponse());
            ((Vector)object2).add(namedItem);
            ++n;
        }
        multipleNamedItems.setNamedItems((Vector)object2);
        this.feedbackDialogue.setObject(multipleNamedItems);
        GapTextView gapTextView = this;
        if (gapTextView == null) {
            throw null;
        }
        new Thread(new Runnable(gapTextView){
            private final /* synthetic */ GapTextView this$0;

            public void run() {
                GapTextView.access$4(this.this$0).popUp(GapTextView.access$3(this.this$0));
            }
            {
                this.this$0 = gapTextView;
                this.constructor$0(gapTextView);
            }

            private final void constructor$0(GapTextView gapTextView) {
            }
        }).start();
    }

    public void setReviewMode(boolean bl) {
        System.err.println("GapDrop: SetReviewMode " + bl);
        this.reviewMode = bl;
        if (!this.reviewMode) {
            return;
        }
        Iterator iterator = ((AbstractList)this.options).iterator();
        Iterator iterator2 = this.itm.items();
        while (iterator2.hasNext()) {
            GapTextOption gapTextOption = (GapTextOption)iterator.next();
            GapTextItem gapTextItem = (GapTextItem)iterator2.next();
            gapTextOption.setEditable(false);
            gapTextOption.setEnabled(false);
            this.gapPane.setEditable(false);
            gapTextOption.setResponse((String)gapTextItem.getResponse());
        }
    }

    public void setModel(Model model) {
    }

    public void setFeedbackDialogue(Dialogue dialogue) {
        this.feedbackDialogue = dialogue;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    static /* synthetic */ DocumentListener access$0(GapTextView gapTextView) {
        return gapTextView.listener;
    }

    static /* synthetic */ HashMap access$1(GapTextView gapTextView) {
        return gapTextView.optionsNotDone;
    }

    static /* synthetic */ ItemTypeListener access$2(GapTextView gapTextView) {
        return gapTextView.itl;
    }

    static /* synthetic */ Dialogue access$3(GapTextView gapTextView) {
        return gapTextView.feedbackDialogue;
    }

    static /* synthetic */ Display access$4(GapTextView gapTextView) {
        return gapTextView.display;
    }

    public GapTextView() {
        this.main.getWidget().setName("gaptext");
        this.main.setLayout(new BoxLayout(this.main, 1));
        this.prompt = new QuestionView();
        this.prompt.getWidget().setName("prompt");
        this.gapPane = new WTextPane();
        this.gapPane.getWidget().setName("gaptext");
        this.gapPane.setOpaque(true);
        this.gapPane.setBorder(new EmptyBorder(10, 20, 20, 10));
        this.gapPane.setEditable(true);
        GapTextView gapTextView = this;
        if (gapTextView == null) {
            throw null;
        }
        this.listener = new DocumentListener(gapTextView){
            private final /* synthetic */ GapTextView this$0;

            private void checkFeedbackMode(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                documentEvent.getDocument().removeDocumentListener(GapTextView.access$0(this.this$0));
                if (GapTextView.access$1(this.this$0).containsKey(documentEvent.getDocument())) {
                    GapTextView.access$1(this.this$0).remove(documentEvent.getDocument());
                }
                if (GapTextView.access$1(this.this$0).size() == 0) {
                    GapTextView.access$2(this.this$0).setResponseAvailable(true);
                }
            }
            {
                this.this$0 = gapTextView;
                this.constructor$0(gapTextView);
            }

            private final void constructor$0(GapTextView gapTextView) {
            }
        };
        this.gapPane.getWidget();
        this.gapTextAttributes = this.getGapTextAttributes(Widget.getRDB());
        this.main.add(this.prompt);
        this.main.add(this.gapPane);
        this.main.add(new Sponge());
        this.main.getWidget().setRoot();
    }
}

