/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.pages.itemtype.tabbedpane;

import java.awt.Component;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.dialang.client.dialogues.Dialogue;
import net.dialang.client.model.Model;
import net.dialang.client.pages.itemtype.ItemFeedbackViewChangeListener;
import net.dialang.client.pages.itemtype.ItemTypeController;
import net.dialang.client.pages.itemtype.ItemTypeListener;
import net.dialang.client.pages.itemtype.MultipleNamedItems;
import net.dialang.client.pages.itemtype.NamedItem;
import net.dialang.client.pages.itemtype.mcq.MCQView;
import net.dialang.client.wlib.WTabbedPane;
import net.dialang.common.Item;
import net.dialang.entity.ItemTypeModel;
import net.dialang.entity.MCQModel;
import net.dialang.entity.TabbedPaneModel;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.jam.Display;

public class TabbedPaneView
extends ItemTypeController
implements ChangeListener,
ItemTypeListener,
ItemFeedbackViewChangeListener {
    protected WTabbedPane main = new WTabbedPane();
    private TabbedPaneModel itm;
    private ItemTypeListener itl;
    private boolean[] mediaEnabled;
    private boolean[] childCompleted;
    private int activeIndex;
    private ArrayList children;
    private Debug debug;
    private Dialogue feedbackDialogue;
    private Display display;
    private int playCount;
    private static /* synthetic */ Class class$Lnet$dialang$entity$MCQModel;

    public Component getView() {
        return this.main;
    }

    public void viewChanged(int n) {
        this.main.setSelectedIndex(n);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        WTabbedPane wTabbedPane = (WTabbedPane)changeEvent.getSource();
        this.enableMedia(this.playCount > 0);
    }

    public void setItemTypeListener(ItemTypeListener itemTypeListener) {
        this.itl = itemTypeListener;
        this.debug = itemTypeListener.getDebug();
    }

    public void setItemTypeModel(ItemTypeModel itemTypeModel) {
        this.itm = (TabbedPaneModel)itemTypeModel;
        this.main.removeAll();
        this.playCount = this.itm.size();
        this.mediaEnabled = new boolean[this.itm.size()];
        this.childCompleted = new boolean[this.itm.size()];
        this.children = new ArrayList();
        int n = 1;
        int n2 = this.itm.getPresentationID();
        Iterator iterator = this.itm.children();
        while (iterator.hasNext()) {
            this.mediaEnabled[n - 1] = true;
            this.childCompleted[n - 1] = false;
            ItemTypeModel itemTypeModel2 = (ItemTypeModel)iterator.next();
            if (!itemTypeModel2.getClass().equals(class$Lnet$dialang$entity$MCQModel != null ? class$Lnet$dialang$entity$MCQModel : TabbedPaneView.class$("net.dialang.entity.MCQModel"))) {
                this.debug.println(ItemTypeController.debugID, "Non MCQ item added to tabbed pane!!");
            }
            ItemTypeController itemTypeController = ItemTypeController.getController(itemTypeModel2);
            this.children.add(itemTypeController);
            itemTypeController.setItemTypeModel(itemTypeModel2);
            itemTypeController.setItemTypeListener(this);
            this.main.add("   " + n2 + "   ", itemTypeController.getView());
            itemTypeController.setItemNoOffset(n2);
            ++n2;
            ++n;
        }
    }

    public void setItemNoOffset(int n) {
    }

    public ItemTypeModel getItemTypeModel() {
        return this.itm;
    }

    public void mediaCompleted(boolean bl) {
        this.debug.println(ItemTypeController.debugID, "mediaCompleted ", String.valueOf(bl));
        if (!bl) {
            this.activeIndex = this.main.getSelectedIndex();
        }
        if (bl) {
            this.mediaEnabled[this.activeIndex] = false;
        }
        if (bl) {
            --this.playCount;
        }
        if (this.playCount > 0) {
            this.itl.enableMedia(true);
        }
    }

    public void mediaReady(boolean bl) {
    }

    public void mediaStarted(boolean bl) {
    }

    public void setResponseAvailable(boolean bl) {
        int n = this.main.getSelectedIndex();
        int n2 = 0;
        this.childCompleted[n] = true;
        this.main.setFlagged(n, true);
        int n3 = 0;
        while (n3 < this.itm.size()) {
            if (this.childCompleted[n3]) {
                ++n2;
            }
            if (n3 != n) {
                this.main.setEnabledAt(n3, true);
            }
            ++n3;
        }
        if (n2 == this.itm.size()) {
            this.itl.setResponseAvailable(true);
        }
    }

    public void resetMedia() {
        this.itl.resetMedia();
    }

    public void enableMedia(boolean bl) {
        this.itl.enableMedia(bl);
    }

    public Debug getDebug() {
        return this.itl.getDebug();
    }

    public void setReviewMode(boolean bl) throws IOException {
        if (!bl) {
            return;
        }
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            ItemTypeController itemTypeController = (ItemTypeController)iterator.next();
            itemTypeController.setReviewMode(bl);
        }
    }

    public void displayReview(Item item) {
        MultipleNamedItems multipleNamedItems = new MultipleNamedItems();
        multipleNamedItems.setItemFeedbackViewChangeListener(this);
        if (item == null) {
            multipleNamedItems.setDefault(0);
        }
        Vector<NamedItem> vector = new Vector<NamedItem>();
        int n = 0;
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            MCQView mCQView = (MCQView)iterator.next();
            NamedItem namedItem = mCQView.getNamedItem();
            namedItem.setName(new Integer(this.itm.getPresentationID() + n).toString());
            vector.add(namedItem);
            MCQModel mCQModel = (MCQModel)mCQView.getItemTypeModel();
            if (mCQModel != null && mCQModel.getItem() == item) {
                multipleNamedItems.setDefault(n);
            }
            ++n;
        }
        multipleNamedItems.setNamedItems(vector);
        this.feedbackDialogue.setObject(multipleNamedItems);
        TabbedPaneView tabbedPaneView = this;
        if (tabbedPaneView == null) {
            throw null;
        }
        new Thread(new Runnable(tabbedPaneView){
            private final /* synthetic */ TabbedPaneView this$0;

            public void run() {
                TabbedPaneView.access$1(this.this$0).popUp(TabbedPaneView.access$0(this.this$0));
            }
            {
                this.this$0 = tabbedPaneView;
                this.constructor$0(tabbedPaneView);
            }

            private final void constructor$0(TabbedPaneView tabbedPaneView) {
            }
        }).start();
    }

    public void setModel(Model model) {
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            ItemTypeController itemTypeController = (ItemTypeController)iterator.next();
            itemTypeController.setModel(model);
        }
    }

    public void setFeedbackDialogue(Dialogue dialogue) {
        this.feedbackDialogue = dialogue;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public ItemTypeModel getResult() {
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            ItemTypeController itemTypeController = (ItemTypeController)iterator.next();
            itemTypeController.getResult();
        }
        return this.itm;
    }

    static /* synthetic */ Dialogue access$0(TabbedPaneView tabbedPaneView) {
        return tabbedPaneView.feedbackDialogue;
    }

    static /* synthetic */ Display access$1(TabbedPaneView tabbedPaneView) {
        return tabbedPaneView.display;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TabbedPaneView() {
        this.main.getWidget().setName("tabbedpane");
        this.main.addChangeListener(this);
        this.main.setBorder(new EmptyBorder(10, 5, 5, 5));
        this.main.getWidget().setRoot();
    }
}

