/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.precache;

import java.util.Iterator;
import net.dialang.client.model.Model;
import net.dialang.client.precache.Precache;
import net.dialang.entity.ItemTypeModel;
import net.dialang.entity.MediaModel;

class GetItemDataThread
implements Runnable {
    private Iterator iterator;
    private Model model;
    private Precache precache;
    private boolean stopNext;
    private int[] items;

    public void stopAfterNext() {
        this.stopNext = true;
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        int n = 0;
        while (n < this.items.length && !this.stopNext) {
            try {
                int n2 = this.items[n];
                ItemTypeModel itemTypeModel = this.model.loadItemTypeModel(new Integer(n2));
                MediaModel mediaModel = itemTypeModel.getMediaModel();
                if (mediaModel.getRef() != null) {
                    if (mediaModel.getVocabSubKey().equals("SOUND")) {
                        this.model.getAudio(mediaModel.getRef());
                    } else if (mediaModel.getVocabSubKey().equals("IMAGE")) {
                        this.model.getImageIcon(mediaModel.getRef());
                    }
                }
                this.precache.doneItems.add(new Integer(n2));
                this.precache.fireListeners();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public GetItemDataThread(Model model, Precache precache, int[] nArray) {
        this.model = model;
        this.precache = precache;
        this.items = nArray;
        this.stopNext = false;
    }
}

