/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.precache;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import net.dialang.client.comms.ICommsHandler;
import net.dialang.client.model.Model;
import net.dialang.client.precache.PrecacheListener;
import net.dialang.common.BasicModule;
import net.dialang.common.ItemTypeModule;
import net.dialang.entity.ItemTypeModel;
import net.dialang.entity.MediaModel;
import net.dialang.mytest.debug.Debug;

public class Precache
implements PrecacheListener {
    private static final int debugID = 0x200000;
    private Model model;
    private GetBasketDataThread t;
    private Vector done;
    private Debug debug;

    public void waitForBasket(String string) {
        if (this.done.contains(string)) {
            this.debug.println(0x200000, "Basket " + string + " has been precached already. Returning ...");
            return;
        }
        this.t.waitForBasket(string);
    }

    public void basketPrecached(String string) {
        this.debug.println(0x200000, "Adding basket " + string + " to done list ...");
        this.done.add(string);
        this.debug.println(0x200000, "Basket " + string + " added to done list.");
    }

    public void setJobList(ArrayList arrayList) {
        if (this.t != null) {
            this.t.cancel();
        }
        Precache precache = this;
        if (precache == null) {
            throw null;
        }
        this.t = precache.new GetBasketDataThread(this.model);
        this.t.addPrecacheListener(this);
        this.t.addToJobList(arrayList);
    }

    public void addToJobList(ArrayList arrayList) {
        this.t.addToJobList(arrayList);
    }

    public void addToJobList(String string) {
        this.t.addToJobList(string);
    }

    public void softStop() {
        this.t.reset(null);
    }

    public boolean isOnJobList(String string) {
        return this.t.isOnJobList(string);
    }

    public boolean isCached(String string) {
        boolean bl = this.done.contains(string);
        this.debug.println(0x200000, "Precache::isCached() returning " + bl);
        return bl;
    }

    public boolean isFinished() {
        return !this.t.isAlive();
    }

    public void removeBasketToDownload(String string) {
        this.t.removeFromJobList(string);
    }

    public void addPrecacheListener(PrecacheListener precacheListener) {
        this.t.addPrecacheListener(precacheListener);
    }

    public void removePrecacheListener(PrecacheListener precacheListener) {
        this.t.removePrecacheListener(precacheListener);
    }

    static /* synthetic */ int access$0() {
        return debugID;
    }

    public Precache(Model model, Debug debug) throws Exception {
        if (model == null || debug == null) {
            throw new Exception("Neither the model nor debug parameters must be null.");
        }
        this.model = model;
        this.done = new Vector(37);
        this.debug = debug;
        Precache precache = this;
        if (precache == null) {
            throw null;
        }
        this.t = precache.new GetBasketDataThread(this.model);
        this.t.addPrecacheListener(this);
    }

    private class GetBasketDataThread
    extends Thread {
        private Model model;
        private ICommsHandler commsHandler;
        private Stack jobList = new Stack();
        private Vector precacheListeners = new Vector(5);
        private boolean continueRunning = true;
        private String currentJob;
        private String clientID;

        private void addToJobList(ArrayList arrayList) {
            if (arrayList == null) {
                return;
            }
            Precache.this.debug.println(0x200000, "Adding baskets to job list ...");
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                this.jobList.add(0, iterator.next());
            }
            Precache.this.debug.println(0x200000, "Baskets added to job list.");
            this.startUp();
        }

        private void addToJobList(String string) {
            Precache.this.debug.println(0x200000, "Adding basket to job list ...");
            this.jobList.add(string);
        }

        private void removeFromJobList(String string) {
            this.jobList.remove(string);
        }

        private void reset(ArrayList arrayList) {
            Precache.this.debug.println(0x200000, "Resetting precache ...");
            this.cancel();
            Precache.this.debug.println(0x200000, "Clearing job list ...");
            this.jobList.clear();
            Precache.this.debug.println(0x200000, "Job list cleared.");
            this.addToJobList(arrayList);
        }

        private void cancel() {
            Precache.this.debug.println(0x200000, "Finishing current job and stopping ...");
            this.continueRunning = false;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                Precache.this.debug.println(0x200000, "InterruptedException caught whilst joining on data thread");
            }
            Precache.this.debug.println(0x200000, "Stopped after finishing current job.");
        }

        private final void startUp() {
            this.continueRunning = true;
            try {
                Precache.this.debug.println(0x200000, "Starting data thread ...");
                this.start();
                Precache.this.debug.println(0x200000, "Data thread started.");
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Precache.this.debug.println(0x200000, "Basket thread already started.");
            }
        }

        private void addPrecacheListener(PrecacheListener precacheListener) {
            this.precacheListeners.add(precacheListener);
        }

        private void removePrecacheListener(PrecacheListener precacheListener) {
            this.precacheListeners.remove(precacheListener);
        }

        private void firePrecacheListeners(String string) {
            Enumeration enumeration = this.precacheListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((PrecacheListener)enumeration.nextElement()).basketPrecached(string);
            }
        }

        private void waitForBasket(String string) {
            if (this.currentJob == null) {
                return;
            }
            boolean bl = false;
            if (string.equals(this.currentJob)) {
                bl = true;
                Precache.this.debug.println(0x200000, "Waiting for basket " + string + " to finish precaching ...");
            }
            while (string.equals(this.currentJob)) {
                try {
                    Precache.this.debug.println(0x200000, "Basket is currently being precached. Waiting 100 milliseconds for current basket to be precached ...");
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Precache.this.debug.println(0x200000, "Exception caught whilst waiting for basket: " + string);
                }
            }
            if (bl) {
                Precache.this.debug.println(0x200000, "Finished precaching basket " + string);
            }
        }

        private boolean isOnJobList(String string) {
            return this.jobList.contains(string);
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            while (this.continueRunning && !this.jobList.empty()) {
                try {
                    String string = (String)this.jobList.pop();
                    string = Integer.toString(Integer.parseInt(string));
                    Precache.this.debug.println(0x200000, "Caching basket " + string);
                    ItemTypeModel itemTypeModel = null;
                    try {
                        itemTypeModel = this.loadBasket(string);
                    }
                    catch (IOException iOException) {
                        Precache.this.debug.println(0x200000, "Failed to precache basket " + string + ". Reason: " + iOException.getMessage());
                        continue;
                    }
                    this.currentJob = string;
                    MediaModel mediaModel = itemTypeModel.getMediaModel();
                    if (mediaModel.getRef() != null) {
                        if (mediaModel.getVocabSubKey().equals("SOUND")) {
                            this.model.getAudio(mediaModel.getRef());
                        } else if (mediaModel.getVocabSubKey().equals("IMAGE")) {
                            this.model.getImageIcon(mediaModel.getRef());
                        }
                    }
                    this.firePrecacheListeners(this.currentJob);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private ItemTypeModel loadBasket(String string) throws IOException {
            int n = 5;
            ItemTypeModule itemTypeModule = new ItemTypeModule();
            itemTypeModule.clientID = this.clientID;
            itemTypeModule.request = string;
            itemTypeModule = (ItemTypeModule)this.commsHandler.getObject(n, (BasicModule)itemTypeModule, "getitemtype");
            return itemTypeModule.itm;
        }

        public GetBasketDataThread(Model model) {
            this.model = model;
            this.commsHandler = this.model.getCommsHandler();
            this.clientID = this.model.getClientID();
        }
    }
}

