/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import net.dialang.client.model.Model;
import net.dialang.client.views.ActionBar;
import net.dialang.client.views.ApplicationViewController;
import net.dialang.client.views.FlowBar;
import net.dialang.client.views.MainArea;
import net.dialang.client.wlib.BackdropImage;
import net.dialang.client.wlib.EventEnabledContentPane;
import net.dialang.mytest.jam.FatalErrorException;

public class ApplicationView
extends ApplicationViewController {
    public static Point centered(JFrame jFrame) {
        Dimension dimension = jFrame.getSize();
        Dimension dimension2 = jFrame.getToolkit().getScreenSize();
        return new Point((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    public void build() {
        Accessible accessible;
        super.build();
        String string = "Dialang";
        if (this.model.getPilotingMode()) {
            string = "Dialang - Piloting Mode";
        }
        this.frame = this.createFrame(this, string);
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setSize(800, 600);
        this.frame.setLocation(ApplicationView.centered(this.frame));
        EventEnabledContentPane eventEnabledContentPane = new EventEnabledContentPane(new BorderLayout());
        eventEnabledContentPane.getWidget().setName("proto");
        this.frame.setContentPane(eventEnabledContentPane);
        this.actionBar = new ActionBar();
        this.actionBar.addLocked(this.logo, this, 0);
        eventEnabledContentPane.add((Component)this.actionBar, "North");
        this.mainArea = new MainArea();
        try {
            accessible = this.model.getImageIcon("backdrop.gif");
            BackdropImage backdropImage = new BackdropImage((ImageIcon)accessible);
            this.mainArea.setBackdrop(backdropImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.debug.println("ApplicationView: problem with backdrop");
            this.completed(new FatalErrorException(this, "getting backdrop image", exception, null));
        }
        eventEnabledContentPane.add((Component)this.mainArea, "Center");
        accessible = Box.createVerticalBox();
        try {
            this.flowBar = new FlowBar(this.model);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.debug.println("ApplicationView: couldn't create flow bar");
            this.completed(new FatalErrorException(this, "creating flow bar", exception, null));
        }
        ((Container)((Object)accessible)).add(this.flowBar);
        eventEnabledContentPane.add((Component)((Object)accessible), "South");
        eventEnabledContentPane.getWidget().setRoot();
        ToolTipManager.sharedInstance().setInitialDelay(200);
    }

    public void repaint() {
        this.frame.getContentPane().repaint();
    }

    public ApplicationView(Model model) {
        super(model);
    }
}

