/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.views;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.dialang.client.dialogues.Dialogue;
import net.dialang.client.dialogues.NonModalDialogue;
import net.dialang.client.dialogues.PopDownListener;
import net.dialang.client.model.Model;
import net.dialang.client.views.ActionBar;
import net.dialang.client.views.FlowBar;
import net.dialang.client.views.MainArea;
import net.dialang.client.wlib.BlackHole;
import net.dialang.client.wlib.WMenuBar;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.jam.Display;
import net.dialang.mytest.jam.StatusValue;

public class ApplicationViewController
extends Display
implements PopDownListener {
    private static Dimension defaultHints = new Dimension(0, 0);
    protected JFrame frame;
    protected JLayeredPane lp;
    protected ActionBar actionBar;
    protected ActionBar statusBar;
    protected FlowBar flowBar;
    protected MainArea mainArea;
    protected Model model;
    protected JLabel logo;
    protected Debug debug;
    protected int debugID;
    protected WMenuBar menuBar;
    private BlackHole blackHole;
    private Component defaultGlassPane;

    public void build() {
        this.blackHole = new BlackHole();
    }

    public void setDebug(Debug debug, int n) {
        this.debug = debug;
        this.debugID = n;
    }

    public void setTitle(String string) {
        if (this.model.getPilotingMode()) {
            this.frame.setTitle("Dialang - Piloting Mode");
        } else {
            this.frame.setTitle("Dialang");
        }
    }

    private final void loadLogo(String string) throws IOException {
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public StatusValue popUp(Dialogue dialogue) {
        this.setWaitCursor(false);
        dialogue.setDisplay(this);
        try {
            return dialogue.popUp(this.frame, this.mainArea.getBounds());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatusValue popUp(NonModalDialogue nonModalDialogue) {
        this.setWaitCursor(false);
        nonModalDialogue.setDisplay(this);
        try {
            return nonModalDialogue.popUp(this.frame, this.mainArea.getBounds());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void popDown(Dialogue dialogue) {
        dialogue.popDown();
    }

    public void popDown(Object object) {
        ((Dialogue)object).popDown();
    }

    public void repaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._repaint();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(this){
                final /* synthetic */ ApplicationViewController this$0;

                public final void run() {
                    ApplicationViewController.access$0(this.this$0);
                }
                {
                    this.this$0 = applicationViewController;
                }
            });
        }
        catch (Throwable throwable) {
            this.debug.println(this.debugID, "AVC/repaint - trapped " + throwable);
        }
    }

    private final void _repaint() {
        ((JPanel)this.frame.getContentPane()).revalidate();
        this.frame.getContentPane().repaint();
    }

    public void setWaitCursor(boolean bl) {
        this.debug.println(this.debugID, "wait cursor: " + bl, Thread.currentThread().getName());
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(this, bl){
                final /* synthetic */ ApplicationViewController this$0;
                final /* synthetic */ boolean val$state;

                public final void run() {
                    this.this$0.setWaitCursor(this.val$state);
                }
                {
                    this.this$0 = applicationViewController;
                    this.val$state = bl;
                }
            }).start();
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(this, bl){
                final /* synthetic */ ApplicationViewController this$0;
                final /* synthetic */ boolean val$state;

                public final void run() {
                    ApplicationViewController.access$1(this.this$0, this.val$state);
                }
                {
                    this.this$0 = applicationViewController;
                    this.val$state = bl;
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            this.debug.println(this.debugID, "AVC/delayedWaitCursor trapped " + invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            this.debug.println(this.debugID, "AVC/delayedWaitCursor trapped " + throwable);
        }
    }

    public Cursor getCursor() {
        return this.frame.getCursor();
    }

    private final void AWT_setCursor(boolean bl) {
        this.AWT_setCursor(bl ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
    }

    private final void AWT_setBlackHole(boolean bl) {
        if (this.defaultGlassPane == null) {
            this.defaultGlassPane = this.frame.getGlassPane();
        }
        JLayeredPane jLayeredPane = this.frame.getLayeredPane();
        if (bl) {
            this.frame.setGlassPane(this.blackHole);
            this.blackHole.setVisible(true);
        } else {
            this.blackHole.setVisible(false);
            this.frame.setGlassPane(this.defaultGlassPane);
        }
    }

    private final void AWT_setCursor(Cursor cursor) {
        this.frame.setCursor(cursor);
    }

    public ActionBar getActionBar() {
        return this.actionBar;
    }

    public FlowBar getFlowBar() {
        return this.flowBar;
    }

    public ActionBar getStatusBar() {
        return this.statusBar;
    }

    public MainArea getMainArea() {
        return this.mainArea;
    }

    public WMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setDefaultButton(JButton jButton) {
        this.frame.getRootPane().setDefaultButton(jButton);
    }

    static /* synthetic */ void access$0(ApplicationViewController applicationViewController) {
        applicationViewController._repaint();
    }

    static /* synthetic */ void access$1(ApplicationViewController applicationViewController, boolean bl) {
        applicationViewController.AWT_setBlackHole(bl);
    }

    public ApplicationViewController(Model model) {
        this.model = model;
    }
}

