/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import net.dialang.client.widget.InstantToolTipListener;
import net.dialang.client.widget.ResourceManager;
import net.dialang.client.widget.WComponent;
import net.dialang.client.widget.WidgetException;
import net.dialang.mytest.debug.Debug;

public class Widget
implements ContainerListener,
PropertyChangeListener {
    private static ResourceManager rdb;
    private static Debug debug;
    private static int debugID;
    private static Hashtable names;
    private static int nameCount;
    private static Vector instantToolTipListeners;
    private String fqn;
    private String name;
    private WComponent component;
    private boolean active;
    private boolean instant;
    private MouseAdapter mouseListener;
    private MouseAdapter instantListener;

    public static void setRDB(ResourceManager resourceManager) {
        rdb = resourceManager;
    }

    public static ResourceManager getRDB() {
        return rdb;
    }

    public static void addInstantToolTipListener(InstantToolTipListener instantToolTipListener) {
        instantToolTipListeners.add(instantToolTipListener);
    }

    public static void setDebug(Debug debug, int n) {
        Widget.debug = debug;
        debugID = n;
    }

    public static Debug getDebug() {
        return debug;
    }

    public WComponent getComponent() {
        return this.component;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getFQN() {
        return this.fqn;
    }

    private final void setFQN(String string) {
        this.fqn = string;
        Widget.registerName(string);
    }

    public void setRoot() {
        if (this.name == null) {
            throw new IllegalStateException("Widget: attempt to set unnamed widget as root!");
        }
        debug.println(debugID, "Widget/setRoot", this.name);
        this.setFQN(this.name);
        this.nameTree();
        this.initTree();
    }

    public boolean isRoot() {
        if (this.name == null) {
            return false;
        }
        boolean bl = false;
        if (this.fqn == this.name) {
            bl = true;
        }
        return bl;
    }

    public void componentAdded(ContainerEvent containerEvent) {
        String string = this.getFQN();
        debug.println(debugID, "Widget/component added to:", string == null ? "anonymous" : string);
        Component component = containerEvent.getChild();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string);
        Widget.nameTree(stringBuffer, this, component);
        Widget.initTree(component);
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        debug.println(debugID, "Widget/component removed from:", this.getFQN());
        Component component = containerEvent.getChild();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Widget widget = Widget.forName(string, (Component)((Object)this.component));
        if (widget != null) {
            try {
                widget.getComponent().setProperty(string, (String)propertyChangeEvent.getNewValue());
            }
            catch (WidgetException widgetException) {
                System.err.println("Widget/propertyChange: trapped " + widgetException.getMessage());
            }
        } else {
            System.err.println("Widget: property change for " + string + "did not find target in tree " + this.fqn);
        }
    }

    public void nameTree() {
        debug.println(debugID, "widget/nameTree");
        if (!this.isRoot()) {
            return;
        }
        if (!(this.component instanceof Container)) {
            return;
        }
        Container container = (Container)((Object)this.component);
        container.addContainerListener(this);
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(this.getFQN());
            Widget.nameTree(stringBuffer, this, componentArray[n]);
            ++n;
        }
    }

    public static void nameTree(StringBuffer stringBuffer, Widget object, Component component) {
        Object object2;
        if (component instanceof WComponent) {
            object2 = ((WComponent)((Object)component)).getWidget();
            if (((Widget)object2).isRoot()) {
                debug.println(debugID, "Widget/nameTree: ignoring root (", ((Widget)object2).getName(), ") found as branch");
                return;
            }
            object = object2;
            if (((Widget)object2).getName() != null) {
                stringBuffer.append('.');
                stringBuffer.append(((Widget)object2).getName());
                super.setFQN(stringBuffer.toString());
            }
        }
        if (component instanceof Container) {
            object2 = (Container)component;
            ((Container)object2).addContainerListener((ContainerListener)object);
            Component[] componentArray = ((Container)object2).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                StringBuffer stringBuffer2 = new StringBuffer(128);
                stringBuffer2.append(stringBuffer.toString());
                Widget.nameTree(stringBuffer2, (Widget)object, componentArray[n]);
                ++n;
            }
        }
    }

    public void initTree() {
        if (!this.isRoot()) {
            return;
        }
        this.initWidget();
        if (this.component instanceof Container) {
            Container container = (Container)((Object)this.component);
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Widget.initTree(componentArray[n]);
                ++n;
            }
        }
    }

    public static void initTree(Component component) {
        Object object;
        if (component instanceof WComponent) {
            object = ((WComponent)((Object)component)).getWidget();
            if (((Widget)object).isRoot()) {
                debug.println(debugID, "Widget/initTree: ignoring root (", ((Widget)object).getName(), ") found as branch");
                return;
            }
            if (((Widget)object).getFQN() != null) {
                ((Widget)object).initWidget();
            }
        }
        if (component instanceof Container) {
            object = (Container)component;
            Component[] componentArray = ((Container)object).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Widget.initTree(componentArray[n]);
                ++n;
            }
        }
    }

    public void initWidget() {
        String[] stringArray = this.component.getProperties();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = rdb.getProperty(this.getFQN(), stringArray[n]);
            if (string != null) {
                this.component.setProperty(stringArray[n], string);
            }
            ++n;
        }
    }

    private static final Widget forName(String string, Component component) {
        Widget widget;
        if (component instanceof WComponent && (widget = ((WComponent)((Object)component)).getWidget()).getFQN().equals(string)) {
            return widget;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                widget = Widget.forName(string, componentArray[n]);
                if (widget != null) {
                    return widget;
                }
                ++n;
            }
        }
        return null;
    }

    private static final void registerName(String string) {
        names.put(string, string);
        int n = names.size();
        if (n > nameCount) {
            debug.println(debugID, "registered FQN:", string);
            nameCount = n;
        }
    }

    public static Enumeration getNames() {
        return names.keys();
    }

    public void setActive(boolean bl) {
        if (bl && !this.active && this.component instanceof JComponent) {
            ((JComponent)((Object)this.component)).addMouseListener(this.mouseListener);
        }
        if (!bl && this.active && this.component instanceof JComponent) {
            ((JComponent)((Object)this.component)).removeMouseListener(this.mouseListener);
        }
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setInstantToolTip(boolean bl) {
        if (bl && !this.instant && this.component instanceof JComponent) {
            ((JComponent)((Object)this.component)).addMouseListener(this.instantListener);
        }
        if (!bl && this.instant && this.component instanceof JComponent) {
            ((JComponent)((Object)this.component)).removeMouseListener(this.instantListener);
        }
        this.instant = bl;
    }

    public boolean isInstantToolTip() {
        return this.instant;
    }

    static /* synthetic */ boolean access$0(Widget widget) {
        return widget.active;
    }

    static /* synthetic */ WComponent access$1(Widget widget) {
        return widget.component;
    }

    static /* synthetic */ Vector access$2() {
        return instantToolTipListeners;
    }

    public Widget(WComponent wComponent) {
        this.component = wComponent;
        this.active = false;
        this.instant = false;
        this.mouseListener = new MouseAdapter(this){
            final /* synthetic */ Widget this$0;

            public final void mouseEntered(MouseEvent mouseEvent) {
                if (!Widget.access$0(this.this$0)) {
                    return;
                }
                if (!((JComponent)((Object)Widget.access$1(this.this$0))).isEnabled()) {
                    return;
                }
                ((JComponent)((Object)Widget.access$1(this.this$0))).setCursor(Cursor.getPredefinedCursor(12));
            }

            public final void mouseExited(MouseEvent mouseEvent) {
                if (!Widget.access$0(this.this$0)) {
                    return;
                }
                if (!((JComponent)((Object)Widget.access$1(this.this$0))).isEnabled()) {
                    return;
                }
                ((JComponent)((Object)Widget.access$1(this.this$0))).setCursor(Cursor.getPredefinedCursor(0));
            }
            {
                this.this$0 = widget;
            }
        };
        this.instantListener = new MouseAdapter(this){
            final /* synthetic */ Widget this$0;

            public final void mouseEntered(MouseEvent mouseEvent) {
                String string = ((JComponent)((Object)Widget.access$1(this.this$0))).getToolTipText();
                Enumeration<E> enumeration = Widget.access$2().elements();
                while (enumeration.hasMoreElements()) {
                    ((InstantToolTipListener)enumeration.nextElement()).showToolTipFired(string);
                }
            }

            public final void mouseExited(MouseEvent mouseEvent) {
                Enumeration<E> enumeration = Widget.access$2().elements();
                while (enumeration.hasMoreElements()) {
                    ((InstantToolTipListener)enumeration.nextElement()).hideToolTipFired();
                }
            }
            {
                this.this$0 = widget;
            }
        };
    }

    static {
        debugID = 0;
        names = new Hashtable();
        nameCount = 0;
        instantToolTipListeners = new Vector();
    }
}

