/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.wlib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.dialang.client.wlib.HTMLLoader;
import net.dialang.client.wlib.HTMLNavigationListener;
import net.dialang.client.wlib.HTMLPane;
import net.dialang.client.wlib.WPanel;
import net.dialang.client.wlib.WScrollPane;
import net.dialang.mytest.debug.Debug;

public class HTMLStack
extends WPanel
implements HyperlinkListener,
PropertyChangeListener {
    private HTMLPane current;
    private HashMap cache;
    private HTMLLoader loader;
    private Debug debug;
    private int debugID;
    private Border scrollBorder;
    private HTMLNavigationListener navListener;

    public void setScrollBorder(Border border) {
        this.scrollBorder = border;
    }

    public void setDebug(Debug debug, int n) {
        this.debug = debug;
        this.debugID = n;
    }

    public void clear() {
        this.cache.clear();
        this.current = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getOldValue();
        String string2 = object == null ? "null" : object.getClass().getName();
        object = propertyChangeEvent.getNewValue();
        String string3 = object == null ? "null" : object.getClass().getName();
        this.debug.println(this.debugID, "pce name", string, "old", string2, "new", string3);
    }

    public void add(String string, URL uRL) throws IOException {
        this.debug.println(this.debugID, "add ", string, "Thread " + Thread.currentThread().getName());
        HTMLPane hTMLPane = new HTMLPane();
        hTMLPane.getWidget().setName("htmlpane");
        hTMLPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        hTMLPane.addPropertyChangeListener(this);
        WScrollPane wScrollPane = new WScrollPane(hTMLPane);
        wScrollPane.getWidget().setName("scrollpane");
        wScrollPane.setBorder(this.scrollBorder);
        wScrollPane.setPreferredSize(wScrollPane.getMaximumSize());
        JScrollBar jScrollBar = wScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(30);
        jScrollBar.setBlockIncrement(100);
        string = this.removeRef(string);
        this.cache.put(string, wScrollPane);
        hTMLPane.addHyperlinkListener(this);
        this.current = hTMLPane;
        if (EventQueue.isDispatchThread()) {
            this.replace(wScrollPane);
            new Thread(new Runnable(this, uRL){
                final /* synthetic */ HTMLStack this$0;
                final /* synthetic */ URL val$url;

                public final void run() {
                    HTMLStack.access$0(this.this$0, this.val$url);
                }
                {
                    this.this$0 = hTMLStack;
                    this.val$url = uRL;
                }
            }).start();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(this, wScrollPane){
                    final /* synthetic */ HTMLStack this$0;
                    final /* synthetic */ WScrollPane val$sp;

                    public final void run() {
                        HTMLStack.access$1(this.this$0, this.val$sp);
                    }
                    {
                        this.this$0 = hTMLStack;
                        this.val$sp = wScrollPane;
                    }
                });
            }
            catch (Throwable throwable) {
                this.debug.println(this.debugID, "HTMLStack: i&w threw " + throwable);
            }
            this.load(uRL);
        }
        this.debug.println(this.debugID, "add completed");
    }

    private final void load(URL uRL) {
        this.debug.println(this.debugID, "load");
        try {
            this.current.setPage(uRL);
        }
        catch (IOException iOException) {
            this.debug.println(this.debugID, "HTMLStack: load failure " + iOException);
        }
    }

    private final void replace(WScrollPane wScrollPane) {
        this.debug.println("replace");
        this.removeAll();
        this.add((Component)wScrollPane, "Center");
        this.revalidate();
        this.repaint();
    }

    private final void show(String string) {
        String string2 = this.getRef(string);
        WScrollPane wScrollPane = (WScrollPane)this.cache.get(string = this.removeRef(string));
        if (wScrollPane == null) {
            throw new IllegalStateException("no entry for " + string);
        }
        this.current = (HTMLPane)wScrollPane.getViewport().getView();
        EventQueue.invokeLater(new Runnable(this, wScrollPane, string2){
            final /* synthetic */ HTMLStack this$0;
            final /* synthetic */ WScrollPane val$sp;
            final /* synthetic */ String val$ref;

            public final void run() {
                HTMLStack.access$1(this.this$0, this.val$sp);
                if (this.val$ref != null) {
                    HTMLStack.access$2(this.this$0).scrollToRef(this.val$ref);
                }
            }
            {
                this.this$0 = hTMLStack;
                this.val$sp = wScrollPane;
                this.val$ref = string;
            }
        });
    }

    private final String removeRef(String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private final String getRef(String string) {
        int n = string.indexOf(35);
        if (n == -1) {
            return null;
        }
        return string.substring(n);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String string = hyperlinkEvent.getDescription();
        if (string == null) {
            this.debug.println(this.debugID, "null hle");
            return;
        }
        if (this.navListener != null && string.equalsIgnoreCase("main.html")) {
            this.navListener.goPrevious();
            return;
        }
        if (string.charAt(0) == '#') {
            string = string.substring(1);
            this.debug.println(this.debugID, "int ref:", string);
            this.current.scrollToRef(string);
            return;
        }
        this.debug.println(this.debugID, "ext ref:", string);
        String string2 = this.loader.getKey(string);
        if (this.cache.containsKey(string2)) {
            this.debug.println(this.debugID, "cache hit");
            this.show(string2);
            return;
        }
        this.debug.println(this.debugID, "cache miss");
        new Thread(new Runnable(this, string2){
            final /* synthetic */ HTMLStack this$0;
            final /* synthetic */ String val$key;

            public final void run() {
                HTMLStack.access$3(this.this$0).loadExternal(this.val$key);
            }
            {
                this.this$0 = hTMLStack;
                this.val$key = string;
            }
        }).start();
    }

    static /* synthetic */ void access$0(HTMLStack hTMLStack, URL uRL) {
        hTMLStack.load(uRL);
    }

    static /* synthetic */ void access$1(HTMLStack hTMLStack, WScrollPane wScrollPane) {
        hTMLStack.replace(wScrollPane);
    }

    static /* synthetic */ HTMLPane access$2(HTMLStack hTMLStack) {
        return hTMLStack.current;
    }

    static /* synthetic */ HTMLLoader access$3(HTMLStack hTMLStack) {
        return hTMLStack.loader;
    }

    public HTMLStack(HTMLLoader hTMLLoader, Debug debug, int n) throws IllegalArgumentException {
        super(new BorderLayout());
        if (debug == null) {
            throw new IllegalArgumentException("You must supply a valid Debug instance");
        }
        this.cache = new HashMap();
        this.loader = hTMLLoader;
        this.debug = debug;
        this.debugID = n;
        this.scrollBorder = new JScrollPane().getBorder();
    }

    public HTMLStack(HTMLLoader hTMLLoader, HTMLNavigationListener hTMLNavigationListener, Debug debug, int n) throws IllegalArgumentException {
        this(hTMLLoader, debug, n);
        this.navListener = hTMLNavigationListener;
    }
}

