/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.wlib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Hashtable;
import net.dialang.client.wlib.WPanel;

public class ManagedContainer
extends WPanel {
    static final GridBagConstraints packedConstraints = new GridBagConstraints();
    private Hashtable locks = new Hashtable();
    private Hashtable packs = new Hashtable();

    public void addLocked(Component component, Object object) {
        this.locks.put(component, object);
        super.add(component);
    }

    public void addLocked(Component component, Object object, int n) {
        this.locks.put(component, object);
        super.add(component, n);
    }

    public void addPacked(Component component) {
        WPanel wPanel = new WPanel(new GridBagLayout());
        wPanel.add(component, packedConstraints);
        this.packs.put(component, wPanel);
        this.add((Component)wPanel, "Center");
    }

    public void removeLocked(Component component, Object object) {
        Object v = this.locks.get(component);
        if (v == object) {
            this.locks.remove(component);
            super.remove(component);
        }
    }

    public void remove(Component component) {
        Component component2 = (Component)this.packs.get(component);
        if (component2 != null) {
            this.packs.remove(component);
            component = component2;
        }
        if (this.locks.containsKey(component)) {
            throw new RuntimeException("ManagedComponent: attempt to remove locked component without key");
        }
        super.remove(component);
    }

    public void removeAll() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (!this.locks.containsKey(componentArray[n])) {
                super.remove(componentArray[n]);
            }
            ++n;
        }
    }

    public void replace(Component component) {
        this.removeAll();
        super.add(component, "Center");
    }

    public ManagedContainer() {
        this(new BorderLayout());
    }

    public ManagedContainer(LayoutManager layoutManager) {
        super(layoutManager);
    }

    static {
        ManagedContainer.packedConstraints.weightx = 1.0;
        ManagedContainer.packedConstraints.weighty = 1.0;
        ManagedContainer.packedConstraints.gridx = 0;
        ManagedContainer.packedConstraints.gridy = 0;
        ManagedContainer.packedConstraints.anchor = 10;
        ManagedContainer.packedConstraints.fill = 0;
    }
}

