/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.wlib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import net.dialang.client.widget.InvalidPropertyException;
import net.dialang.client.widget.InvalidValueException;
import net.dialang.client.widget.WComponent;
import net.dialang.client.widget.Widget;
import net.dialang.client.wlib.WDefaults;
import net.dialang.client.wlib.WScrollPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PrintPane
extends JPanel
implements WComponent,
WDefaults {
    protected static SimpleAttributeSet defAttrSet = new SimpleAttributeSet();
    protected JTextPane text;
    protected WScrollPane scroll;
    protected Widget widget;
    protected String errorText;
    protected String[] properties;

    public Widget getWidget() {
        return this.widget;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperty(String string, String string2) throws InvalidPropertyException, InvalidValueException {
        if (string == null) {
            return;
        }
        if (string.equals("opaque")) {
            this.setOpaque(Boolean.valueOf(string2));
            return;
        }
        if (string.equals("background")) {
            this.setBackground(Color.decode(string2));
            return;
        }
        throw new InvalidPropertyException(string);
    }

    public PrintStream getPrintStream() {
        TextOutputStream textOutputStream = new TextOutputStream(this);
        return new PrintStream(textOutputStream, false);
    }

    public PrintStream getPrintStream(Color color) {
        TextOutputStream textOutputStream = new TextOutputStream(this, color);
        return new PrintStream(textOutputStream, false);
    }

    public PrintStream getPrintStream(AttributeSet attributeSet) {
        TextOutputStream textOutputStream = new TextOutputStream(this, attributeSet);
        return new PrintStream(textOutputStream, false);
    }

    public PrintWriter getPrintWriter() {
        return new PrintWriter(new TextOutputStream(this), false);
    }

    public PrintWriter getPrintWriter(Color color) {
        TextOutputStream textOutputStream = new TextOutputStream(this, color);
        return new PrintWriter(textOutputStream, false);
    }

    public PrintWriter getPrintWriter(AttributeSet attributeSet) {
        TextOutputStream textOutputStream = new TextOutputStream(this, attributeSet);
        return new PrintWriter(textOutputStream, false);
    }

    protected void write(String string, AttributeSet attributeSet) {
        SwingUtilities.invokeLater(new Runnable(this, string, attributeSet){
            final /* synthetic */ PrintPane this$0;
            final /* synthetic */ String val$s;
            final /* synthetic */ AttributeSet val$attr;

            public final void run() {
                Document document = this.this$0.text.getDocument();
                try {
                    document.insertString(document.getLength(), this.val$s, this.val$attr);
                }
                catch (BadLocationException badLocationException) {
                    this.this$0.errorText = badLocationException.getMessage();
                }
            }
            {
                this.this$0 = printPane;
                this.val$s = string;
                this.val$attr = attributeSet;
            }
        });
    }

    private final String getError() {
        return this.errorText;
    }

    public SimpleAttributeSet getDefaultAttributes() {
        return new SimpleAttributeSet(defAttrSet);
    }

    public void setDefaultAttributes(SimpleAttributeSet simpleAttributeSet) {
        defAttrSet = simpleAttributeSet;
    }

    private final /* synthetic */ void this() {
        this.errorText = null;
        this.properties = new String[]{"opaque", "background"};
    }

    public PrintPane() {
        this(true);
    }

    public PrintPane(boolean bl) {
        super(new BorderLayout());
        this.this();
        this.widget = new Widget(this);
        this.setOpaque(false);
        this.text = new JTextPane(this){
            final /* synthetic */ PrintPane this$0;

            public final boolean getScrollableTracksViewportWidth() {
                return true;
            }
            {
                this.this$0 = printPane;
            }
        };
        this.text.setOpaque(false);
        this.text.setEditable(false);
        this.text.setEnabled(false);
        this.text.setHighlighter(null);
        this.text.setAutoscrolls(true);
        if (bl) {
            this.scroll = new WScrollPane(this.text, 22, 31);
            this.scroll.setPreferredSize(this.scroll.getMaximumSize());
            this.scroll.getVerticalScrollBar().setUnitIncrement(20);
            this.scroll.setBorder(null);
            this.add((Component)this.scroll, "Center");
        } else {
            this.text.setPreferredSize(this.text.getMaximumSize());
            this.add((Component)this.text, "Center");
        }
    }

    static {
        StyleConstants.setForeground(defAttrSet, Color.black);
        StyleConstants.setFontFamily(defAttrSet, "SansSerif");
        StyleConstants.setFontSize(defAttrSet, 14);
        StyleConstants.setBold(defAttrSet, true);
        TabStop tabStop = new TabStop(100.0f, 0, 0);
        TabSet tabSet = new TabSet(new TabStop[]{tabStop});
        StyleConstants.setTabSet(defAttrSet, tabSet);
    }

    private class TextOutputStream
    extends OutputStream {
        private PrintPane pp;
        private StringBuffer sb;
        private SimpleAttributeSet attrSet;

        public void close() {
        }

        public void flush() throws IOException {
            String string = this.pp.getError();
            if (string != null) {
                throw new IOException(string);
            }
            this.pp.write(this.sb.toString(), this.attrSet);
            this.sb.setLength(0);
        }

        public void write(byte[] byArray) throws IOException {
            this.sb.append(new String(byArray));
            if (this.sb.charAt(this.sb.length() - 1) == '\n') {
                this.flush();
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.sb.append(new String(byArray, n, n2));
            if (this.sb.charAt(this.sb.length() - 1) == '\n') {
                this.flush();
            }
        }

        public void write(int n) throws IOException {
            this.sb.append(String.valueOf(n));
            if (this.sb.charAt(this.sb.length() - 1) == '\n') {
                this.flush();
            }
        }

        public TextOutputStream(PrintPane printPane2) {
            this(printPane2, new SimpleAttributeSet(defAttrSet));
        }

        public TextOutputStream(PrintPane printPane2, Color color) {
            this(printPane2, new SimpleAttributeSet(defAttrSet));
            StyleConstants.setForeground(this.attrSet, color);
        }

        public TextOutputStream(PrintPane printPane2, AttributeSet attributeSet) {
            this.pp = printPane2;
            this.attrSet = (SimpleAttributeSet)attributeSet;
            this.sb = new StringBuffer();
        }
    }
}

