/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.common;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import net.dialang.entity.ALS;
import net.dialang.entity.Skill;
import net.dialang.entity.TLS;

public class SAMap
implements Serializable {
    long created = System.currentTimeMillis();
    private HashMap stats = new HashMap();
    private HashMap weights = new HashMap();
    private boolean locked;
    private int maxSize;

    public boolean isSA(ALS aLS, Skill skill) {
        boolean bl = false;
        if (this.getSASize(aLS, skill) != 0) {
            bl = true;
        }
        return bl;
    }

    public int getSASize(ALS aLS, Skill skill) {
        String string = aLS.getVocabSubKey();
        String string2 = skill.getVocabSubKey();
        return this.getSASize(string, string2);
    }

    public int getSASize(String string, String string2) {
        HashMap hashMap = (HashMap)this.stats.get(string);
        if (hashMap == null) {
            return 0;
        }
        Integer n = (Integer)hashMap.get(string2);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void addSASet(String string, String string2, int n) throws IllegalAccessException {
        if (this.locked) {
            throw new IllegalAccessException("is locked");
        }
        HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this.stats.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Integer>();
            this.stats.put(string, hashMap);
        }
        hashMap.put(string2, new Integer(n));
        this.maxSize = Math.max(this.maxSize, n);
    }

    public Iterator getStatementSkills(String string) {
        HashMap hashMap = (HashMap)this.stats.get(string);
        if (hashMap == null) {
            return null;
        }
        return hashMap.keySet().iterator();
    }

    public Iterator getStatementLanguages() {
        return this.stats.keySet().iterator();
    }

    public boolean isSAWeight(TLS tLS, Skill skill) {
        return this.isSAWeight(tLS.getVocabSubKey(), skill.getVocabSubKey());
    }

    public boolean isSAWeight(String string, String string2) {
        HashMap hashMap = (HashMap)this.weights.get(string);
        if (hashMap == null) {
            return false;
        }
        return hashMap.containsKey(string2);
    }

    public void addSAWeight(String string, String string2) throws IllegalAccessException {
        if (this.locked) {
            throw new IllegalAccessException("is locked");
        }
        HashMap<String, Object> hashMap = (HashMap<String, Object>)this.weights.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            this.weights.put(string, hashMap);
        }
        hashMap.put(string2, null);
    }

    public Iterator getWeightSkills(String string) {
        HashMap hashMap = (HashMap)this.weights.get(string);
        if (hashMap == null) {
            return null;
        }
        return hashMap.keySet().iterator();
    }

    public Iterator getWeightLanguages() {
        return this.weights.keySet().iterator();
    }

    public long getCreated() {
        return this.created;
    }

    public void lock() {
        this.locked = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SAMap created ");
        stringBuffer.append(new Date(this.getCreated()));
        stringBuffer.append('\n');
        stringBuffer.append('\n');
        stringBuffer.append(this.statsToString());
        stringBuffer.append('\n');
        stringBuffer.append(this.weightsToString());
        return stringBuffer.toString();
    }

    private final String statsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Statements\n");
        boolean bl = true;
        Iterator iterator = this.stats.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Iterator iterator2;
            String string2 = (String)iterator.next();
            HashMap hashMap = (HashMap)this.stats.get(string2);
            if (bl) {
                iterator2 = hashMap.keySet().iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    stringBuffer.append('\t');
                    stringBuffer.append(string);
                }
                stringBuffer.append('\n');
                bl = false;
            }
            stringBuffer.append(string2);
            iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                Integer n = (Integer)hashMap.get(string);
                stringBuffer.append('\t');
                stringBuffer.append(n);
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append('\n');
        stringBuffer.append("Max statement size ");
        stringBuffer.append(this.getMaxSize());
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private final String weightsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Weights\n");
        Iterator iterator = this.weights.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append('\t');
            HashMap hashMap = (HashMap)this.stats.get(string);
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

