/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.dialang.entity.Skill;

public class SkillSet
implements Serializable,
Cloneable {
    private HashMap skills = new HashMap(5);
    private ArrayList menuOrder = new ArrayList(5);
    private boolean locked;

    public void add(Skill skill) throws IllegalAccessException {
        if (this.locked) {
            throw new IllegalAccessException("is locked");
        }
        this.skills.put(skill.getVocabSubKey(), skill);
        this.menuOrder.add(skill);
    }

    public void lock() {
        this.locked = true;
    }

    public Skill get(String string) {
        return (Skill)this.skills.get(string);
    }

    public boolean isEnabled() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            if (!skill.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.skills.size();
    }

    public Iterator iterator() {
        return this.skills.values().iterator();
    }

    public Iterator menu() {
        return this.menuOrder.iterator();
    }

    public Object clone() {
        SkillSet skillSet = new SkillSet();
        Iterator iterator = this.menu();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            try {
                skillSet.add((Skill)skill.clone());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        skillSet.lock();
        return skillSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("skill set ");
        stringBuffer.append(this.skills.size());
        stringBuffer.append(" enabled ");
        stringBuffer.append(this.isEnabled());
        stringBuffer.append('\n');
        Iterator iterator = this.menu();
        while (iterator.hasNext()) {
            stringBuffer.append(((Skill)iterator.next()).toString());
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

