/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.common.cat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.dialang.common.cat.CATLogger;
import net.dialang.common.cat.COETarget;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CATControl {
    private int minBaskets;
    private int maxBaskets;
    private double standardError;
    private ArrayList targets;
    private CATLogger logger;

    private final void loadFromDB(String string, String string2, Connection connection) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT a.* from ADAPTIVITY_CRITERIA a,V1_SKILL_LOOKUP b where iso_lang_code = '" + string + "' and skill_name = '" + string2 + "' AND a.skill_id = b.skill_id");
        if (!resultSet.next()) {
            resultSet.close();
            statement.close();
            throw new Exception("No adaptivity criteria rows returned.");
        }
        this.minBaskets = resultSet.getInt("min_items");
        this.maxBaskets = resultSet.getInt("max_items");
        this.standardError = resultSet.getDouble("acceptable_se");
        resultSet.close();
        resultSet = statement.executeQuery("SELECT skill_id FROM V1_SKILL_LOOKUP where skill_name = '" + string2 + '\'');
        if (!resultSet.next()) {
            resultSet.close();
            statement.close();
            throw new Exception("Failed to lookup skill id for name " + string2);
        }
        String string3 = resultSet.getString("skill_id");
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * from COE_LEVEL_CUT_SCORE where iso_lang_code = '" + string + "' and skill_id = '" + string3 + '\'');
        while (resultSet.next()) {
            String string4 = resultSet.getString("coe_level");
            double d = Double.NEGATIVE_INFINITY;
            String string5 = resultSet.getString("bottom");
            if (string5 != null) {
                d = Double.parseDouble(string5);
            }
            double d2 = Double.POSITIVE_INFINITY;
            String string6 = resultSet.getString("top");
            if (string6 != null) {
                d2 = Double.parseDouble(string6);
            }
            COETarget cOETarget = new COETarget(d, d2, string4);
            this.targets.add(cOETarget);
        }
        resultSet.close();
        statement.close();
    }

    public Iterator targetIterator() {
        return this.targets.iterator();
    }

    public double[][] getTargetArray() {
        int n = this.targets.size();
        double[][] dArray = new double[n][2];
        int n2 = 0;
        while (n2 < n) {
            COETarget cOETarget = (COETarget)this.targets.get(n2);
            dArray[n2][0] = cOETarget.bottom;
            dArray[n2][1] = cOETarget.top;
            ++n2;
        }
        return dArray;
    }

    public int getMinimumItems() {
        return this.minBaskets;
    }

    public void setMinimumBaskets(int n) {
        this.minBaskets = n;
    }

    public int getMaximumBaskets() {
        return this.maxBaskets;
    }

    public void setMaximumBaskets(int n) {
        this.maxBaskets = n;
    }

    public double getAcceptableStandardError() {
        return this.standardError;
    }

    public void setAcceptableStandardError(double d) {
        this.standardError = d;
    }

    public void dump(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        printWriter.println("<cat_control>");
        printWriter.print("\t<run_criteria min_item=\"");
        printWriter.print(Integer.toString(this.minBaskets));
        printWriter.println("\"/>");
        printWriter.print("\t<stop_criteria se=\"");
        printWriter.print(Double.toString(this.standardError));
        printWriter.print("\" max_item=\"");
        printWriter.print(Integer.toString(this.maxBaskets));
        printWriter.println("\">");
        Iterator iterator = this.targets.iterator();
        while (iterator.hasNext()) {
            COETarget cOETarget = (COETarget)iterator.next();
            cOETarget.dump(outputStream);
        }
        printWriter.println("\t</stop_criteria>");
        printWriter.print("</cat_control>");
        printWriter.close();
    }

    static /* synthetic */ int access$0(CATControl cATControl) {
        return cATControl.minBaskets;
    }

    static /* synthetic */ double access$2(CATControl cATControl) {
        return cATControl.standardError;
    }

    static /* synthetic */ int access$4(CATControl cATControl) {
        return cATControl.maxBaskets;
    }

    private final /* synthetic */ void this() {
        this.targets = new ArrayList(6);
    }

    public CATControl(CATLogger cATLogger) {
        this.this();
        this.logger = cATLogger;
    }

    public CATControl(Connection connection, String string, String string2, CATLogger cATLogger) throws Exception {
        this.this();
        this.logger = cATLogger;
        this.loadFromDB(string, string2, connection);
    }

    public CATControl(File file, CATLogger cATLogger) throws Exception {
        this(new FileInputStream(file), cATLogger);
    }

    public CATControl(InputStream inputStream, CATLogger cATLogger) throws Exception {
        this.this();
        this.logger = cATLogger;
        this.logger.catLog("Creating SAXParserFactory instance ...");
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        this.logger.catLog("SAXParserFactory instance created.");
        this.logger.catLog("Parsing stream ...");
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)new CATControlHandler());
        this.logger.catLog("Stream parsed.");
    }

    private class CATControlHandler
    extends DefaultHandler {
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("run_criteria")) {
                String string4 = attributes.getValue("min_item");
                if (string4 == null || string4.length() == 0) {
                    throw new SAXException("Minimum items not specified");
                }
                CATControl.this.minBaskets = Integer.parseInt(string4);
            } else if (string3.equals("stop_criteria")) {
                String string5 = attributes.getValue("se");
                if (string5 == null || string5.length() == 0) {
                    throw new SAXException("Acceptable standard error not specified.");
                }
                CATControl.this.standardError = Double.parseDouble(string5);
                String string6 = attributes.getValue("max_item");
                if (string6 == null || string6.length() == 0) {
                    throw new SAXException("Maximum item limit not specified.");
                }
                CATControl.this.maxBaskets = Integer.parseInt(string6);
            } else if (string3.equals("target")) {
                String string7;
                String string8 = attributes.getValue("bottom");
                double d = Double.NEGATIVE_INFINITY;
                if (string8 != null && string8.length() > 0) {
                    d = Double.parseDouble(string8);
                }
                String string9 = attributes.getValue("top");
                double d2 = Double.POSITIVE_INFINITY;
                if (string9 != null && string9.length() > 0) {
                    d2 = Double.parseDouble(string9);
                }
                if ((string7 = attributes.getValue("coe_level")) == null || string7.length() == 0) {
                    throw new SAXException("COE level not specified.");
                }
                COETarget cOETarget = new COETarget(d, d2, string7);
                CATControl.this.targets.add(cOETarget);
            }
        }

        private CATControlHandler() {
        }
    }
}

