/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.common.cat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import net.dialang.client.model.BasketList;
import net.dialang.common.Item;
import net.dialang.common.cat.CATControl;
import net.dialang.common.cat.CATEngine;
import net.dialang.common.cat.CATListener;
import net.dialang.common.cat.CATLogger;
import net.dialang.common.cat.COETarget;
import net.dialang.common.cat.IRTFunctions;
import net.dialang.common.cat.InformationTable;
import net.dialang.common.cat.ParameterTable;
import net.dialang.common.cat.Result;
import net.dialang.common.cat.ThetaEvent;

public class CATEngine {
    private static final boolean graphingEnabled = false;
    private Vector catListeners = new Vector(5);
    private ParameterTable parameterTable;
    private CATControl catControl;
    private InformationTable informationTable;
    private ArrayList exposedItems;
    private ArrayList exposedBaskets;
    private double thetaEst = 0.0;
    private CATLogger logger;
    private BasketList precacheList = new BasketList(10);

    public void addCATListener(CATListener cATListener) {
        if (this.catListeners.contains(cATListener)) {
            return;
        }
        this.catListeners.add(cATListener);
    }

    public void setupCriteria(File file) throws Exception {
        this.setupCriteria(new FileInputStream(file));
    }

    public void setMaximumBaskets(int n) {
        this.catControl.setMaximumBaskets(n);
    }

    public void setupCriteria(InputStream inputStream) throws Exception {
        this.catControl = new CATControl(inputStream, this.logger);
    }

    public int getMaximumBaskets() {
        return this.catControl.getMaximumBaskets();
    }

    public int getCOELevel() {
        int n = 1;
        Iterator iterator = this.catControl.targetIterator();
        while (iterator.hasNext()) {
            COETarget cOETarget = (COETarget)iterator.next();
            if (!(this.thetaEst > cOETarget.top)) break;
            ++n;
        }
        return n;
    }

    public synchronized void setCurrentAbilityEstimate(double d) {
        this.thetaEst = d;
        this.logger.catLog("Current ability estimate set to " + Double.toString(this.thetaEst));
    }

    public synchronized double calculateCorrectProbability(String string, double d) {
        ParameterTable.ParamSet paramSet = this.parameterTable.get(string);
        return IRTFunctions.calculateCorrectProbability(d, paramSet.alpha, paramSet.beta);
    }

    private final double calculateTheta() throws Exception {
        Object object;
        Object object2;
        int[] nArray = new int[this.exposedItems.size()];
        this.logger.catLog("Building array of exposed item marks to date ...");
        int n = 0;
        ParameterTable.ParamSet[] paramSetArray = ((AbstractList)this.exposedItems).iterator();
        while (paramSetArray.hasNext()) {
            object2 = (ExposedItem)paramSetArray.next();
            int n2 = nArray[n++] = ((ExposedItem)object2).getMark() ? 1 : 0;
        }
        this.logger.catLog("Done.");
        this.logger.catLog("Getting the parameters of all the exposed items ...");
        paramSetArray = this.getExposedParams();
        this.logger.catLog(Integer.toString(paramSetArray.length) + " sets of params retrieved.");
        object2 = new int[nArray.length];
        double[] dArray = new double[nArray.length];
        this.logger.catLog("Splitting the exposed parameters into separate arrays of alphas and betas ...");
        int n3 = 0;
        while (n3 < paramSetArray.length) {
            object = paramSetArray[n3];
            object2[n3] = ((ParameterTable.ParamSet)object).alpha;
            dArray[n3] = ((ParameterTable.ParamSet)object).beta;
            ++n3;
        }
        this.logger.catLog("Exposed parameters split.");
        this.logger.catLog("Attempting to converge  on the new theta estimate ...");
        double[][] dArray2 = this.catControl.getTargetArray();
        object = new IRTFunctions().converge(this.thetaEst, (int[])object2, dArray, nArray, 60, dArray2, this.logger);
        this.logger.catLog("Done.");
        double d = ((Result)object).getTheta();
        double d2 = ((Result)object).getSE();
        Iterator iterator = ((AbstractList)this.catListeners).iterator();
        while (iterator.hasNext()) {
            ((CATListener)iterator.next()).thetaCalculated(new ThetaEvent(d, d2));
        }
        this.logger.catLog("Theta = " + Double.toString(d) + ". Standard Error = " + Double.toString(d2));
        return ((Result)object).getTheta();
    }

    public synchronized void dumpInformation(OutputStream outputStream) throws IOException {
        this.informationTable.dump(outputStream);
    }

    public synchronized void dumpParameters(OutputStream outputStream) throws IOException {
        this.parameterTable.dump(outputStream);
    }

    public synchronized double itemExposed(Item item, String string) throws Exception {
        String string2 = Integer.toString(item.getID());
        CATEngine cATEngine = this;
        if (cATEngine == null) {
            throw null;
        }
        ExposedItem exposedItem = cATEngine.new ExposedItem(null, item, this.thetaEst);
        if (this.exposedItems.contains(exposedItem)) {
            String string3 = "Item " + string2 + " marked as having been exposed already.";
            this.logger.catLog(string3);
            throw new Exception(string3);
        }
        this.logger.catLog("Adding item " + string2 + " to exposed list ...");
        this.exposedItems.add(exposedItem);
        if (!this.exposedBaskets.contains(string)) {
            this.exposedBaskets.add(string);
        }
        this.logger.catLog("Item added.");
        try {
            this.logger.catLog("Calculating new theta estimate ...");
            this.thetaEst = this.calculateTheta();
            this.logger.catLog("New estimated theta: " + Double.toString(this.thetaEst));
        }
        catch (Exception exception) {
            this.logger.catLog("Exception caught whilst calculating new theta estimate. Message: " + exception.getMessage());
            this.logger.catLog("Previous theta estimate will be returned.");
        }
        this.logger.catLog("Building precache list ...");
        this.buildPrecacheList();
        this.logger.catLog("Precache list built.");
        return this.thetaEst;
    }

    public double getCurrentThetaEstimate() {
        return this.thetaEst;
    }

    public synchronized BasketList getPrecacheList() {
        return this.precacheList;
    }

    private void buildPrecacheList() {
        Double d;
        this.precacheList.clear();
        Double d2 = null;
        double d3 = Double.MAX_VALUE;
        Double[] doubleArray = new Double[this.informationTable.size()];
        doubleArray = this.informationTable.keySet().toArray(doubleArray);
        this.logger.catLog("Building list of theta branches ...");
        ArrayList<Double> arrayList = new ArrayList<Double>(5);
        this.logger.catLog("Done.");
        int n = 0;
        while (n < doubleArray.length) {
            d = doubleArray[n];
            double d4 = d;
            double d5 = StrictMath.abs(this.thetaEst - d4);
            if (d5 < d3) {
                d3 = d5;
                d2 = d;
            }
            ++n;
        }
        arrayList.add(d2);
        n = 0;
        while (n < doubleArray.length) {
            if (doubleArray[n].equals(d2)) {
                int n2;
                int n3 = n - 1;
                if (n3 >= 0) {
                    arrayList.add(doubleArray[n3]);
                }
                if ((n3 = n - 2) >= 0) {
                    arrayList.add(doubleArray[n3]);
                }
                if ((n2 = n + 1) < doubleArray.length) {
                    arrayList.add(doubleArray[n2]);
                }
                if ((n2 = n + 2) < doubleArray.length) {
                    arrayList.add(doubleArray[n2]);
                }
            }
            ++n;
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            ArrayList arrayList2 = this.informationTable.get(d);
            int n4 = 0;
            Iterator iterator2 = ((AbstractList)arrayList2).iterator();
            while (iterator2.hasNext()) {
                InformationTable.BasketInfo basketInfo = (InformationTable.BasketInfo)iterator2.next();
                boolean bl = false;
                Iterator iterator3 = ((AbstractList)this.exposedBaskets).iterator();
                while (iterator3.hasNext()) {
                    String string = (String)iterator3.next();
                    if (!basketInfo.id.equals(string)) continue;
                    bl = true;
                }
                if (bl || n4 >= 2) continue;
                this.precacheList.add(basketInfo.id);
                ++n4;
            }
        }
    }

    protected void setLogger(CATLogger cATLogger) {
        this.logger = cATLogger;
    }

    public final synchronized String getBestBasket() {
        Serializable serializable;
        if (this.exposedBaskets.size() == this.catControl.getMaximumBaskets()) {
            return null;
        }
        Serializable serializable2 = null;
        double d = Double.MAX_VALUE;
        Iterator iterator = this.informationTable.keySet().iterator();
        while (iterator.hasNext()) {
            serializable = (Double)iterator.next();
            double d2 = (Double)serializable;
            double d3 = StrictMath.abs(this.thetaEst - d2);
            if (!(d3 < d)) continue;
            d = d3;
            serializable2 = serializable;
        }
        serializable = this.informationTable.get((Double)serializable2);
        Iterator iterator2 = ((AbstractList)((Object)serializable)).iterator();
        while (iterator2.hasNext()) {
            InformationTable.BasketInfo basketInfo = (InformationTable.BasketInfo)iterator2.next();
            boolean bl = false;
            Iterator iterator3 = ((AbstractList)this.exposedBaskets).iterator();
            while (iterator3.hasNext()) {
                String string = (String)iterator3.next();
                if (!basketInfo.id.equals(string)) continue;
                bl = true;
            }
            if (bl) continue;
            this.logger.catLog("Returning best basket: " + basketInfo.id);
            return basketInfo.id;
        }
        return null;
    }

    private ParameterTable.ParamSet[] getExposedParams() throws Exception {
        this.logger.catLog(this.exposedItems == null ? "Exposed list null" : "Exposed list OK");
        ParameterTable.ParamSet[] paramSetArray = new ParameterTable.ParamSet[this.exposedItems.size()];
        int n = 0;
        Iterator iterator = ((AbstractList)this.exposedItems).iterator();
        while (iterator.hasNext()) {
            ExposedItem exposedItem = (ExposedItem)iterator.next();
            String string = exposedItem.getID();
            this.logger.catLog("Getting parameters for item " + string + " ...");
            ParameterTable.ParamSet paramSet = this.parameterTable.get(string);
            if (paramSet == null) {
                throw new Exception("No parameters available for item: " + string);
            }
            this.logger.catLog("Parameters retrieved.");
            paramSetArray[n++] = paramSet;
        }
        return paramSetArray;
    }

    public CATEngine(File file, File file2, CATLogger cATLogger) throws Exception {
        this(new GZIPInputStream(new FileInputStream(file)), new GZIPInputStream(new FileInputStream(file2)), cATLogger);
    }

    public CATEngine(InputStream inputStream, InputStream inputStream2, CATLogger cATLogger) throws Exception {
        this.logger = cATLogger;
        this.logger.catLog("Building parameter table ...");
        this.parameterTable = new ParameterTable(inputStream, cATLogger);
        this.logger.catLog("Parameter table built.");
        int n = this.parameterTable.size();
        this.logger.catLog("Initialising the exposed list with " + Integer.toString(n) + " elements");
        this.exposedItems = new ArrayList(n);
        this.logger.catLog("Building information table ...");
        this.informationTable = new InformationTable(inputStream2);
        this.logger.catLog("Information table built.");
        this.exposedBaskets = new ArrayList(this.informationTable.size());
        this.logger.catLog("Building precache list ...");
        this.buildPrecacheList();
        this.logger.catLog("Precache list built.");
    }

    private class ExposedItem {
        private Item item;
        private boolean mark;
        public double resultingTheta;

        public String getID() {
            return Integer.toString(this.item.getID());
        }

        public boolean getMark() {
            return this.item.getCorrect();
        }

        public String toString() {
            return new String("Item: " + this.item.getID() + ". Mark: " + (this.getMark() ? "1" : "0") + ". Resulting Theta: " + Double.toString(this.resultingTheta));
        }

        private ExposedItem(Item item, double d) {
            this.item = item;
            this.resultingTheta = d;
        }

        /* synthetic */ ExposedItem(1 var2_2, Item item, double d) {
            this(item, d);
        }
    }
}

