/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.common.cat;

import net.dialang.common.cat.CATLogger;
import net.dialang.common.cat.Result;

public class IRTFunctions {
    public static final float getItemInformation(double d, double d2, double d3) {
        double d4 = IRTFunctions.calculateCorrectProbability(d, d2, d3);
        double d5 = StrictMath.pow(d2, 2.0) * d4 * (1.0 - d4);
        return (float)d5;
    }

    public static final double calculateCorrectProbability(double d, double d2, double d3) {
        double d4 = StrictMath.exp(d2 * (d - d3)) / (1.0 + StrictMath.exp(d2 * (d - d3)));
        return d4;
    }

    public static final Result calculateTheta(double d, int[] nArray, double[] dArray, int[] nArray2) throws Exception {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n = 0;
        while (n < nArray2.length) {
            double d8 = nArray[n];
            double d9 = dArray[n];
            double d10 = nArray2[n];
            double d11 = IRTFunctions.calculateCorrectProbability(d, d8, d9);
            d2 += StrictMath.pow(d8, 3.0) * d11 * (1.0 - d11) * (1.0 - 2.0 * d11);
            d3 += StrictMath.pow(d8, 2.0) * d11 * (1.0 - d11);
            d4 += d8 * (d10 - d11);
            d6 += StrictMath.pow(d8, 4.0) * (1.0 - 6.0 * d11 + 6.0 * StrictMath.pow(d11, 2.0)) * d11 * (1.0 - d11);
            d7 += d8 * d11 * (1.0 - d11);
            ++n;
        }
        double d12 = 0.5 * (d6 / d3 - StrictMath.pow(d2 / d3, 2.0)) - d3;
        if (d12 == 0.0) {
            throw new Exception("Stop criterion 4 reached (F'(x) = 0). Stopping.");
        }
        double d13 = 0.5 * (d2 / d3) + d4;
        double d14 = d - d13 / d12;
        double d15 = 1.0 / StrictMath.sqrt(d7);
        Result result = new Result(d14, d15);
        return result;
    }

    private final Result calculateTheta(double d, int[] nArray, double[] dArray, int[] nArray2, int n, int n2, double[][] dArray2, CATLogger cATLogger) throws Exception {
        if (n >= n2) {
            throw new Exception("Stop criterion 3 reached (" + Integer.toString(n2) + " iteration limit). Stopping.");
        }
        Result result = IRTFunctions.calculateTheta(d, nArray, dArray, nArray2);
        double d2 = StrictMath.abs(result.getTheta() - d);
        if (d2 < 1.0E-5) {
            return result;
        }
        double d3 = result.getSE();
        if (IRTFunctions.targetHit(result.getTheta(), result.getSE(), dArray2)) {
            return result;
        }
        this.calculateTheta(result.getTheta(), nArray, dArray, nArray2, ++n, n2, dArray2, cATLogger);
        return result;
    }

    private static final boolean targetHit(double d, double d2, double[][] dArray) {
        return dArray != null;
    }

    public final Result converge(double d, int[] nArray, double[] dArray, int[] nArray2, int n, double[][] dArray2, CATLogger cATLogger) {
        try {
            return this.calculateTheta(d, nArray, dArray, nArray2, 1, n, dArray2, cATLogger);
        }
        catch (Exception exception) {
            cATLogger.catLog(exception.getMessage());
            return new Result(d, 0.0);
        }
    }
}

