/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.common.cat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.dialang.common.cat.InformationTable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class InformationTable {
    private int rows;
    private int columns;
    private HashMap table;

    public ArrayList get(Double d) {
        return (ArrayList)this.table.get(d);
    }

    public final Set keySet() {
        return this.table.keySet();
    }

    public final void addRow(double d) {
        ArrayList arrayList = new ArrayList(this.columns);
        this.table.put(new Double(d), arrayList);
    }

    public final void addRow(double d, ArrayList arrayList) {
    }

    public final int size() {
        return this.table.size();
    }

    public final void addColumn(double d, String string, double d2) {
        ArrayList arrayList = (ArrayList)this.table.get(new Double(d));
        InformationTable informationTable = this;
        if (informationTable == null) {
            throw null;
        }
        BasketInfo basketInfo = informationTable.new BasketInfo(null, string, d, d2);
        if (arrayList.size() == 0) {
            arrayList.add(basketInfo);
            return;
        }
        Object[] objectArray = arrayList.toArray();
        int n = 0;
        while (n < objectArray.length) {
            BasketInfo basketInfo2 = (BasketInfo)objectArray[n];
            if (basketInfo.info > basketInfo2.info) {
                arrayList.add(n, basketInfo);
                return;
            }
            ++n;
        }
        arrayList.add(basketInfo);
    }

    public final void dump(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        printWriter.println("<information_table thetas=\"" + Integer.toString(this.table.size()) + "\" baskets=\"" + Integer.toString(this.columns) + "\">");
        TreeMap treeMap = new TreeMap(this.table);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Double d = (Double)iterator.next();
            printWriter.println("\t<theta value=\"" + d.toString() + "\">");
            ArrayList arrayList = (ArrayList)treeMap.get(d);
            Iterator iterator2 = ((AbstractList)arrayList).iterator();
            while (iterator2.hasNext()) {
                BasketInfo basketInfo = (BasketInfo)iterator2.next();
                printWriter.println(basketInfo);
            }
            printWriter.println("\t</theta>");
        }
        printWriter.println("</information_table>");
    }

    static /* synthetic */ int access$2(InformationTable informationTable) {
        return informationTable.columns;
    }

    static /* synthetic */ HashMap access$4(InformationTable informationTable) {
        return informationTable.table;
    }

    public InformationTable(int n, int n2) {
        this.rows = n;
        this.columns = n2;
        this.table = new HashMap(this.rows);
    }

    public InformationTable(File file) throws Exception {
        this(new GZIPInputStream(new FileInputStream(file)));
    }

    public InformationTable(InputStream inputStream) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        InformationTable informationTable = this;
        if (informationTable == null) {
            throw null;
        }
        sAXParser.parse(inputStream, (DefaultHandler)informationTable.new InformationTableHandler());
    }

    private class InformationTableHandler
    extends DefaultHandler {
        private static final String NEGATIVE_INFINITY_TEXT = Double.toString(Double.NEGATIVE_INFINITY);

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("information_table")) {
                InformationTable.this.rows = Integer.parseInt(attributes.getValue("thetas"));
                InformationTable.this.columns = Integer.parseInt(attributes.getValue("baskets"));
                InformationTable.this.table = new HashMap(InformationTable.this.rows);
            } else if (string3.equals("theta")) {
                InformationTable.this.addRow(Double.parseDouble(attributes.getValue("value")));
            } else if (string3.equals("basket")) {
                String string4 = attributes.getValue("id");
                string4 = Integer.toString(Integer.parseInt(string4));
                double d = Double.parseDouble(attributes.getValue("theta"));
                double d2 = Double.NEGATIVE_INFINITY;
                String string5 = attributes.getValue("info");
                if (!string5.equals(NEGATIVE_INFINITY_TEXT)) {
                    d2 = Double.parseDouble(string5);
                }
                InformationTable.this.addColumn(d, string4, d2);
            }
        }

        private InformationTableHandler() {
        }
    }

    final class BasketInfo {
        public String id;
        public double theta;
        public double info;

        public String toString() {
            return new String("\t\t<basket id=\"" + this.id + "\" theta=\"" + Double.toString(this.theta) + "\" info=\"" + Double.toString(this.info)) + "\"/>";
        }

        private BasketInfo(String string, double d, double d2) {
            this.id = string;
            this.theta = d;
            this.info = d2;
        }

        /* synthetic */ BasketInfo(2 var2_2, String string, double d, double d2) {
            this(string, d, d2);
        }
    }
}

