/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.common.cat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.dialang.common.cat.CATLogger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParameterTable {
    private HashMap table;
    private CATLogger logger;

    public final void addParamSet(String string, int n, double d) {
        ParameterTable parameterTable = this;
        if (parameterTable == null) {
            throw null;
        }
        this.table.put(string, parameterTable.new ParamSet(string, n, d));
    }

    public final void addRow(String string, int n, double d) {
        ParameterTable parameterTable = this;
        if (parameterTable == null) {
            throw null;
        }
        this.table.put(string, parameterTable.new ParamSet(string, n, d));
    }

    public final void addParamSet(String string, ParamSet paramSet) {
        this.table.put(string, paramSet);
    }

    public final int size() {
        return this.table.size();
    }

    public final Set keySet() {
        return this.table.keySet();
    }

    public final ParamSet get(String string) {
        return (ParamSet)this.table.get(string);
    }

    public void dump(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        printWriter.println("<parameter_table>");
        Iterator iterator = this.table.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ParamSet paramSet = (ParamSet)this.table.get(string);
            printWriter.println(paramSet.toString());
        }
        printWriter.println("</parameter_table>");
        printWriter.close();
    }

    public ParameterTable(int n, CATLogger cATLogger) {
        this.logger = cATLogger;
        this.table = new HashMap(n);
    }

    public ParameterTable(File file, CATLogger cATLogger) throws Exception {
        this(new FileInputStream(file), cATLogger);
    }

    public ParameterTable(InputStream inputStream, CATLogger cATLogger) throws Exception {
        this.logger = cATLogger;
        this.table = new HashMap(100);
        this.logger.catLog("Creating SAXParserFactory instance ...");
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        this.logger.catLog("SAXParserFactory instance created.");
        this.logger.catLog("Parsing stream ...");
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        ParameterTable parameterTable = this;
        if (parameterTable == null) {
            throw null;
        }
        sAXParser.parse(inputStream, (DefaultHandler)parameterTable.new ParameterTableHandler());
        this.logger.catLog("Stream parsed.");
    }

    private class ParameterTableHandler
    extends DefaultHandler {
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("item")) {
                String string4 = attributes.getValue("id");
                string4 = Integer.toString(Integer.parseInt(string4));
                int n = Integer.parseInt(attributes.getValue("alpha"));
                double d = Double.parseDouble(attributes.getValue("beta"));
                ParameterTable.this.addParamSet(string4, n, d);
            }
        }

        private ParameterTableHandler() {
        }
    }

    public class ParamSet {
        public String id;
        public int alpha;
        public double beta;

        public String toString() {
            return new String("\t<item id=\"" + this.id + "\" alpha=\"" + Integer.toString(this.alpha) + "\" beta=\"" + Double.toString(this.beta) + "\"/>");
        }

        public ParamSet(String string, int n, double d) {
            this.id = string;
            this.alpha = n;
            this.beta = d;
        }
    }
}

