/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.datacapture;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class ItemData {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private String sessionID;
    private String itemID;
    private String response;
    private int mark;
    private int order;

    public void setDataID(String string) throws Exception {
        if (string.length() > 6) {
            throw new Exception("Item ID too long (max 6 characters)");
        }
        this.itemID = string;
    }

    public void setResponse(String string) throws Exception {
        if (string.length() > 255) {
            throw new Exception("Item response too long (max 255 characters)");
        }
        this.response = string;
    }

    public void setMark(int n) throws Exception {
        if (n != 0 && n != 1) {
            throw new Exception("Item mark must be either 0 or 1");
        }
        this.mark = n;
    }

    public void setOrder(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Item ordering starts from 1");
        }
        this.order = n;
    }

    public void dump(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        printWriter.print(this.toString());
    }

    public String toString() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<item_data session_id=\"" + this.sessionID + "\" item_id=\"" + this.itemID + "\" response=\"" + this.response + "\" mark=\"" + Integer.toString(this.mark) + "\" order=\"" + Integer.toString(this.order) + "\"/>";
        return string;
    }

    public ItemData(String string) {
        this.sessionID = string;
    }

    public ItemData(String string, String string2, String string3, int n, int n2) throws Exception {
        if (string2.length() > 6) {
            throw new Exception("Item ID too long (max 6 characters)");
        }
        if (n != 0 && n != 1) {
            throw new Exception("Item mark must be either 0 or 1");
        }
        if (n2 <= 0) {
            throw new Exception("Item ordering starts from 1");
        }
        this.sessionID = string;
        this.itemID = string2;
        this.response = string3;
        this.mark = n;
        this.order = n2;
    }
}

