/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.datacapture;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import net.dialang.datacapture.VSPTData;

public class VSPTData {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private ArrayList vsptRecords;
    private String sessionID;

    public void addVSPTEntry(String string, String string2, int n) throws Exception {
        if (string.length() > 6) {
            throw new Exception("VSPT ID too long (max 6 characters)");
        }
        if (n != 0 && n != 1) {
            throw new Exception("VSPT mark must be either 0 or 1");
        }
        VSPTData vSPTData = this;
        if (vSPTData == null) {
            throw null;
        }
        this.vsptRecords.add(vSPTData.new VSPTRecord(null, this.sessionID, string, string2, n));
    }

    public void dump(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        printWriter.print(this.toString());
    }

    public String toString() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<vspt_data session_id=\"" + this.sessionID + "\">\n";
        Iterator iterator = ((AbstractList)this.vsptRecords).iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next();
        }
        string = string + "</vspt_data>";
        return string;
    }

    public VSPTData(String string, int n) {
        this.sessionID = string;
        this.vsptRecords = new ArrayList(n);
    }

    private class VSPTRecord {
        private String sessionID;
        private String vsptID;
        private String response;
        private int mark;

        public String toString() {
            String string = "<vspt_record session_id=\"" + this.sessionID + "\" vspt_id=\"" + this.vsptID + "\" response=\"" + this.response + "\" mark=\"" + Integer.toString(this.mark) + "\"/>\n";
            return string;
        }

        private VSPTRecord(String string, String string2, String string3, int n) {
            this.sessionID = string;
            this.vsptID = string2;
            this.response = string3;
            this.mark = n;
        }

        /* synthetic */ VSPTRecord(1 var2_2, String string, String string2, String string3, int n) {
            this(string, string2, string3, n);
        }
    }
}

