/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.entity;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import net.dialang.common.SAWeights;
import net.dialang.common.TriState;
import net.dialang.entity.ALS;
import net.dialang.entity.Entity;
import net.dialang.entity.Skill;

public class SA
extends Entity
implements Serializable {
    private Vector sa = new Vector();
    private boolean locked;

    public static String makeKey(ALS aLS, Skill skill) {
        return SA.makeKey(aLS.getVocabSubKey(), skill.getVocabSubKey());
    }

    public static String makeKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("#");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String getID() {
        return this.getVocabSubKey();
    }

    public void lock() {
        this.locked = true;
    }

    public int size() {
        return this.sa.size();
    }

    public Enumeration elements() {
        return this.sa.elements();
    }

    public Record get(int n) {
        return (Record)this.sa.get(n);
    }

    public void add(String string, String string2) throws IllegalAccessException {
        if (this.locked) {
            throw new IllegalAccessException("is locked");
        }
        this.sa.add(new Record(string, string2));
    }

    public void add(Record record) throws IllegalAccessException {
        if (this.locked) {
            throw new IllegalAccessException("is locked");
        }
        this.sa.add(record);
    }

    public void reset() {
        Enumeration enumeration = this.sa.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            record.setState(TriState.UNSET);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("size: ");
        stringBuffer.append(this.size());
        stringBuffer.append('\n');
        Enumeration enumeration = this.sa.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            stringBuffer.append(record.toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int getRawScore(SAWeights sAWeights) {
        int n = 0;
        Enumeration enumeration = this.sa.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            if (record.state != TriState.TRUE) continue;
            int n2 = sAWeights.getWeight(record.id);
            n += n2;
        }
        return n;
    }

    public int getWeight(SAWeights sAWeights) {
        int n = 0;
        Enumeration enumeration = this.sa.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            n += sAWeights.getWeight(record.id);
        }
        return n;
    }

    public SA() {
    }

    public SA(String string, String string2) {
        super(SA.makeKey(string, string2));
    }

    public class Record
    implements Serializable {
        static final long serialVersionUID = -2597276361298474967L;
        private String id;
        private String text;
        private TriState state;

        public void setID(String string) {
            this.id = string;
        }

        public String getID() {
            return this.id;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public void setState(TriState triState) {
            this.state = triState;
        }

        public TriState getState() {
            return this.state;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("id ");
            stringBuffer.append(this.id);
            stringBuffer.append(" state ");
            stringBuffer.append(this.state);
            stringBuffer.append("\ntext [");
            stringBuffer.append(this.text);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public Record(String string, String string2) {
            this.id = string;
            this.text = string2;
            this.state = TriState.UNSET;
        }
    }
}

