/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.entity;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import net.dialang.common.TriState;
import net.dialang.entity.Entity;
import net.dialang.entity.VSPT;

public class VSPTFeedback
implements Serializable {
    private Vector scale = new Vector();

    public void addRange(int n, int n2, String string) {
        Record record = new Record(n, n2, string);
        this.scale.add(record);
    }

    public int size() {
        return this.scale.size();
    }

    public Enumeration elements() {
        return this.scale.elements();
    }

    public String getVocabSubKey(int n) {
        Enumeration enumeration = this.scale.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            if (n < record.getLow() || n > record.getHigh()) continue;
            return record.getVocabSubKey();
        }
        return null;
    }

    public static float getZScore(Vector vector) {
        float f;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            VSPT.Record record = (VSPT.Record)enumeration.nextElement();
            int n = record.isValid();
            if (record.getState() == TriState.UNSET) continue;
            if (record.getState() == TriState.TRUE) {
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
                continue;
            }
            if (record.getState() != TriState.FALSE) continue;
            int n3 = n;
            nArray2[n3] = nArray2[n3] + 1;
        }
        int n = nArray[1] + nArray2[1];
        int n4 = nArray[0] + nArray2[0];
        int n5 = nArray[1];
        int n6 = nArray[0];
        if (n5 == 0) {
            return 0.0f;
        }
        try {
            float f2 = (float)n5 / (float)n;
            float f3 = (float)n6 / (float)n4;
            f = (f2 - f3) * (1.0f + f2 - f3) / (f2 * (1.0f - f3)) - 1.0f;
        }
        catch (ArithmeticException arithmeticException) {
            return 0.0f;
        }
        return f;
    }

    public static int getScore(Vector vector) {
        float f = VSPTFeedback.getZScore(vector);
        if (f <= 0.0f) {
            return 0;
        }
        return (int)((double)f * 1000.0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            ++n;
            stringBuffer.append(record.toString());
            stringBuffer.append('\n');
        }
        stringBuffer.append("members in list " + n);
        return stringBuffer.toString();
    }

    public class Record
    extends Entity
    implements Serializable {
        static final long serialVersionUID = -8697074538094923338L;
        private int low;
        private int high;

        public int getLow() {
            return this.low;
        }

        public int getHigh() {
            return this.high;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("low ");
            stringBuffer.append(this.low);
            stringBuffer.append(" high ");
            stringBuffer.append(this.high);
            return stringBuffer.toString();
        }

        public Record(int n, int n2, String string) {
            super(string);
            this.low = n;
            this.high = n2;
        }
    }
}

